/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.profile.web.UserProfileEntity;
import com.silverpeas.profile.web.UserProfileExtendedEntity;
import com.silverpeas.profile.web.UserProfileService;
import com.silverpeas.profile.web.UserProfilesSearchCriteriaBuilder;
import com.silverpeas.socialnetwork.relationShip.RelationShip;
import com.silverpeas.socialnetwork.relationShip.RelationShipService;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserDetailsSearchCriteria;
import com.stratelia.webactiv.beans.admin.UserFull;
import java.net.URI;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.util.ListSlice;

@Service
@RequestScoped
@Path(value="profile/users")
@Authenticated
public class UserProfileResource
extends RESTWebService {
    public static final String RESPONSE_HEADER_USERSIZE = "X-Silverpeas-UserSize";
    public static final String QUERY_ALL_GROUPS = "all";
    @Inject
    private UserProfileService profileService;
    @Inject
    private RelationShipService relationShipService;

    @GET
    @Produces(value={"application/json"})
    public Response getUsers(@QueryParam(value="id") Set<String> userIds, @QueryParam(value="group") String groupId, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain, @QueryParam(value="accessLevel") Set<UserAccessLevel> accessLevels) {
        String domainId;
        String string = domainId = "-1".equals(domain) ? null : domain;
        if (StringUtil.isDefined((String)groupId) && !groupId.equals(QUERY_ALL_GROUPS)) {
            Group group = this.profileService.getGroupAccessibleToUser(groupId, this.getUserDetail());
            domainId = group.getDomainId();
        }
        if (this.getUserDetail().isDomainRestricted()) {
            domainId = this.getUserDetail().getDomainId();
        }
        UserProfilesSearchCriteriaBuilder criteriaBuilder = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withDomainId(domainId).withGroupId(groupId).withName(name).withPaginationPage(this.fromPage(page));
        if (CollectionUtil.isNotEmpty(userIds)) {
            criteriaBuilder.withUserIds(userIds.toArray(new String[userIds.size()]));
        }
        if (CollectionUtil.isNotEmpty(accessLevels)) {
            criteriaBuilder.withAccessLevels(accessLevels.toArray(new UserAccessLevel[accessLevels.size()]));
        }
        ListSlice users = this.getOrganisationController().searchUsers(criteriaBuilder.build());
        return Response.ok((Object)this.asWebEntity((List<? extends UserDetail>)users, UserProfileResource.locatedAt(this.getUriInfo().getAbsolutePath()))).header(RESPONSE_HEADER_USERSIZE, (Object)users.getOriginalListSize()).build();
    }

    @GET
    @Path(value="{userId}")
    @Produces(value={"application/json"})
    public UserProfileEntity getUser(@PathParam(value="userId") String userId, @QueryParam(value="extended") boolean extended) {
        URI uri = UserProfileResource.identifiedBy(this.getUriInfo().getAbsolutePath());
        if (extended) {
            return this.asWebEntity(this.getUserFullMatching(userId), uri);
        }
        return this.asWebEntity(this.getUserDetailMatching(userId), uri);
    }

    @GET
    @Path(value="application/{instanceId}")
    public Response getApplicationUsers(@PathParam(value="instanceId") String instanceId, @QueryParam(value="group") String groupId, @QueryParam(value="roles") String roles, @QueryParam(value="resource") String resource, @QueryParam(value="name") String name, @QueryParam(value="page") String page) {
        String[] roleNames = StringUtil.isDefined((String)roles) ? roles.split(",") : null;
        String domainId = null;
        if (StringUtil.isDefined((String)groupId) && !groupId.equals(QUERY_ALL_GROUPS)) {
            Group group = this.profileService.getGroupAccessibleToUser(groupId, this.getUserDetail());
            domainId = group.getDomainId();
        }
        if (this.getUserDetail().isDomainRestricted()) {
            domainId = this.getUserDetail().getDomainId();
        }
        UserDetailsSearchCriteria criteria = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withDomainId(domainId).withComponentInstanceId(instanceId).withRoles(roleNames).withResourceId(resource).withGroupId(groupId).withName(name).withPaginationPage(this.fromPage(page)).build();
        ListSlice users = this.getOrganisationController().searchUsers(criteria);
        URI usersUri = this.getUriInfo().getBaseUriBuilder().path("profile/users").build(new Object[0]);
        return Response.ok((Object)this.asWebEntity((List<? extends UserDetail>)users, UserProfileResource.locatedAt(usersUri))).header(RESPONSE_HEADER_USERSIZE, (Object)users.getOriginalListSize()).build();
    }

    @GET
    @Path(value="{userId}/contacts")
    @Produces(value={"application/json"})
    public Response getUserContacts(@PathParam(value="userId") String userId, @QueryParam(value="application") String instanceId, @QueryParam(value="roles") String roles, @QueryParam(value="resource") String resource, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain) {
        ListSlice contacts;
        String domainId = "-1".equals(domain) ? null : domain;
        UserDetail theUser = this.getUserDetailMatching(userId);
        String[] roleNames = StringUtil.isDefined((String)roles) ? roles.split(",") : null;
        String[] contactIds = this.getContactIds(theUser.getId());
        if (contactIds.length > 0) {
            UserDetailsSearchCriteria criteria = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withComponentInstanceId(instanceId).withDomainId(domainId).withRoles(roleNames).withResourceId(resource).withUserIds(contactIds).withName(name).withPaginationPage(this.fromPage(page)).build();
            contacts = this.getOrganisationController().searchUsers(criteria);
        } else {
            contacts = new ListSlice(0, 0, 0);
        }
        URI usersUri = this.getUriInfo().getBaseUriBuilder().path("profile/users").build(new Object[0]);
        return Response.ok((Object)this.asWebEntity((List<? extends UserDetail>)contacts, UserProfileResource.locatedAt(usersUri))).header(RESPONSE_HEADER_USERSIZE, (Object)contacts.getOriginalListSize()).build();
    }

    @Override
    public String getComponentId() {
        throw new UnsupportedOperationException("The UserProfileResource doesn't belong to any component instances");
    }

    protected static URI locatedAt(URI uri) {
        return uri;
    }

    protected static URI identifiedBy(URI uri) {
        return uri;
    }

    private UserProfileEntity[] asWebEntity(List<? extends UserDetail> allUsers, URI baseUri) {
        return UserProfileEntity.fromUsers(allUsers, baseUri);
    }

    private UserProfileEntity asWebEntity(UserDetail user, URI userUri) {
        return UserProfileEntity.fromUser(user).withAsUri(userUri);
    }

    private UserProfileExtendedEntity asWebEntity(UserFull user, URI userUri) {
        return UserProfileExtendedEntity.fromUser(user).withAsUri(userUri);
    }

    private UserDetail getUserDetailById(String userId) {
        UserDetail theUser = UserDetail.getById((String)userId);
        this.checkUser(userId, theUser);
        return theUser;
    }

    private UserFull getUserFullById(String userId) {
        UserFull theUser = UserFull.getById((String)userId);
        this.checkUser(userId, (UserDetail)theUser);
        return theUser;
    }

    private void checkUser(String userId, UserDetail theUser) {
        if (theUser == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!theUser.isAccessAdmin() && this.getUserDetail().isDomainRestricted() && !theUser.getDomainId().equals(this.getUserDetail().getDomainId())) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The user with id {0} isn''t authorized to access the profile of user with id {1}", new Object[]{theUser.getId(), userId});
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private String[] getContactIds(String userId) {
        try {
            int myId = Integer.valueOf(userId);
            List relationShips = this.relationShipService.getAllMyRelationShips(myId);
            String[] userIds = new String[relationShips.size()];
            for (int i = 0; i < relationShips.size(); ++i) {
                RelationShip relationShip = (RelationShip)relationShips.get(i);
                userIds[i] = relationShip.getUser1Id() != myId ? String.valueOf(relationShip.getUser1Id()) : String.valueOf(relationShip.getUser2Id());
            }
            return userIds;
        }
        catch (SQLException ex) {
            Logger.getLogger(UserProfileResource.class.getName()).log(Level.SEVERE, null, ex);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private UserDetail getUserDetailMatching(String identifier) {
        if (identifier.equals("me")) {
            return this.getUserDetail();
        }
        return this.getUserDetailById(identifier);
    }

    private UserFull getUserFullMatching(String identifier) {
        if (identifier.equals("me")) {
            return this.getUserFullById(this.getUserDetail().getId());
        }
        return this.getUserFullById(identifier);
    }

    private PaginationPage fromPage(String page) {
        PaginationPage paginationPage = null;
        if (page != null && !page.isEmpty()) {
            String[] pageAttributes = page.split(";");
            int nth = Integer.valueOf(pageAttributes[0]);
            int count = Integer.valueOf(pageAttributes[1]);
            paginationPage = new PaginationPage(nth, count);
        }
        return paginationPage;
    }
}

