/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.profile.web;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.PaginationPage;
import com.stratelia.webactiv.beans.admin.UserDetailsSearchCriteria;
import org.silverpeas.admin.user.constant.UserAccessLevel;

public class UserProfilesSearchCriteriaBuilder {
    private UserDetailsSearchCriteria searchCriteria = new UserDetailsSearchCriteria();

    public static UserProfilesSearchCriteriaBuilder aSearchCriteria() {
        return new UserProfilesSearchCriteriaBuilder();
    }

    public UserProfilesSearchCriteriaBuilder withName(String name) {
        if (StringUtil.isDefined((String)name)) {
            String filterByName = name.replaceAll("\\*", "%");
            this.searchCriteria.onName(filterByName);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withComponentInstanceId(String instanceId) {
        if (StringUtil.isDefined((String)instanceId)) {
            this.searchCriteria.onComponentInstanceId(instanceId);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withResourceId(String resourceId) {
        if (StringUtil.isDefined((String)resourceId)) {
            this.searchCriteria.onResourceId(resourceId);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withRoles(String[] roleIds) {
        if (roleIds != null && roleIds.length > 0) {
            this.searchCriteria.onRoleNames(roleIds);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withGroupId(String groupId) {
        if (StringUtil.isDefined((String)groupId)) {
            if (groupId.equals("all")) {
                this.searchCriteria.onGroupIds(UserDetailsSearchCriteria.ANY_GROUPS);
            } else {
                this.searchCriteria.onGroupIds(new String[]{groupId});
            }
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withDomainId(String domainId) {
        if (StringUtil.isDefined((String)domainId) && Integer.valueOf(domainId) >= 0) {
            this.searchCriteria.onDomainId(domainId);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withAccessLevels(UserAccessLevel[] accessLevels) {
        if (accessLevels != null && accessLevels.length > 0) {
            this.searchCriteria.onAccessLevels(accessLevels);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withUserIds(String[] userIds) {
        if (userIds != null && userIds.length > 0) {
            this.searchCriteria.onUserIds(userIds);
        }
        return this;
    }

    public UserProfilesSearchCriteriaBuilder withPaginationPage(PaginationPage page) {
        this.searchCriteria.onPagination(page);
        return this;
    }

    public UserDetailsSearchCriteria build() {
        return this.searchCriteria;
    }

    private UserProfilesSearchCriteriaBuilder() {
    }
}

