/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.search;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.search.ResultDisplayer;
import com.silverpeas.search.ResultSearchRendererUtil;
import com.silverpeas.search.SearchResultContentVO;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.pdcPeas.model.GlobalSilverResult;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.util.DateUtil;

public abstract class AbstractResultDisplayer
implements ResultDisplayer {
    protected SilverpeasTemplate setCommonAttributes(SearchResultContentVO searchResult, SilverpeasTemplate componentTemplate) {
        String sCreatorName;
        String location;
        GlobalSilverResult silverResult = searchResult.getGsr();
        ResourcesWrapper settings = searchResult.getSettings();
        componentTemplate.setAttribute("gsr", (Object)silverResult);
        componentTemplate.setAttribute("name", (Object)EncodeHelper.javaStringToHtmlString((String)silverResult.getName()));
        String sDescription = silverResult.getDescription();
        if (sDescription != null && sDescription.length() > 400) {
            sDescription = sDescription.substring(0, 400) + "...";
        }
        if (StringUtil.isDefined((String)sDescription)) {
            componentTemplate.setAttribute("description", (Object)EncodeHelper.javaStringToHtmlParagraphe((String)sDescription));
        }
        componentTemplate.setAttribute("url", (Object)silverResult.getTitleLink());
        String sDownload = silverResult.getDownloadLink();
        if (StringUtil.isDefined((String)sDownload)) {
            componentTemplate.setAttribute("downloadUrl", (Object)sDownload);
        }
        if (StringUtil.isDefined((String)(location = silverResult.getLocation()))) {
            componentTemplate.setAttribute("location", (Object)EncodeHelper.javaStringToHtmlString((String)location));
        }
        if (StringUtil.isDefined((String)(sCreatorName = silverResult.getCreatorName()))) {
            componentTemplate.setAttribute("creatorName", (Object)EncodeHelper.javaStringToHtmlString((String)sCreatorName));
        }
        componentTemplate.setAttribute("spaceId", (Object)silverResult.getSpaceId());
        componentTemplate.setAttribute("instanceId", (Object)silverResult.getInstanceId());
        String sCreationDate = null;
        try {
            sCreationDate = searchResult.getSortValue() == 4 ? DateUtil.getOutputDate((String)silverResult.getCreationDate(), (String)this.getUserPreferences(searchResult.getUserId()).getLanguage()) : DateUtil.getOutputDate((String)silverResult.getDate(), (String)this.getUserPreferences(searchResult.getUserId()).getLanguage());
        }
        catch (Exception e) {
            sCreationDate = null;
        }
        if (StringUtil.isDefined(sCreationDate)) {
            componentTemplate.setAttribute("creationDate", sCreationDate);
        }
        String serverName = "";
        if (settings.getSetting("external.search.enable", false) && silverResult.getIndexEntry() != null) {
            serverName = "external_server_" + (StringUtil.isDefined((String)silverResult.getIndexEntry().getServerName()) ? silverResult.getIndexEntry().getServerName() : "unknown");
        }
        if (StringUtil.isDefined((String)serverName)) {
            componentTemplate.setAttribute("serverName", (Object)serverName);
        }
        componentTemplate.setAttribute("pertinenceVisible", (Object)settings.getSetting("PertinenceVisible", false));
        if (settings.getSetting("PertinenceVisible", false)) {
            componentTemplate.setAttribute("pertinence", (Object)ResultSearchRendererUtil.displayPertinence(silverResult.getRawScore()));
        }
        componentTemplate.setAttribute("activeSelection", (Object)searchResult.getActiveSelection());
        componentTemplate.setAttribute("exportEnabled", (Object)searchResult.getExportEnabled());
        componentTemplate.setAttribute("type", (Object)silverResult.getType());
        return componentTemplate;
    }

    protected UserPreferences getUserPreferences(String userId) {
        return SilverpeasServiceProvider.getPersonalizationService().getUserSettings(userId);
    }
}

