/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.servlets.upload;

import com.silverpeas.servlets.upload.FileUploadListener;
import com.silverpeas.servlets.upload.MonitoringFileItemFactory;
import com.silverpeas.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class AjaxFileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = -557782586447656336L;
    private static final String UPLOAD_DIRECTORY = "UPLOAD_DIRECTORY";
    private static final String WHITE_LIST = "WHITE_LIST";
    private static final String FILE_UPLOAD_STATS = "FILE_UPLOAD_STATS";
    private static final String FILE_UPLOAD_PATHS = "FILE_UPLOAD_PATHS";
    private static final String UPLOAD_ERRORS = "UPLOAD_ERRORS";
    private static final String UPLOAD_FATAL_ERROR = "UPLOAD_FATAL_ERROR";
    private static final String SAVING_FILE_FLAG = "SAVING_FILE_FLAG";
    private static String uploadDir;
    private static String whiteList;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        uploadDir = config.getInitParameter(UPLOAD_DIRECTORY);
        whiteList = config.getInitParameter(WHITE_LIST);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        if ("status".equals(request.getParameter("q"))) {
            this.doStatus(session, response);
        } else {
            this.doFileUpload(session, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFileUpload(HttpSession session, HttpServletRequest request) throws IOException {
        try {
            session.setAttribute(UPLOAD_ERRORS, (Object)"");
            session.setAttribute(UPLOAD_FATAL_ERROR, (Object)"");
            ArrayList<String> paths = new ArrayList<String>();
            session.setAttribute(FILE_UPLOAD_PATHS, paths);
            FileUploadListener listener = new FileUploadListener(request.getContentLength());
            session.setAttribute(FILE_UPLOAD_STATS, (Object)listener.getFileUploadStats());
            MonitoringFileItemFactory factory = new MonitoringFileItemFactory(listener);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            this.startingToSaveUploadedFile(session);
            String errorMessage = "";
            for (FileItem fileItem : items) {
                if (fileItem.isFormField() || fileItem.getSize() <= 0L) continue;
                try {
                    String filename = fileItem.getName();
                    if (filename.indexOf(47) >= 0) {
                        filename = filename.substring(filename.lastIndexOf(47) + 1);
                    }
                    if (filename.indexOf(92) >= 0) {
                        filename = filename.substring(filename.lastIndexOf(92) + 1);
                    }
                    if (!this.isInWhiteList(filename)) {
                        errorMessage = errorMessage + "The file " + filename + " is not uploaded!";
                        errorMessage = errorMessage + (StringUtil.isDefined((String)whiteList) ? " Only " + whiteList.replaceAll(" ", ", ") + " file types can be uploaded<br/>" : " No allowed file format has been defined for upload<br/>");
                        session.setAttribute(UPLOAD_ERRORS, (Object)errorMessage);
                        continue;
                    }
                    filename = System.currentTimeMillis() + "-" + filename;
                    File targetDirectory = new File(uploadDir, fileItem.getFieldName());
                    targetDirectory.mkdirs();
                    File uploadedFile = new File(targetDirectory, filename);
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(uploadedFile);
                        IOUtils.copy((InputStream)fileItem.getInputStream(), (OutputStream)out);
                        paths.add(uploadedFile.getParentFile().getName() + '/' + uploadedFile.getName());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                finally {
                    fileItem.delete();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getSimpleName()).log(Level.WARNING, e.getMessage());
            session.setAttribute(UPLOAD_FATAL_ERROR, (Object)"Could not process uploaded file. Please see log for details.");
        }
        finally {
            this.endingToSaveUploadedFile(session);
        }
    }

    private synchronized void startingToSaveUploadedFile(HttpSession session) {
        session.setAttribute(SAVING_FILE_FLAG, (Object)SAVING_FILE_FLAG);
    }

    private synchronized void endingToSaveUploadedFile(HttpSession session) {
        session.setAttribute(SAVING_FILE_FLAG, null);
    }

    private synchronized boolean isSavingUploadedFile(HttpSession session) {
        return session.getAttribute(SAVING_FILE_FLAG) != null;
    }

    private void doStatus(HttpSession session, HttpServletResponse response) throws IOException {
        boolean isSavingUploadedFiles = this.isSavingUploadedFile(session);
        Long bytesProcessed = null;
        Long totalSize = null;
        FileUploadListener.FileUploadStats fileUploadStats = (FileUploadListener.FileUploadStats)session.getAttribute(FILE_UPLOAD_STATS);
        if (fileUploadStats != null) {
            bytesProcessed = fileUploadStats.getBytesRead();
            totalSize = fileUploadStats.getTotalSize();
        }
        response.addHeader("Expires", "0");
        response.addHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.addHeader("Pragma", "no-cache");
        String fatalError = (String)session.getAttribute(UPLOAD_FATAL_ERROR);
        if (StringUtil.isDefined((String)fatalError)) {
            List paths = (List)session.getAttribute(FILE_UPLOAD_PATHS);
            String uploadedFilePaths = this.getUploadedFilePaths(paths);
            response.getWriter().println("<b>Upload uncomplete.</b>");
            response.getWriter().println("<script type='text/javascript'>window.parent.stop('" + fatalError + "', " + uploadedFilePaths + "); stop('', " + uploadedFilePaths + ");</script>");
            return;
        }
        if (bytesProcessed != null) {
            long percentComplete = (long)Math.floor(bytesProcessed.doubleValue() / totalSize.doubleValue() * 100.0);
            response.getWriter().println("<b>Upload Status:</b><br/>");
            if (!bytesProcessed.equals(totalSize)) {
                response.getWriter().println("<div class=\"prog-border\"><div class=\"prog-bar\" style=\"width: " + percentComplete + "%;\"></div></div>");
            } else {
                response.getWriter().println("<div class=\"prog-border\"><div class=\"prog-bar\" style=\"width: 100%;\"></div></div>");
                if (!isSavingUploadedFiles) {
                    List paths = (List)session.getAttribute(FILE_UPLOAD_PATHS);
                    String uploadedFilePaths = this.getUploadedFilePaths(paths);
                    String errors = (String)session.getAttribute(UPLOAD_ERRORS);
                    if (StringUtil.isDefined((String)errors)) {
                        response.getWriter().println("<b>Upload complete with error(s).</b><br/>");
                    } else {
                        response.getWriter().println("<b>Upload complete.</b><br/>");
                        errors = "";
                    }
                    response.getWriter().println("<script type='text/javascript'>window.parent.stop('" + errors + "', " + uploadedFilePaths + ");</script>");
                }
            }
        }
    }

    private String getUploadedFilePaths(List<String> paths) throws IOException {
        if (paths == null) {
            paths = new ArrayList<String>();
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(paths);
    }

    private List<String> getWhiteList() {
        if (StringUtil.isDefined((String)whiteList)) {
            return Arrays.asList(whiteList.split(" "));
        }
        return Arrays.asList(new Object[0]);
    }

    private boolean isInWhiteList(String filename) {
        List<String> whileList = this.getWhiteList();
        String extension = FilenameUtils.getExtension((String)filename).toLowerCase();
        return whileList.contains(extension);
    }
}

