/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.servlets.upload;

import com.silverpeas.servlets.upload.OutputStreamListener;

public class FileUploadListener
implements OutputStreamListener {
    private final FileUploadStats fileUploadStats = new FileUploadStats();

    public FileUploadListener(long totalSize) {
        this.fileUploadStats.setTotalSize(totalSize);
    }

    @Override
    public void begin() {
        this.fileUploadStats.setCurrentStatus("begin");
    }

    @Override
    public void readBytes(int byteCount) {
        this.fileUploadStats.incrementBytesRead(byteCount);
        this.fileUploadStats.setCurrentStatus("reading");
    }

    @Override
    public void error(String s) {
        this.fileUploadStats.setCurrentStatus("error");
    }

    @Override
    public void end() {
        this.fileUploadStats.setBytesRead(this.fileUploadStats.getTotalSize());
        this.fileUploadStats.setCurrentStatus("end");
    }

    public FileUploadStats getFileUploadStats() {
        return this.fileUploadStats;
    }

    public static class FileUploadStats {
        private long totalSize = 0L;
        private long bytesRead = 0L;
        private final long startTime = System.currentTimeMillis();
        private String currentStatus = "none";

        public long getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getElapsedTimeInSeconds() {
            return (System.currentTimeMillis() - this.startTime) / 1000L;
        }

        public String getCurrentStatus() {
            return this.currentStatus;
        }

        public void setCurrentStatus(String currentStatus) {
            this.currentStatus = currentStatus;
        }

        public void setBytesRead(long bytesRead) {
            this.bytesRead = bytesRead;
        }

        public void incrementBytesRead(int byteCount) {
            this.bytesRead += (long)byteCount;
        }
    }
}

