/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.servlets.upload;

import com.silverpeas.servlets.upload.OutputStreamListener;
import java.io.IOException;
import java.io.OutputStream;

public class MonitoredOutputStream
extends OutputStream {
    private OutputStream out;
    private OutputStreamListener listener;

    public MonitoredOutputStream(OutputStream out, OutputStreamListener listener) {
        this.out = out;
        this.listener = listener;
        this.listener.begin();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.listener.readBytes(1);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.listener.end();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.listener.readBytes(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.listener.readBytes(len - off);
    }
}

