/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.model;

import com.silverpeas.sharing.model.Ticket;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="sb_filesharing_history")
public class DownloadDetail
implements Serializable {
    private static final long serialVersionUID = -3552579238204831286L;
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UNIQUE_ID_GEN")
    @TableGenerator(name="UNIQUE_ID_GEN", table="uniqueId", pkColumnName="tablename", valueColumnName="maxId", pkColumnValue="sb_filesharing_history", allocationSize=1)
    private Long id;
    @ManyToOne
    @JoinColumn(name="keyFile", columnDefinition="varchar(255)", nullable=false)
    private Ticket ticket;
    @Column(name="downloaddate", nullable=false)
    private Long downloadDate;
    @Column(name="downloadIp", nullable=false)
    private String userIP;

    public DownloadDetail() {
    }

    public DownloadDetail(Ticket ticket, Date downloadDate, String userIP) {
        this.ticket = ticket;
        this.downloadDate = downloadDate.getTime();
        this.userIP = userIP;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getKeyFile() {
        return this.ticket.getToken();
    }

    public void setKeyFile(Ticket ticket) {
        this.ticket = ticket;
    }

    public Date getDownloadDate() {
        return new Date(this.downloadDate);
    }

    public void setDownloadDate(Date downloadDate) {
        this.downloadDate = downloadDate.getTime();
    }

    public String getUserIP() {
        return this.userIP;
    }

    public void setUserIP(String userIP) {
        this.userIP = userIP;
    }
}

