/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.model;

import com.silverpeas.sharing.model.NodeTicket;
import com.silverpeas.sharing.security.AbstractShareableAccessControl;
import com.silverpeas.util.ForeignPK;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import com.stratelia.webactiv.util.publication.control.PublicationBm;
import com.stratelia.webactiv.util.publication.model.Alias;
import com.stratelia.webactiv.util.publication.model.PublicationPK;
import java.rmi.RemoteException;
import java.util.Collection;
import javax.ejb.CreateException;
import org.apache.commons.collections.CollectionUtils;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.importExport.attachment.AttachmentDetail;
import org.silverpeas.importExport.versioning.Document;

public class NodeAccessControl<R>
extends AbstractShareableAccessControl<NodeTicket, R> {
    private PublicationBm publicationBm;
    private NodeBm nodeBm;

    NodeAccessControl() {
    }

    @Override
    protected boolean isReadable(NodeTicket ticket, R accessedObject) throws Exception {
        NodePK nodePk = new NodePK(String.valueOf(ticket.getSharedObjectId()), ticket.getComponentId());
        Collection<NodePK> autorizedNodes = this.getNodeDescendants(nodePk);
        autorizedNodes.add(nodePk);
        if (accessedObject instanceof AttachmentDetail) {
            AttachmentDetail attachment = (AttachmentDetail)accessedObject;
            return this.isPublicationReadable(attachment.getForeignKey(), nodePk.getInstanceId(), autorizedNodes);
        }
        if (accessedObject instanceof SimpleDocument) {
            SimpleDocument attachment = (SimpleDocument)accessedObject;
            return this.isPublicationReadable((WAPrimaryKey)new ForeignPK(attachment.getForeignId(), attachment.getInstanceId()), nodePk.getInstanceId(), autorizedNodes);
        }
        if (accessedObject instanceof Document) {
            Document document = (Document)accessedObject;
            return this.isPublicationReadable(document.getForeignKey(), nodePk.getInstanceId(), autorizedNodes);
        }
        if (accessedObject instanceof NodeDetail) {
            NodeDetail node = (NodeDetail)accessedObject;
            return autorizedNodes.contains(node.getNodePK());
        }
        return false;
    }

    protected Collection<NodePK> getPublicationFathers(WAPrimaryKey pk) throws CreateException, RemoteException {
        return this.findPublicationBm().getAllFatherPK(new PublicationPK(pk.getId(), pk.getInstanceId()));
    }

    protected Collection<Alias> getPublicationAliases(WAPrimaryKey pk) throws CreateException, RemoteException {
        return this.findPublicationBm().getAlias(new PublicationPK(pk.getId(), pk.getInstanceId()));
    }

    protected Collection<NodePK> getNodeDescendants(NodePK pk) throws CreateException, RemoteException {
        return this.findNodeBm().getDescendantPKs(pk);
    }

    private boolean isPublicationReadable(WAPrimaryKey pk, String instanceId, Collection<NodePK> autorizedNodes) throws RemoteException, CreateException {
        if (pk.getInstanceId().equals(instanceId)) {
            Collection<NodePK> fathers = this.getPublicationFathers(pk);
            return CollectionUtils.containsAny(autorizedNodes, fathers);
        }
        Collection<Alias> aliases = this.getPublicationAliases(pk);
        for (Alias alias : aliases) {
            NodePK aliasPK = new NodePK(alias.getId(), alias.getInstanceId());
            if (!autorizedNodes.contains(aliasPK)) continue;
            return true;
        }
        return false;
    }

    private PublicationBm findPublicationBm() {
        if (this.publicationBm == null) {
            this.publicationBm = (PublicationBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.PUBLICATIONBM_EJBHOME, PublicationBm.class);
        }
        return this.publicationBm;
    }

    private NodeBm findNodeBm() {
        if (this.nodeBm == null) {
            this.nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        }
        return this.nodeBm;
    }
}

