/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.model;

import com.silverpeas.sharing.model.NodeAccessControl;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.security.ShareableAccessControl;
import com.silverpeas.sharing.security.ShareableNode;
import com.silverpeas.sharing.security.ShareableResource;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;

@Entity
@DiscriminatorValue(value="Node")
public class NodeTicket
extends Ticket {
    private static final long serialVersionUID = 8560572170859334369L;
    private static final NodeAccessControl<Object> accessControl = new NodeAccessControl();

    public NodeTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Node";
    }

    public NodeTicket(int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creator, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Node";
    }

    protected NodeTicket() {
        this.sharedObjectType = "Node";
    }

    @Override
    public ShareableAccessControl<NodeTicket, Object> getAccessControl() {
        return accessControl;
    }

    @Override
    public ShareableResource<NodeDetail> getResource() {
        NodeBm nodeBm = (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        NodeDetail node = nodeBm.getDetail(new NodePK(String.valueOf(this.getSharedObjectId()), this.getComponentId()));
        if (node != null) {
            return new ShareableNode(this.getToken(), node);
        }
        return null;
    }
}

