/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.model;

import com.silverpeas.sharing.model.SimpleFileAccessControl;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.security.ShareableAccessControl;
import com.silverpeas.sharing.security.ShareableAttachment;
import com.silverpeas.sharing.security.ShareableResource;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;
import org.silverpeas.util.UuidPk;

@Entity
@DiscriminatorValue(value="Attachment")
public class SimpleFileTicket
extends Ticket {
    private static final long serialVersionUID = -475026338727454787L;
    private static final SimpleFileAccessControl accessControl = new SimpleFileAccessControl();

    protected SimpleFileTicket() {
        this.sharedObjectType = "Attachment";
    }

    public SimpleFileTicket(int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creator, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Attachment";
    }

    public SimpleFileTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Attachment";
    }

    @Override
    public ShareableAccessControl getAccessControl() {
        return accessControl;
    }

    public SimpleFileTicket(String key, int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creator, creationDate, endDate, nbAccessMax);
        this.token = new UuidPk(key);
    }

    @Override
    public ShareableResource<SimpleDocument> getResource() {
        SimpleDocumentPK pk = new SimpleDocumentPK(null, this.getComponentId());
        pk.setOldSilverpeasId(this.getSharedObjectId());
        SimpleDocument doc = AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, null);
        if (doc != null) {
            return new ShareableAttachment(this.getToken(), doc);
        }
        return null;
    }
}

