/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.model;

import com.silverpeas.sharing.model.DownloadDetail;
import com.silverpeas.sharing.security.ShareableAccessControl;
import com.silverpeas.sharing.security.ShareableResource;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.util.UuidPk;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="shared_object_type")
@Table(name="sb_filesharing_ticket")
public abstract class Ticket
implements Serializable {
    public static final String FILE_TYPE = "Attachment";
    public static final String VERSION_TYPE = "Versionned";
    public static final String NODE_TYPE = "Node";
    private static final long serialVersionUID = -612174156104966079L;
    @Column(name="shared_object_type", nullable=false, insertable=false, updatable=false)
    protected String sharedObjectType;
    @Column(name="shared_object")
    protected long sharedObjectId;
    @Column(name="componentid")
    protected String componentId;
    @Column(name="creatorid")
    protected String creatorId;
    @Column(name="creationdate", nullable=false)
    protected Long creationDate;
    @Column(name="updateid")
    protected String updaterId;
    @Column(name="updatedate", nullable=true)
    protected Long updateDate = null;
    @Column(name="enddate", nullable=true)
    protected Long endDate = null;
    @Column(name="nbaccessmax")
    protected int nbAccessMax;
    @Column(name="nbaccess")
    protected int nbAccess;
    @AttributeOverride(name="uuid", column=@Column(name="keyfile", columnDefinition="varchar(255)", length=255))
    @EmbeddedId
    protected UuidPk token;
    @OneToMany(orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="ticket", cascade={CascadeType.REMOVE})
    protected List<DownloadDetail> downloads = new ArrayList<DownloadDetail>();

    protected Ticket() {
    }

    protected Ticket(int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        this(sharedObjectId, componentId, creator.getId(), creationDate, endDate, nbAccessMax);
    }

    protected Ticket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        this.token = new UuidPk();
        this.sharedObjectId = sharedObjectId;
        this.componentId = componentId;
        this.creatorId = creatorId;
        this.creationDate = creationDate.getTime();
        if (endDate != null) {
            this.endDate = endDate.getTime();
        }
        this.nbAccessMax = nbAccessMax;
    }

    public long getSharedObjectId() {
        return this.sharedObjectId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreator(UserDetail creator) {
        this.creatorId = creator.getId();
    }

    public Date getCreationDate() {
        return new Date(this.creationDate);
    }

    public void setLastModifier(UserDetail modifier) {
        this.updaterId = modifier.getId();
    }

    public String getLastModifier() {
        return this.updaterId;
    }

    public Date getUpdateDate() {
        if (this.updateDate != null) {
            return new Date(this.updateDate);
        }
        return null;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate != null ? Long.valueOf(updateDate.getTime()) : null;
    }

    public Date getEndDate() {
        Date date = null;
        if (this.endDate != null) {
            date = new Date(this.endDate);
        }
        return date;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate != null ? Long.valueOf(endDate.getTime()) : null;
    }

    public int getNbAccessMax() {
        return this.nbAccessMax;
    }

    public void setNbAccessMax(int nbAccessMax) {
        this.nbAccessMax = nbAccessMax;
    }

    public int getNbAccess() {
        return this.nbAccess;
    }

    public void setNbAccess(int nbAccess) {
        this.nbAccess = nbAccess;
    }

    public String getToken() {
        return this.token.getUuid();
    }

    public void setToken(String uuid) {
        this.token = new UuidPk(uuid);
    }

    public List<DownloadDetail> getDownloads() {
        return Collections.unmodifiableList(this.downloads);
    }

    public void setDownloads(Collection<DownloadDetail> downloads) {
        this.downloads.clear();
        this.downloads.addAll(downloads);
    }

    public String getUrl(HttpServletRequest request) {
        return URLManager.getFullApplicationURL((HttpServletRequest)request) + this.getRelativeUrl();
    }

    private String getRelativeUrl() {
        return "/Ticket?Key=" + this.getToken();
    }

    public boolean isValid() {
        if (StringUtil.isDefined((String)this.getToken())) {
            boolean isValid = true;
            if (this.getEndDate() != null) {
                isValid &= this.getEndDate().after(new Date());
            }
            if (this.getNbAccessMax() > 0) {
                isValid &= this.getNbAccess() < this.getNbAccessMax();
            }
            return isValid;
        }
        return false;
    }

    public boolean isModified() {
        return this.updateDate != null && StringUtil.isDefined((String)this.updaterId);
    }

    public boolean isContinuous() {
        return this.nbAccessMax <= 0 && this.endDate == null;
    }

    public void setContinuous() {
        this.endDate = null;
        this.nbAccessMax = -1;
    }

    public String getSharedObjectType() {
        return this.sharedObjectType;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.token != null ? this.token.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ticket other = (Ticket)obj;
        return this.token == other.token || this.token != null && this.token.equals((Object)other.token);
    }

    public String toString() {
        return "Ticket{sharedObjectType=" + this.sharedObjectType + ", sharedObjectId=" + this.sharedObjectId + ", componentId=" + this.componentId + ", creatorId=" + this.creatorId + ", creationDate=" + this.creationDate + ", updaterId=" + this.updaterId + ", updateDate=" + this.updateDate + ", endDate=" + this.endDate + ", nbAccessMax=" + this.nbAccessMax + ", nbAccess=" + this.nbAccess + ", token=" + this.token + ", downloads=" + this.downloads + '}';
    }

    public void addDownload() {
        ++this.nbAccess;
    }

    public abstract ShareableAccessControl getAccessControl();

    public abstract ShareableResource getResource();
}

