/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.model;

import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.model.VersionFileAccessControl;
import com.silverpeas.sharing.security.ShareableAccessControl;
import com.silverpeas.sharing.security.ShareableResource;
import com.silverpeas.sharing.security.ShareableVersionDocument;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Date;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.AttachmentServiceFactory;
import org.silverpeas.attachment.model.HistorisedDocument;
import org.silverpeas.attachment.model.SimpleDocumentPK;

@Entity
@DiscriminatorValue(value="Versionned")
public class VersionFileTicket
extends Ticket {
    private static final long serialVersionUID = 7046398587440076818L;
    private static final VersionFileAccessControl accessControl = new VersionFileAccessControl();

    public VersionFileTicket(int sharedObjectId, String componentId, String creatorId, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creatorId, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Versionned";
    }

    public VersionFileTicket(int sharedObjectId, String componentId, UserDetail creator, Date creationDate, Date endDate, int nbAccessMax) {
        super(sharedObjectId, componentId, creator, creationDate, endDate, nbAccessMax);
        this.sharedObjectType = "Versionned";
    }

    protected VersionFileTicket() {
        this.sharedObjectType = "Versionned";
    }

    public HistorisedDocument getDocument() {
        try {
            SimpleDocumentPK pk = new SimpleDocumentPK("" + this.getSharedObjectId(), this.getComponentId());
            pk.setOldSilverpeasId(this.getSharedObjectId());
            return (HistorisedDocument)AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, null);
        }
        catch (AttachmentException e) {
            SilverTrace.error((String)"fileSharing", (String)"Ticket.getDocument", (String)"root.MSG_GEN_PARAM_VALUE", (Throwable)e);
            return null;
        }
    }

    @Override
    public ShareableResource<HistorisedDocument> getResource() {
        try {
            SimpleDocumentPK pk = new SimpleDocumentPK("" + this.getSharedObjectId(), this.getComponentId());
            pk.setOldSilverpeasId(this.getSharedObjectId());
            HistorisedDocument doc = (HistorisedDocument)AttachmentServiceFactory.getAttachmentService().searchDocumentById(pk, null);
            if (doc != null) {
                return new ShareableVersionDocument(this.getToken(), doc);
            }
        }
        catch (AttachmentException e) {
            SilverTrace.error((String)"fileSharing", (String)"Ticket.getDocument", (String)"root.MSG_GEN_PARAM_VALUE", (Throwable)e);
        }
        return null;
    }

    @Override
    public ShareableAccessControl<VersionFileTicket, HistorisedDocument> getAccessControl() {
        return accessControl;
    }
}

