/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.security;

import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.security.ShareableAccessControl;
import com.silverpeas.sharing.security.ShareableResource;
import com.silverpeas.sharing.services.SharingServiceFactory;

public abstract class AbstractShareableAccessControl<T extends Ticket, R>
implements ShareableAccessControl<T, R> {
    protected AbstractShareableAccessControl() {
    }

    @Override
    public final boolean isReadable(ShareableResource<R> resource) {
        try {
            Ticket ticket = SharingServiceFactory.getSharingTicketService().getTicket(resource.getToken());
            return ticket != null && ticket.isValid() && this.isReadable(ticket, resource.getAccessedObject());
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract boolean isReadable(T var1, R var2) throws Exception;
}

