/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.sharing.services;

import com.silverpeas.annotation.Service;
import com.silverpeas.sharing.model.DownloadDetail;
import com.silverpeas.sharing.model.Ticket;
import com.silverpeas.sharing.repository.DownloadDetailRepository;
import com.silverpeas.sharing.repository.TicketRepository;
import com.silverpeas.sharing.services.SharingTicketService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.util.UuidPk;
import org.springframework.transaction.annotation.Transactional;

@Named(value="sharingTicketService")
@Service
@Transactional
public class JpaSharingTicketService
implements SharingTicketService {
    @Inject
    TicketRepository repository;
    @Inject
    DownloadDetailRepository historyRepository;

    @Override
    public List<Ticket> getTicketsByUser(String userId) {
        List<Ticket> tickets = this.repository.findAllReservationsForUser(userId);
        return tickets;
    }

    @Override
    public void deleteTicketsForSharedObject(Long sharedObjectId, String type) {
        List<Ticket> tickets = this.repository.findAllTicketForSharedObjectId(sharedObjectId, type);
        this.repository.delete(tickets);
        this.repository.flush();
    }

    @Override
    public Ticket getTicket(String key) {
        return (Ticket)this.repository.findOne((Serializable)new UuidPk(key));
    }

    @Override
    public String createTicket(Ticket ticket) {
        Ticket result = (Ticket)this.repository.saveAndFlush(ticket);
        return result.getToken();
    }

    @Override
    public void addDownload(DownloadDetail download) {
        Ticket ticket = (Ticket)this.repository.findOne((Serializable)new UuidPk(download.getKeyFile()));
        if (ticket != null) {
            ArrayList<DownloadDetail> downloads = new ArrayList<DownloadDetail>(ticket.getDownloads());
            downloads.add(download);
            ticket.setDownloads(downloads);
            this.historyRepository.saveAndFlush(download);
            ticket.addDownload();
            this.repository.saveAndFlush(ticket);
        }
    }

    @Override
    public void updateTicket(Ticket ticket) {
        this.repository.saveAndFlush(ticket);
    }

    @Override
    public void deleteTicket(String key) {
        this.repository.delete((Serializable)new UuidPk(key));
    }
}

