/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.authentication;

import com.silverpeas.admin.service.UserService;
import com.silverpeas.admin.service.UserServiceProvider;
import com.silverpeas.socialnetwork.connectors.SocialNetworkConnector;
import com.silverpeas.socialnetwork.model.ExternalAccount;
import com.silverpeas.socialnetwork.model.SocialNetworkID;
import com.silverpeas.socialnetwork.service.AccessToken;
import com.silverpeas.socialnetwork.service.SocialNetworkAuthorizationException;
import com.silverpeas.socialnetwork.service.SocialNetworkService;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.authentication.verifier.UserCanLoginVerifier;
import org.silverpeas.servlets.credentials.RegistrationSettings;
import org.springframework.social.connect.UserProfile;

public class SocialNetworkLoginController
extends HttpServlet {
    private static final long serialVersionUID = 3019716885114707069L;
    private UserService userService = null;
    private RegistrationSettings registrationSettings = null;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processLogin(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processLogin(req, resp);
    }

    public void init() throws ServletException {
        super.init();
        this.userService = UserServiceProvider.getInstance().getService();
        this.registrationSettings = RegistrationSettings.getSettings();
    }

    private void processLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String command = req.getParameter("command");
        if (command == null) {
            SocialNetworkID networkId = SocialNetworkID.valueOf((String)req.getParameter("networkId"));
            String authenticateURL = this.getAuthenticateURL(networkId, req);
            resp.sendRedirect(authenticateURL);
        } else if ("backFromSocialNetworkAuthentication".equals(command)) {
            AccessToken authorizationToken;
            SocialNetworkID networkId = SocialNetworkID.valueOf((String)req.getParameter("networkId"));
            SocialNetworkConnector connector = this.getSocialNetworkConnector(networkId);
            try {
                authorizationToken = connector.exchangeForAccessToken(req, this.getRedirectURL(networkId, req));
            }
            catch (SocialNetworkAuthorizationException e) {
                resp.sendRedirect("/Login.jsp");
                return;
            }
            String profileId = connector.getUserProfileId(authorizationToken);
            ExternalAccount account = SocialNetworkService.getInstance().getExternalAccount(networkId, profileId);
            if (account != null) {
                UserCanLoginVerifier userStateVerifier = AuthenticationUserVerifierFactory.getUserCanLoginVerifier((String)account.getSilverpeasUserId());
                try {
                    userStateVerifier.verify();
                }
                catch (AuthenticationException e) {
                    SocialNetworkService.getInstance().removeAuthorizationToken(req.getSession(false));
                    resp.sendRedirect(URLManager.getFullApplicationURL((HttpServletRequest)req) + userStateVerifier.getErrorDestination());
                    return;
                }
            }
            SocialNetworkService.getInstance().storeAuthorizationToken(req.getSession(true), networkId, authorizationToken);
            if (account == null) {
                if (this.registrationSettings.isUserSelfRegistrationEnabled()) {
                    UserProfile profile = connector.getUserProfile(authorizationToken);
                    req.setAttribute("userProfile", (Object)profile);
                    req.setAttribute("networkId", (Object)networkId);
                    req.getRequestDispatcher("/admin/jsp/registerFromRemoteSocialNetwork.jsp").forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    SocialNetworkService.getInstance().removeAuthorizationToken(req.getSession(false));
                    resp.sendRedirect(URLManager.getFullApplicationURL((HttpServletRequest)req) + "/Login.jsp?ErrorCode=5");
                }
            } else {
                RequestDispatcher dispatcher = req.getRequestDispatcher("/AuthenticationServlet");
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
            }
        } else if ("register".equals(command)) {
            SocialNetworkID networkId = SocialNetworkID.valueOf((String)req.getParameter("networkId"));
            SocialNetworkConnector socialNetworkConnector = this.getSocialNetworkConnector(networkId);
            String firstName = req.getParameter("firstName");
            String lastName = req.getParameter("lastName");
            String email = req.getParameter("email");
            try {
                String userId = this.userService.registerUser(firstName, lastName, email, "0");
                AccessToken authorizationToken = SocialNetworkService.getInstance().getStoredAuthorizationToken(req.getSession(true), networkId);
                String profileId = socialNetworkConnector.getUserProfileId(authorizationToken);
                SocialNetworkService.getInstance().createExternalAccount(networkId, userId, profileId);
            }
            catch (AdminException e) {
                SilverTrace.error((String)"socialNetwork", (String)"SocialNetworkLoginController.register", (String)"socialNetwork.EX_CANT_REGISTER_USER");
                RequestDispatcher dispatcher = req.getRequestDispatcher("/admin/jsp/alreadyRegistered.jsp");
                dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            RequestDispatcher dispatcher = req.getRequestDispatcher("/AuthenticationServlet");
            dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private String getRedirectURL(SocialNetworkID networkId, HttpServletRequest request) {
        StringBuilder redirectURL = new StringBuilder();
        redirectURL.append(URLManager.getFullApplicationURL((HttpServletRequest)request));
        redirectURL.append("/SocialNetworkLogin?command=backFromSocialNetworkAuthentication&networkId=");
        redirectURL.append(networkId);
        return redirectURL.toString();
    }

    private SocialNetworkConnector getSocialNetworkConnector(SocialNetworkID networkId) {
        return SocialNetworkService.getInstance().getSocialNetworkConnector(networkId);
    }

    private String getAuthenticateURL(SocialNetworkID networkId, HttpServletRequest request) {
        return this.getSocialNetworkConnector(networkId).buildAuthenticateUrl(this.getRedirectURL(networkId, request));
    }
}

