/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.invitation.web;

import com.silverpeas.profile.web.ProfileResourceBaseURIs;
import com.silverpeas.socialnetwork.invitation.Invitation;
import com.silverpeas.web.Exposable;
import java.net.URI;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class InvitationEntity
extends Invitation
implements Exposable {
    private static final long serialVersionUID = -3801150192463666441L;
    @XmlElement
    private URI uri;
    @XmlElement
    @NotNull
    private URI senderUri;
    @XmlElement
    @NotNull
    private URI receiverUri;
    private final Invitation invitation;

    public static InvitationEntity fromInvitation(Invitation invitation) {
        return new InvitationEntity(invitation);
    }

    private InvitationEntity(Invitation invitation) {
        this.invitation = invitation;
        this.senderUri = ProfileResourceBaseURIs.uriOfUser(String.valueOf(invitation.getSenderId()));
        this.receiverUri = ProfileResourceBaseURIs.uriOfUser(String.valueOf(invitation.getReceiverId()));
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public URI getReceiverUri() {
        return this.receiverUri;
    }

    public URI getSenderUri() {
        return this.senderUri;
    }

    public void setSenderId(int senderId) {
        this.invitation.setSenderId(senderId);
    }

    public void setReceiverId(int receiverId) {
        this.invitation.setReceiverId(receiverId);
    }

    public void setMessage(String message) {
        this.invitation.setMessage(message);
    }

    public void setInvitationDate(Date invitationDate) {
        this.invitation.setInvitationDate(invitationDate);
    }

    public void setId(int id) {
        this.invitation.setId(id);
    }

    @XmlElement
    @NotNull
    public int getSenderId() {
        return this.invitation.getSenderId();
    }

    @XmlElement
    @NotNull
    public int getReceiverId() {
        return this.invitation.getReceiverId();
    }

    @XmlElement
    public String getMessage() {
        return this.invitation.getMessage();
    }

    @XmlElement
    @NotNull
    public Date getInvitationDate() {
        return this.invitation.getInvitationDate();
    }

    @XmlElement
    public int getId() {
        return this.invitation.getId();
    }

    public InvitationEntity withAsUri(URI invitationUri) {
        this.uri = invitationUri;
        return this;
    }

    protected InvitationEntity() {
        this.invitation = new Invitation();
    }
}

