/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.invitation.web;

import com.silverpeas.annotation.Authenticated;
import com.silverpeas.socialnetwork.invitation.Invitation;
import com.silverpeas.socialnetwork.invitation.InvitationService;
import com.silverpeas.socialnetwork.invitation.web.InvitationEntity;
import com.silverpeas.web.RESTWebService;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriBuilder;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="request")
@Path(value="invitations")
@Authenticated
public class InvitationResource
extends RESTWebService {
    @Inject
    private InvitationService invitationService;

    @Path(value="inbox")
    @GET
    @Produces(value={"application/json"})
    public InvitationEntity[] getReceivedInvitations() {
        List invitations = this.invitationService.getAllMyInvitationsReceive(Integer.valueOf(this.getUserDetail().getId()).intValue());
        return this.asWebEntity(invitations, InvitationResource.locatedAt(this.getUriInfo().getAbsolutePathBuilder()));
    }

    @Path(value="outbox")
    @GET
    @Produces(value={"application/json"})
    public InvitationEntity[] getSentInvitations() {
        List invitations = this.invitationService.getAllMyInvitationsSent(Integer.valueOf(this.getUserDetail().getId()).intValue());
        return this.asWebEntity(invitations, InvitationResource.locatedAt(this.getUriInfo().getAbsolutePathBuilder()));
    }

    @Override
    public String getComponentId() {
        throw new UnsupportedOperationException("The InvitationResource doesn't belong to any component instances");
    }

    private static UriBuilder locatedAt(UriBuilder uri) {
        return uri;
    }

    private InvitationEntity[] asWebEntity(List<Invitation> invitations, UriBuilder baseUri) {
        InvitationEntity[] entities = new InvitationEntity[invitations.size()];
        baseUri.path("{invitationId}");
        for (int i = 0; i < invitations.size(); ++i) {
            Invitation invitation = invitations.get(i);
            entities[i] = InvitationEntity.fromInvitation(invitation).withAsUri(baseUri.build(new Object[]{invitation.getId()}));
        }
        return entities;
    }
}

