/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.user.model;

import com.silverpeas.session.SessionInfo;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.session.SessionManagementFactory;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class SNFullUser {
    private UserFull userFull;
    private String profilPhoto;
    private String duration;
    private boolean connected;
    private String phone;

    public SNFullUser(String userId) {
        this.userFull = OrganisationControllerFactory.getOrganisationController().getUserFull(userId);
        this.phone = this.userFull.getValue("phone");
        String avatar = this.userFull.getLogin() + ".jpg";
        File image = new File(FileRepositoryManager.getAbsolutePath((String)"avatar") + File.separatorChar + avatar);
        this.profilPhoto = image.exists() ? "/display/avatar/" + avatar : "/directory/jsp/icons/Photo_profil.jpg";
        SessionManagementFactory factory = SessionManagementFactory.getFactory();
        SessionManagement sessionManagement = factory.getSessionManagement();
        Collection sessionInfos = sessionManagement.getConnectedUsersList();
        for (SessionInfo varSi : sessionInfos) {
            if (!varSi.getUserDetail().getId().equals(userId)) continue;
            this.duration = DateUtil.formatDuration((long)(new Date().getTime() - varSi.getOpeningTimestamp()));
            this.connected = true;
            return;
        }
        this.duration = "";
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getProfilPhoto() {
        return this.profilPhoto;
    }

    public UserFull getUserFull() {
        return this.userFull;
    }

    public String getPhone() {
        return this.phone;
    }
}

