/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.subscribe.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.comment.CommentRuntimeException;
import com.silverpeas.subscribe.Subscription;
import com.silverpeas.subscribe.SubscriptionServiceFactory;
import com.silverpeas.subscribe.service.ComponentSubscription;
import com.silverpeas.subscribe.service.NodeSubscription;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="subscribe/{componentId}")
@Authorized
public class SubscribeResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;

    @POST
    @Produces(value={"application/json"})
    public String subscribeToComponent() {
        try {
            ComponentSubscription subscription = new ComponentSubscription(this.getUserDetail().getId(), this.componentId);
            SubscriptionServiceFactory.getFactory().getSubscribeService().subscribe((Subscription)subscription);
            return "OK";
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Path(value="/topic/{id}")
    @Produces(value={"application/json"})
    public String subscribeToTopic(@PathParam(value="id") String topicId) {
        try {
            NodeSubscription subscription = new NodeSubscription(this.getUserDetail().getId(), new NodePK(topicId, this.componentId));
            SubscriptionServiceFactory.getFactory().getSubscribeService().subscribe((Subscription)subscription);
            return "OK";
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected URI identifiedBy(URI uri) {
        return uri;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }
}

