/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.subscribe.web;

import com.silverpeas.subscribe.Subscription;
import com.silverpeas.subscribe.constant.SubscriptionMethod;
import com.silverpeas.subscribe.web.SubscriberEntity;
import com.silverpeas.subscribe.web.SubscriptionResourceEntity;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SubscriptionEntity {
    @XmlElement(required=true)
    private SubscriptionResourceEntity resource;
    @XmlElement(required=true)
    private SubscriberEntity subscriber;
    @XmlElement(defaultValue="true")
    private boolean forced = true;
    @XmlElement(defaultValue="true")
    private boolean selfCreation = true;
    @XmlElement(defaultValue="true")
    private Date creationDate;

    static SubscriptionEntity from(Subscription subscription) {
        SubscriptionEntity entity = new SubscriptionEntity();
        entity.resource = SubscriptionResourceEntity.from(subscription.getResource());
        entity.subscriber = SubscriberEntity.from(subscription.getSubscriber());
        entity.forced = SubscriptionMethod.FORCED.equals((Object)subscription.getSubscriptionMethod());
        entity.selfCreation = SubscriptionMethod.SELF_CREATION.equals((Object)subscription.getSubscriptionMethod());
        entity.creationDate = subscription.getCreationDate();
        return entity;
    }

    public SubscriptionResourceEntity getResource() {
        return this.resource;
    }

    public SubscriberEntity getSubscriber() {
        return this.subscriber;
    }

    public boolean isForced() {
        return this.forced;
    }

    public boolean isSelfCreation() {
        return this.selfCreation;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }
}

