/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.subscribe.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.comment.CommentRuntimeException;
import com.silverpeas.subscribe.Subscription;
import com.silverpeas.subscribe.SubscriptionServiceFactory;
import com.silverpeas.subscribe.SubscriptionSubscriber;
import com.silverpeas.subscribe.service.ComponentSubscriptionResource;
import com.silverpeas.subscribe.service.NodeSubscriptionResource;
import com.silverpeas.subscribe.service.SubscribeRuntimeException;
import com.silverpeas.subscribe.service.UserSubscriptionSubscriber;
import com.silverpeas.subscribe.web.SubscriberEntity;
import com.silverpeas.subscribe.web.SubscriptionEntity;
import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="subscriptions/{componentId}")
@Authorized
public class SubscriptionResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;

    @GET
    @Produces(value={"application/json"})
    public Collection<SubscriptionEntity> getComponentSubscriptions() {
        return this.getSubscriptions(null);
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Collection<SubscriptionEntity> getSubscriptions(@PathParam(value="id") String resourceId) {
        try {
            UserSubscriptionSubscriber userSubscriber = UserSubscriptionSubscriber.from((String)this.getUserDetail().getId());
            Collection subscriptions = StringUtil.isDefined((String)resourceId) ? SubscriptionServiceFactory.getFactory().getSubscribeService().getByResource((com.silverpeas.subscribe.SubscriptionResource)NodeSubscriptionResource.from((NodePK)new NodePK(resourceId, this.componentId))) : SubscriptionServiceFactory.getFactory().getSubscribeService().getByResource((com.silverpeas.subscribe.SubscriptionResource)ComponentSubscriptionResource.from((String)this.componentId));
            return this.asWebEntities(subscriptions);
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Path(value="/subscribers")
    @Produces(value={"application/json"})
    public Collection<SubscriberEntity> getComponentSubscribers() {
        return this.getSubscribers(null);
    }

    @GET
    @Path(value="/subscribers/{id}")
    @Produces(value={"application/json"})
    public Collection<SubscriberEntity> getSubscribers(@PathParam(value="id") String resourceId) {
        try {
            Object subscriptionResource = StringUtil.isDefined((String)resourceId) ? NodeSubscriptionResource.from((NodePK)new NodePK(resourceId, this.componentId)) : ComponentSubscriptionResource.from((String)this.componentId);
            return this.asSubscriberWebEntities(SubscriptionServiceFactory.getFactory().getSubscribeService().getSubscribers((com.silverpeas.subscribe.SubscriptionResource)subscriptionResource));
        }
        catch (SubscribeRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected Collection<SubscriptionEntity> asWebEntities(Collection<Subscription> subscriptions) {
        ArrayList<SubscriptionEntity> entities = new ArrayList<SubscriptionEntity>(subscriptions.size());
        for (Subscription subscription : subscriptions) {
            entities.add(this.asWebEntity(subscription));
        }
        return entities;
    }

    protected SubscriptionEntity asWebEntity(Subscription subscription) {
        return SubscriptionEntity.from(subscription);
    }

    protected Collection<SubscriberEntity> asSubscriberWebEntities(Collection<SubscriptionSubscriber> subscribers) {
        ArrayList<SubscriberEntity> entities = new ArrayList<SubscriberEntity>(subscribers.size());
        for (SubscriptionSubscriber subscriber : subscribers) {
            entities.add(this.asSubscriberWebEntity(subscriber));
        }
        return entities;
    }

    protected SubscriberEntity asSubscriberWebEntity(SubscriptionSubscriber subscriber) {
        return SubscriberEntity.from(subscriber);
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }
}

