/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.subscribe.web;

import com.silverpeas.annotation.Authorized;
import com.silverpeas.annotation.RequestScoped;
import com.silverpeas.annotation.Service;
import com.silverpeas.comment.CommentRuntimeException;
import com.silverpeas.subscribe.Subscription;
import com.silverpeas.subscribe.SubscriptionServiceFactory;
import com.silverpeas.subscribe.SubscriptionSubscriber;
import com.silverpeas.subscribe.service.ComponentSubscription;
import com.silverpeas.subscribe.service.GroupSubscriptionSubscriber;
import com.silverpeas.subscribe.service.NodeSubscription;
import com.silverpeas.subscribe.service.UserSubscriptionSubscriber;
import com.silverpeas.web.RESTWebService;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.Collections;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Service
@RequestScoped
@Path(value="unsubscribe/{componentId}")
@Authorized
public class UnsubscribeResource
extends RESTWebService {
    @PathParam(value="componentId")
    private String componentId;

    @POST
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromComponent() {
        return this.unsubscribeUserFromComponent(this.getUserDetail().getId());
    }

    @POST
    @Path(value="/user/{userId}")
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromComponent(@PathParam(value="userId") String userId) {
        return this.unsubscribeSubscriberFromComponent((SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId));
    }

    @POST
    @Path(value="/group/{groupId}")
    @Produces(value={"application/json"})
    public Response unsubscribeGroupFromComponent(@PathParam(value="groupId") String groupId) {
        return this.unsubscribeSubscriberFromComponent((SubscriptionSubscriber)GroupSubscriptionSubscriber.from((String)groupId));
    }

    private Response unsubscribeSubscriberFromComponent(SubscriptionSubscriber subscriber) {
        try {
            ComponentSubscription subscription = new ComponentSubscription(subscriber, this.componentId, this.getUserDetail().getId());
            SubscriptionServiceFactory.getFactory().getSubscribeService().unsubscribe((Subscription)subscription);
            return Response.ok(Collections.singletonList("OK")).build();
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @POST
    @Path(value="/topic/{id}")
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromTopic(@PathParam(value="id") String topicId) {
        return this.unsubscribeUserFromTopic(topicId, this.getUserDetail().getId());
    }

    @POST
    @Path(value="/topic/{topicId}/user/{userId}")
    @Produces(value={"application/json"})
    public Response unsubscribeUserFromTopic(@PathParam(value="topicId") String topicId, @PathParam(value="userId") String userId) {
        return this.unsubscribeSubscriberFromTopic(topicId, (SubscriptionSubscriber)UserSubscriptionSubscriber.from((String)userId));
    }

    @POST
    @Path(value="/topic/{topicId}/group/{groupId}")
    @Produces(value={"application/json"})
    public Response unsubscribeGroupFromTopic(@PathParam(value="topicId") String topicId, @PathParam(value="groupId") String groupId) {
        return this.unsubscribeSubscriberFromTopic(topicId, (SubscriptionSubscriber)GroupSubscriptionSubscriber.from((String)groupId));
    }

    private Response unsubscribeSubscriberFromTopic(@PathParam(value="topicId") String topicId, SubscriptionSubscriber subscriber) {
        try {
            NodeSubscription subscription = new NodeSubscription(subscriber, new NodePK(topicId, this.componentId), this.getUserDetail().getId());
            SubscriptionServiceFactory.getFactory().getSubscribeService().unsubscribe((Subscription)subscription);
            return Response.ok(Collections.singletonList("OK")).build();
        }
        catch (CommentRuntimeException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }
}

