/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.tools.domainSP2LDAP;

import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DBUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class DomainSP2LDAPBatch {
    private AdminController adminController;
    public static final String DOMAIN_SILVERPEAS_ID = "0";

    public OrganisationController getOrganisationController() {
        return OrganisationControllerFactory.getOrganisationController();
    }

    public AdminController getAdminController() {
        if (this.adminController == null) {
            this.adminController = new AdminController(DOMAIN_SILVERPEAS_ID);
        }
        return this.adminController;
    }

    public ArrayList<HashMap<String, UserDetail>> processMigration(String domainLDAP_Id) throws Exception {
        SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"root.MSG_ENTER_METHOD", null);
        AdminController adminController = this.getAdminController();
        ArrayList<HashMap<String, UserDetail>> returnListLDAPUsers = new ArrayList<HashMap<String, UserDetail>>();
        HashMap<String, UserDetail> processedUsers = new HashMap<String, UserDetail>();
        HashMap<String, UserDetail> notProcessedSPUsers = new HashMap<String, UserDetail>();
        HashMap<String, UserDetail> listLDAPUsers = new HashMap<String, UserDetail>();
        try {
            String[] listLDAPUsersIds = adminController.getUserIdsOfDomain(domainLDAP_Id);
            SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("Utilisateurs du domaine Silverpeas=" + listLDAPUsersIds.length), null);
            if (listLDAPUsersIds.length == 0) {
                return returnListLDAPUsers;
            }
            for (String listLDAPUsersId : listLDAPUsersIds) {
                UserDetail userDetailLDAP = this.getOrganisationController().getUserDetail(listLDAPUsersId);
                String keyName = (userDetailLDAP.getFirstName() + userDetailLDAP.getLastName()).toLowerCase();
                listLDAPUsers.put(keyName, userDetailLDAP);
            }
            String[] listSilverpeasUsersIds = adminController.getUserIdsOfDomain(DOMAIN_SILVERPEAS_ID);
            boolean processGroups = false;
            for (String listSilverpeasUsersId : listSilverpeasUsersIds) {
                UserDetail userDetail = this.getOrganisationController().getUserDetail(listSilverpeasUsersId);
                String keyName = (userDetail.getFirstName() + userDetail.getLastName()).toLowerCase();
                if (listLDAPUsers.containsKey(keyName)) {
                    UserDetail userDetailLDAP = (UserDetail)listLDAPUsers.get(keyName);
                    adminController.synchronizeRemoveUser(userDetailLDAP.getId());
                    userDetail.setSpecificId(userDetailLDAP.getSpecificId());
                    userDetail.setDomainId(userDetailLDAP.getDomainId());
                    adminController.updateUser(userDetail);
                    processedUsers.put(keyName, userDetail);
                    processGroups = true;
                    continue;
                }
                notProcessedSPUsers.put(keyName, userDetail);
            }
            if (processGroups) {
                Group[] groups = this.getOrganisationController().getAllGroups();
                SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"DEBUT Migration des groupes du domaine SP vers le domaine mixte...", null);
                for (Group group : groups) {
                    boolean processGroup = false;
                    if (!DOMAIN_SILVERPEAS_ID.equals(group.getDomainId())) continue;
                    UserDetail[] usersOfGroup = this.getAdminController().getAllUsersOfGroup(group.getId());
                    for (int j = 0; j < usersOfGroup.length && !processGroup; ++j) {
                        UserDetail userDetail = usersOfGroup[j];
                        String userKeyName = (userDetail.getFirstName() + userDetail.getLastName()).toLowerCase();
                        if (!processedUsers.containsKey(userKeyName)) continue;
                        processGroup = true;
                    }
                    if (!processGroup) continue;
                    int nextId = DBUtil.getNextId((String)"ST_GROUP", (String)"specificId");
                    group.setSpecificId(Integer.toString(nextId));
                    group.setDomainId(null);
                    adminController.updateGroup(group);
                    SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("- Groupe " + group.getName() + " avec " + group.getUserIds().length + " utilisateurs d&eacute;plac&eacute;s dans le domaine Mixte"), null);
                }
                SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"FIN Migration des groupes du domaine SP vers le domaine mixte...", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdminException("DomainSP2LDAPBatch.processMigration()", 4, "Erreur lors de la migration des comptes Silverpeas", e);
        }
        SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("DEBUT Synchronisation post migration du domaine " + domainLDAP_Id), null);
        SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)this.getAdminController().synchronizeSilverpeasWithDomain(domainLDAP_Id), null);
        SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)("FIN Synchronisation post migration du domaine " + domainLDAP_Id), null);
        returnListLDAPUsers.add(processedUsers);
        returnListLDAPUsers.add(notProcessedSPUsers);
        returnListLDAPUsers.add(listLDAPUsers);
        SynchroReport.info((String)"DomainSP2LDAPBatch.processMigration()", (String)"root.MSG_EXIT_METHOD", null);
        SynchroReport.setTraceLevel((int)0);
        return returnListLDAPUsers;
    }

    public Domain[] getDomains() throws AdminException {
        return this.getOrganisationController().getAllDomains();
    }

    public int getNbUsers(String domainId) {
        return this.getAdminController().getUserIdsOfDomain(domainId).length;
    }
}

