/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.treeMenu.process;

import com.silverpeas.treeMenu.model.MenuItem;
import com.silverpeas.treeMenu.model.MenuRuntimeException;
import com.silverpeas.treeMenu.model.NodeType;
import com.silverpeas.treeMenu.model.TreeFilter;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.node.control.NodeBm;
import com.stratelia.webactiv.util.node.model.NodeDetail;
import com.stratelia.webactiv.util.node.model.NodePK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.OrganisationController;

public class TreeBuilder {
    private TreeBuilder() {
    }

    public static MenuItem buildLevelMenu(TreeFilter filter, MenuItem father, String userId, String language, OrganisationController controller) {
        if (father == null) {
            return TreeBuilder.buildFirstLevel(filter, userId, language, controller);
        }
        return TreeBuilder.buildOtherLevel(filter, father, userId, language, controller);
    }

    private static MenuItem buildOtherLevel(TreeFilter filter, MenuItem father, String userId, String language, OrganisationController controller) {
        MenuItem menuItem;
        Collection nodeDetails;
        NodePK nodePK;
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        father.setChildren(children);
        if (father.isLeaf()) {
            return father;
        }
        if (father.getType() == NodeType.COMPONENT && filter.acceptNodeType(NodeType.THEME)) {
            nodePK = new NodePK("0", father.getKey());
            nodeDetails = TreeBuilder.getNodeBm().getChildrenDetails(nodePK);
            for (NodeDetail nodeDetail : nodeDetails) {
                if (nodeDetail.getId() == 1 || nodeDetail.getId() == 2) continue;
                menuItem = new MenuItem(Encode.forHtml((String)nodeDetail.getName(language)), nodeDetail.getNodePK().getId(), nodeDetail.getLevel(), NodeType.THEME, false, father, father.getKey());
                menuItem.setNbObjects(nodeDetail.getNbObjects());
                children.add(menuItem);
            }
        }
        if (father.getType() == NodeType.SPACE) {
            List subspaces = controller.getSubSpacesContainingComponent(father.getKey(), userId, "kmelia");
            for (SpaceInstLight space : subspaces) {
                MenuItem item = new MenuItem(space.getName(language), space.getFullId(), space.getLevel(), NodeType.SPACE, false, father, null);
                children.add(item);
            }
            String[] componentIds = controller.getAvailCompoIdsAtRoot(father.getKey(), userId);
            int level = father.getLevel() + 1;
            boolean isLeaf = false;
            List<String> allowedComponents = filter.getComponents();
            for (String componentId : componentIds) {
                MenuItem item;
                ComponentInstLight component = controller.getComponentInstLight(componentId);
                if (allowedComponents.isEmpty() && filter.acceptNodeType(NodeType.COMPONENT)) {
                    isLeaf = TreeBuilder.getLeafValue(componentId);
                    item = new MenuItem(Encode.forHtml((String)component.getLabel(language)), componentId, level, NodeType.COMPONENT, isLeaf, father, null);
                    item.setComponentName(component.getName());
                    item.setLabelStyle("icon-" + component.getName());
                    children.add(item);
                    continue;
                }
                if (!allowedComponents.contains(component.getName())) continue;
                item = new MenuItem(Encode.forHtml((String)component.getLabel(language)), componentId, level, NodeType.COMPONENT, isLeaf, father, componentId);
                item.setComponentName(component.getName());
                item.setLabelStyle("icon-" + component.getName());
                children.add(item);
            }
        }
        if (father.getType() == NodeType.THEME && filter.acceptNodeType(NodeType.THEME)) {
            nodePK = new NodePK(father.getKey(), father.getComponentId());
            nodeDetails = TreeBuilder.getNodeBm().getChildrenDetails(nodePK);
            for (NodeDetail nodeDetail : nodeDetails) {
                menuItem = new MenuItem(Encode.forHtml((String)nodeDetail.getName(language)), nodeDetail.getNodePK().getId(), nodeDetail.getLevel(), NodeType.THEME, false, father, father.getComponentId());
                menuItem.setNbObjects(nodeDetail.getNbObjects());
                children.add(menuItem);
            }
        }
        return father;
    }

    private static boolean getLeafValue(String componentId) {
        return !componentId.startsWith("kmelia");
    }

    private static MenuItem buildFirstLevel(TreeFilter filter, String userId, String language, OrganisationController controller) {
        MenuItem item;
        block4: {
            ArrayList<MenuItem> children;
            block3: {
                item = new MenuItem("root");
                children = new ArrayList<MenuItem>();
                item.setChildren(children);
                if (!filter.acceptNodeType(NodeType.SPACE)) break block3;
                List rootSpaces = controller.getRootSpacesContainingComponent(userId, "kmelia");
                for (SpaceInstLight space : rootSpaces) {
                    if (space == null) continue;
                    MenuItem subElement = new MenuItem(space.getName(language), space.getFullId(), 0, NodeType.SPACE, false, null, null);
                    children.add(subElement);
                }
                break block4;
            }
            if (!filter.acceptNodeType(NodeType.COMPONENT) || filter.getComponents().isEmpty()) break block4;
            for (String componentName : filter.getComponents()) {
                List componentList = controller.getAvailComponentInstLights(userId, componentName);
                boolean isLeaf = TreeBuilder.getLeafValue(componentName);
                for (ComponentInstLight compo : componentList) {
                    MenuItem subElement = new MenuItem(Encode.forHtml((String)compo.getLabel(language)), compo.getId(), 0, NodeType.COMPONENT, isLeaf, null, null);
                    item.setComponentName(compo.getName());
                    item.setLabelStyle("icon-" + compo.getName());
                    children.add(subElement);
                }
            }
        }
        return item;
    }

    private static NodeBm getNodeBm() {
        try {
            return (NodeBm)EJBUtilitaire.getEJBObjectRef((String)JNDINames.NODEBM_EJBHOME, NodeBm.class);
        }
        catch (Exception e) {
            throw new MenuRuntimeException("TreeBuilder.getNodeBm()", 4, "treeMenu.EX_FAILED_BUILDING_NODEBM_HOME", e);
        }
    }
}

