/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.treeMenu.process;

import com.silverpeas.treeMenu.model.MenuItem;
import com.silverpeas.treeMenu.model.NodeType;
import com.silverpeas.treeMenu.process.TreeBuilder;
import com.silverpeas.treeMenu.process.TreeFilterFactory;
import com.silverpeas.treeMenu.process.TreeMenuJason;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.SilverpeasWebUtil;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.OrganisationController;

public class TreeHandler {
    private TreeHandler() {
    }

    public static String ProcessMenu(HttpServletRequest request, String menuType) {
        MainSessionController mainSessionCtrl = new SilverpeasWebUtil().getMainSessionController(request);
        OrganisationController controller = mainSessionCtrl.getOrganisationController();
        String userId = mainSessionCtrl.getUserId();
        String language = mainSessionCtrl.getFavoriteLanguage();
        MenuItem items = TreeBuilder.buildLevelMenu(TreeFilterFactory.getTreeFilter(menuType), TreeHandler.getMenuItemFather(request), userId, language, controller);
        return TreeMenuJason.getListAsJSONArray(items.getChildren()).toString();
    }

    private static MenuItem getMenuItemFather(HttpServletRequest request) {
        String key = request.getParameter("key");
        MenuItem father = null;
        if (StringUtil.isDefined((String)key)) {
            String componentId = request.getParameter("compoId");
            String levelMenu = request.getParameter("level");
            String leaf = request.getParameter("leaf");
            boolean isLeaf = false;
            if (StringUtil.isDefined((String)leaf)) {
                isLeaf = Boolean.parseBoolean(leaf);
            }
            int level = -1;
            if (StringUtil.isDefined((String)levelMenu)) {
                level = Integer.parseInt(levelMenu);
            }
            NodeType type = null;
            if (StringUtil.isDefined((String)request.getParameter("ntype"))) {
                type = NodeType.valueOf(request.getParameter("ntype"));
            }
            father = new MenuItem(null, key, level, type, isLeaf, null, componentId);
        }
        return father;
    }
}

