/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.web;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.session.SessionInfo;
import com.silverpeas.web.UserPriviledgeValidation;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.Collection;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.silverpeas.core.admin.OrganisationController;

public abstract class RESTWebService {
    @Inject
    private OrganisationController organizationController;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private HttpServletResponse httpResponse;
    private UserDetail userDetail = null;
    private Collection<SilverpeasRole> userRoles = null;

    public abstract String getComponentId();

    public void validateUserAuthentication(UserPriviledgeValidation validation) throws WebApplicationException {
        HttpServletRequest request = this.getHttpServletRequest();
        SessionInfo session = validation.validateUserAuthentication(request);
        if (request.getHeader("X-Silverpeas-Session") != null || request.getHeader("Authorization") != null && session.getLastAccessTimestamp() == session.getOpeningTimestamp()) {
            this.getHttpServletResponse().setHeader("X-Silverpeas-Session", session.getSessionId());
        }
        this.userDetail = session.getUserDetail();
    }

    public void validateUserAuthorization(UserPriviledgeValidation validation) throws WebApplicationException {
        validation.validateUserAuthorizationOnComponentInstance(this.getUserDetail(), this.getComponentId());
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.httpResponse;
    }

    protected UserDetail getUserDetail() {
        return this.userDetail;
    }

    protected UserPreferences getUserPreferences() {
        return SilverpeasServiceProvider.getPersonalizationService().getUserSettings(this.getUserDetail().getId());
    }

    protected Collection<SilverpeasRole> getUserRoles() {
        if (this.userRoles == null) {
            this.userRoles = SilverpeasRole.from((String[])this.organizationController.getUserProfiles(this.getUserDetail().getId(), this.getComponentId()));
        }
        return this.userRoles;
    }

    protected OrganisationController getOrganisationController() {
        return this.organizationController;
    }
}

