/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.web;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.session.SessionInfo;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.verifier.AuthenticationUserVerifierFactory;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.token.TokenKey;
import org.silverpeas.token.TokenStringKey;
import org.silverpeas.token.constant.TokenType;
import org.silverpeas.token.model.Token;
import org.silverpeas.token.service.TokenService;
import org.silverpeas.util.Charsets;

@Named
public class UserPriviledgeValidation {
    @Inject
    private SessionManagement sessionManagement;
    @Inject
    @Named(value="componentAccessController")
    private AccessController<String> componentAccessController;
    @Inject
    @Named(value="simpleDocumentAccessController")
    private AccessController<SimpleDocument> documentAccessController;
    @Inject
    private OrganisationController organisationController;
    @Inject
    private TokenService tokenService;
    public static final String HTTP_SESSIONKEY = "X-Silverpeas-Session";
    public static final String HTTP_AUTHORIZATION = "Authorization";

    public SessionInfo validateUserAuthentication(HttpServletRequest request) throws WebApplicationException {
        String sessionKey = this.getUserSessionKey(request);
        SessionInfo userSession = StringUtil.isDefined((String)sessionKey) ? this.validateUserSession(sessionKey) : this.authenticateUser(request);
        this.verifyUserCanLogin(userSession);
        return userSession;
    }

    private void verifyUserCanLogin(SessionInfo userSession) {
        if (userSession != null && userSession.getUserDetail() != null) {
            try {
                AuthenticationUserVerifierFactory.getUserCanLoginVerifier((UserDetail)userSession.getUserDetail()).verify();
            }
            catch (AuthenticationException e) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
    }

    public void validateUserAuthorizationOnComponentInstance(UserDetail user, String instanceId) throws WebApplicationException {
        if (!this.componentAccessController.isUserAuthorized(user.getId(), (Object)instanceId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public void validateUserAuthorizationOnAttachment(UserDetail user, SimpleDocument doc) throws WebApplicationException {
        if (!this.documentAccessController.isUserAuthorized(user.getId(), (Object)doc)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private String getUserSessionKey(HttpServletRequest request) {
        HttpSession httpSession;
        String sessionKey = request.getHeader(HTTP_SESSIONKEY);
        if (!StringUtil.isDefined((String)sessionKey)) {
            sessionKey = request.getParameter(HTTP_SESSIONKEY);
        }
        if (!StringUtil.isDefined((String)sessionKey) && (httpSession = request.getSession(false)) != null) {
            sessionKey = httpSession.getId();
        }
        return sessionKey;
    }

    private SessionInfo authenticateUser(HttpServletRequest request) {
        String userCredentials = request.getHeader(HTTP_AUTHORIZATION);
        if (StringUtil.isDefined((String)userCredentials)) {
            String decoded = new String(Base64.decodeBase64((String)userCredentials), Charsets.UTF_8);
            int loginPasswordSeparatorIndex = decoded.indexOf(58);
            String userId = decoded.substring(0, loginPasswordSeparatorIndex);
            String password = decoded.substring(loginPasswordSeparatorIndex + 1);
            UserFull user = this.organisationController.getUserFull(userId);
            if (user == null || !user.getPassword().equals(password)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            return this.sessionManagement.openSession((UserDetail)user);
        }
        throw new WebApplicationException(Response.Status.UNAUTHORIZED);
    }

    private SessionInfo validateUserSession(String sessionKey) {
        SessionInfo sessionInfo = this.sessionManagement.validateSession(sessionKey);
        if (sessionInfo == null) {
            UserDetail user;
            Token userToken = this.tokenService.get((TokenKey)TokenStringKey.from((String)sessionKey));
            if (TokenType.USER.equals((Object)userToken.getType()) && (user = UserDetail.getById((String)userToken.getResourceId())) != null) {
                return new SessionInfo(sessionKey, user);
            }
            if (!UserDetail.isAnonymousUserExist()) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            return new SessionInfo(null, UserDetail.getAnonymousUser());
        }
        return sessionInfo;
    }
}

