/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.web.aspect;

import com.silverpeas.util.StringUtil;
import com.silverpeas.web.RESTWebService;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ComponentExistenceAspect {
    @Pointcut(value="@within(javax.ws.rs.Path) && this(com.silverpeas.web.RESTWebService)")
    public void webServices() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.GET) && execution(* *(..))")
    public void methodAnnotatedWithGET() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.POST) && execution(* *(..))")
    public void methodAnnotatedWithPOST() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.DELETE) && execution(* *(..))")
    public void methodAnnotatedWithDELETE() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.PUT) && execution(* *(..))")
    public void methodAnnotatedWithPUT() {
    }

    @Before(value="webServices() && (methodAnnotatedWithGET() || methodAnnotatedWithPOST() || methodAnnotatedWithDELETE() || methodAnnotatedWithPUT()) && this(service)")
    public void checkComponentInstanceExistence(RESTWebService service) throws Throwable {
        String instanceId = null;
        try {
            instanceId = service.getComponentId();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (StringUtil.isDefined((String)instanceId)) {
            OrganisationControllerFactory.getFactory();
            OrganisationController controller = OrganisationControllerFactory.getOrganisationController();
            if (!(controller.isComponentExist(instanceId) || controller.isToolAvailable(instanceId) || controller.isAdminTool(instanceId))) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
    }
}

