/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.web.aspect;

import com.silverpeas.web.Exposable;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class WebEntityValidationAspect {
    @Pointcut(value="@within(javax.ws.rs.Path) && this(com.silverpeas.web.RESTWebService)")
    public void webServices() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.POST) && execution(* *(..))")
    public void methodAnnotatedWithPOST() {
    }

    @Pointcut(value="@annotation(javax.ws.rs.PUT) && execution(* *(..))")
    public void methodAnnotatedWithPUT() {
    }

    @Before(value="webServices() && (methodAnnotatedWithPOST() || methodAnnotatedWithPUT()) && (args(entity,..) || args(..,entity))")
    public <T extends Exposable> void validateWebEntity(T entity) throws Throwable {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate(entity, new Class[0]);
        if (!violations.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }
}

