/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore;

import com.silverpeas.admin.components.Parameter;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.util.clipboard.ClipboardException;
import com.silverpeas.util.clipboard.ClipboardSelection;
import com.stratelia.silverpeas.alertUser.AlertUser;
import com.stratelia.silverpeas.contentManager.GlobalSilverContent;
import com.stratelia.silverpeas.genericPanel.GenericPanel;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.ComponentSessionController;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.subscription.SubscriptionContext;

public class AbstractComponentSessionController
implements ComponentSessionController {
    public static final String CHARACTER_ENCODING = "UTF-8";
    private MainSessionController controller = null;
    protected ComponentContext context = null;
    private String rootName = null;
    private ResourceLocator message = null;
    private ResourceLocator icon = null;
    private String messageLanguage = null;
    private String messageFile = null;
    private String iconFile = null;
    private ResourceLocator settings = null;
    private String settingsFile = null;

    public AbstractComponentSessionController(MainSessionController controller, String spaceId, String componentId) {
        this.controller = controller;
        this.context = controller.createComponentContext(spaceId, componentId);
        this.setComponentRootName(URLManager.getComponentNameFromComponentId((String)componentId));
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context) {
        this(controller, context, null);
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context, String resourceFileName) {
        this.controller = controller;
        this.context = context;
        this.setComponentRootName(URLManager.getComponentNameFromComponentId((String)this.getComponentId()));
        this.setResourceFileName(resourceFileName);
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context, String multilangFileName, String iconFileName) {
        this.controller = controller;
        this.context = context;
        this.setComponentRootName(URLManager.getComponentNameFromComponentId((String)this.getComponentId()));
        this.setMultilangFileName(multilangFileName);
        this.setIconFileName(iconFileName);
    }

    public AbstractComponentSessionController(MainSessionController controller, ComponentContext context, String multilangFileName, String iconFileName, String settingsFileName) {
        this.controller = controller;
        this.context = context;
        this.setComponentRootName(URLManager.getComponentNameFromComponentId((String)this.getComponentId()));
        this.setMultilangFileName(multilangFileName);
        this.setIconFileName(iconFileName);
        this.settingsFile = settingsFileName;
    }

    @Override
    public ResourceLocator getMultilang() {
        SilverTrace.info((String)"peasCore", (String)"AbstractComponentSessionController.getMultilang()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("Current Language=" + this.controller.getFavoriteLanguage()));
        if (this.message != null && !this.message.getLanguage().equals(this.controller.getFavoriteLanguage())) {
            this.setMultilangFileName(this.messageFile);
        }
        return this.message;
    }

    @Override
    public ResourceLocator getIcon() {
        if (this.icon != null && !this.icon.getLanguage().equals(this.controller.getFavoriteLanguage())) {
            this.setIconFileName(this.iconFile);
        }
        return this.icon;
    }

    @Override
    public ResourceLocator getSettings() {
        if (this.settings == null && this.settingsFile != null) {
            this.settings = new ResourceLocator(this.settingsFile, "fr");
        }
        return this.settings;
    }

    public final void setMultilangFileName(String multilangFileName) {
        this.messageFile = multilangFileName;
        if (this.messageFile != null) {
            try {
                this.messageLanguage = this.getLanguage();
                this.message = new ResourceLocator(this.messageFile, this.messageLanguage);
                SilverTrace.info((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("Language=" + this.messageLanguage));
            }
            catch (Exception e) {
                SilverTrace.error((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.EX_CANT_GET_LANGUAGE_RESOURCE", (String)("File=" + this.messageFile + "|Language=" + this.getLanguage()), (Throwable)e);
                this.message = new ResourceLocator(this.messageFile, "fr");
                this.messageLanguage = this.getLanguage();
            }
        } else {
            this.message = null;
        }
    }

    public final void setIconFileName(String iconFileName) {
        this.iconFile = iconFileName;
        if (this.iconFile != null) {
            try {
                this.messageLanguage = this.getLanguage();
                this.icon = new ResourceLocator(this.iconFile, this.messageLanguage);
                SilverTrace.info((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("Language=" + this.messageLanguage));
            }
            catch (Exception e) {
                SilverTrace.error((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.EX_CANT_GET_LANGUAGE_RESOURCE", (String)("File=" + this.messageFile + "|Language=" + this.getLanguage()), (Throwable)e);
                this.icon = new ResourceLocator(this.iconFile, "fr");
                this.messageLanguage = this.getLanguage();
            }
        } else {
            this.icon = null;
        }
    }

    public final void setResourceFileName(String resourceFileName) {
        SilverTrace.info((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("File=" + resourceFileName));
        this.messageFile = resourceFileName;
        if (this.messageFile != null) {
            try {
                this.messageLanguage = this.getLanguage();
                this.message = new ResourceLocator(this.messageFile, this.messageLanguage);
                SilverTrace.info((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("Language=" + this.messageLanguage));
            }
            catch (Exception e) {
                SilverTrace.error((String)"peasCore", (String)"AbstractComponentSessionController.setResourceFileName()", (String)"root.EX_CANT_GET_LANGUAGE_RESOURCE", (String)("File=" + this.messageFile + "|Language=" + this.getLanguage()), (Throwable)e);
                this.message = new ResourceLocator(this.messageFile, "fr");
                this.messageLanguage = this.getLanguage();
            }
        } else {
            this.message = null;
        }
    }

    public String getString(String resName) {
        String theLanguage = this.getLanguage();
        if (!(theLanguage == null && this.message != null || this.message != null && this.messageLanguage != null && this.messageLanguage.equals(theLanguage))) {
            this.setResourceFileName(this.messageFile);
        }
        if (this.message == null) {
            return resName;
        }
        return this.message.getString(resName);
    }

    @Override
    public OrganisationController getOrganisationController() {
        return this.controller.getOrganisationController();
    }

    @Override
    public String getLanguage() {
        return this.controller.getFavoriteLanguage();
    }

    public String getFavoriteSpace() {
        return this.controller.getFavoriteSpace();
    }

    public void setLanguageToMainSessionController(String newLanguage) {
        this.controller.setFavoriteLanguage(newLanguage);
    }

    public void setFavoriteSpaceToMainSessionController(String newSpace) {
        this.controller.setFavoriteSpace(newSpace);
    }

    public String getLook() {
        return this.controller.getFavoriteLook();
    }

    @Override
    public UserDetail getUserDetail() {
        return this.controller.getCurrentUserDetail();
    }

    public UserDetail getUserDetail(String userId) {
        return this.getOrganisationController().getUserDetail(userId);
    }

    @Override
    public String getUserId() {
        return this.getUserDetail().getId();
    }

    @Override
    public String getSpaceLabel() {
        return this.context.getCurrentSpaceName();
    }

    @Override
    public String getSpaceId() {
        return this.context.getCurrentSpaceId();
    }

    @Override
    public String getComponentName() {
        return this.context.getCurrentComponentName();
    }

    @Override
    public final String getComponentLabel() {
        return this.context.getCurrentComponentLabel();
    }

    @Override
    public final String getComponentId() {
        return this.context.getCurrentComponentId();
    }

    @Override
    public final String getComponentUrl() {
        return URLManager.getURL((String)this.rootName, (String)this.getSpaceId(), (String)this.getComponentId());
    }

    public final String getComponentRootName() {
        return this.rootName;
    }

    protected final void setComponentRootName(String newRootName) {
        this.rootName = newRootName;
    }

    @Override
    public List<Parameter> getComponentParameters() {
        return this.controller.getComponentParameters(this.getComponentId());
    }

    @Override
    public String getComponentParameterValue(String parameterName) {
        return this.controller.getComponentParameterValue(this.getComponentId(), parameterName);
    }

    @Override
    public String[] getUserAvailComponentIds() {
        return this.controller.getUserAvailComponentIds();
    }

    @Override
    public String[] getUserAvailSpaceIds() {
        return this.controller.getUserAvailSpaceIds();
    }

    public String[] getUserManageableSpaceIds() {
        return this.controller.getUserManageableSpaceIds();
    }

    public List<String> getUserManageableGroupIds() {
        return this.controller.getUserManageableGroupIds();
    }

    public boolean isGroupManager() {
        return !this.getUserManageableGroupIds().isEmpty();
    }

    @Override
    public String[] getUserRoles() {
        return this.context.getCurrentProfile();
    }

    @Override
    public String getUserRoleLevel() {
        String[] profiles = this.getUserRoles();
        String flag = SilverpeasRole.user.toString();
        for (String profile : profiles) {
            if (SilverpeasRole.admin.isInRole(new String[]{profile})) {
                return profile;
            }
            if (!SilverpeasRole.publisher.isInRole(new String[]{profile})) continue;
            flag = profile;
        }
        return flag;
    }

    @Override
    public synchronized UserPreferences getPersonalization() {
        return this.controller.getPersonalization();
    }

    public UserAccessLevel getUserAccessLevel() {
        return this.controller.getUserAccessLevel();
    }

    public void setGenericPanel(String panelKey, GenericPanel panel) {
        this.controller.setGenericPanel(panelKey, panel);
    }

    public GenericPanel getGenericPanel(String panelKey) {
        return this.controller.getGenericPanel(panelKey);
    }

    public Selection getSelection() {
        return this.controller.getSelection();
    }

    public SubscriptionContext getSubscriptionContext() {
        return this.controller.getSubscriptionContext();
    }

    public AlertUser getAlertUser() {
        return this.controller.getAlertUser();
    }

    @Override
    public boolean isAppInMaintenance() {
        return this.controller.isAppInMaintenance();
    }

    @Override
    public void setAppModeMaintenance(boolean mode) {
        this.controller.setAppModeMaintenance(mode);
    }

    @Override
    public boolean isSpaceInMaintenance(String spaceId) {
        return this.controller.isSpaceInMaintenance(spaceId);
    }

    @Override
    public void setSpaceModeMaintenance(String spaceId, boolean mode) {
        this.controller.setSpaceModeMaintenance(spaceId, mode);
    }

    public String getServerNameAndPort() {
        return this.controller.getServerNameAndPort();
    }

    public List<GlobalSilverContent> getLastResults() {
        return this.controller.getLastResults();
    }

    public void setLastResults(List<GlobalSilverContent> results) {
        this.controller.setLastResults(results);
    }

    public void close() {
    }

    public boolean isPasswordChangeAllowed() {
        return this.controller.isAllowPasswordChange();
    }

    public String getRSSUrl() {
        StringBuilder builder = new StringBuilder();
        builder.append("/rss").append(this.getComponentRootName()).append('/').append(this.getComponentId());
        builder.append("?userId=").append(this.getUserId()).append("&login=");
        builder.append(this.getUrlEncodedParameter(this.getUserDetail().getLogin()));
        builder.append("&password=");
        builder.append(this.getUrlEncodedParameter(this.controller.getOrganisationController().getUserFull(this.getUserId()).getPassword()));
        return builder.toString();
    }

    protected String getUrlEncodedParameter(String param) {
        try {
            return URLEncoder.encode(param, CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            return param;
        }
    }

    @Override
    public Collection<ClipboardSelection> getClipboardSelectedObjects() throws ClipboardException {
        return this.controller.getSelectedObjects();
    }

    @Override
    public String getClipboardErrorMessage() throws ClipboardException {
        return this.controller.getMessageError();
    }

    @Override
    public Exception getClipboardExceptionError() throws ClipboardException {
        return this.controller.getExceptionError();
    }

    @Override
    public Collection<ClipboardSelection> getClipboardObjects() throws ClipboardException {
        return this.controller.getObjects();
    }

    @Override
    public void addClipboardSelection(ClipboardSelection selection) throws ClipboardException {
        this.controller.add(selection);
    }

    @Override
    public String getClipboardName() {
        return this.controller.getName();
    }

    @Override
    public Integer getClipboardCount() throws ClipboardException {
        return this.controller.getCount();
    }

    @Override
    public void clipboardPasteDone() throws ClipboardException {
        this.controller.PasteDone();
    }

    @Override
    public void setClipboardSelectedElement(int index, boolean selected) throws ClipboardException {
        this.controller.setSelected(index, selected);
    }

    @Override
    public int getClipboardSize() throws ClipboardException {
        return this.controller.size();
    }

    @Override
    public void removeClipboardElement(int index) throws ClipboardException {
        this.controller.removeObject(index);
    }

    @Override
    public void setClipboardError(String messageId, Exception ex) throws ClipboardException {
        this.controller.setMessageError(messageId, ex);
    }
}

