/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore;

import com.silverpeas.session.SessionInfo;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;

public class HTTPSessionInfo
extends SessionInfo {
    private HttpSession httpSession;

    public HTTPSessionInfo(HttpSession session, String IP, UserDetail ud) {
        super(session.getId(), ud);
        this.httpSession = session;
        this.setIPAddress(IP);
    }

    public void onClosed() {
        if (this.httpSession != null) {
            this.cleanSession(this.httpSession);
            try {
                this.httpSession.invalidate();
            }
            catch (IllegalStateException ex) {
                SilverTrace.warn((String)"peasCore", (String)"SessionInfo.onClosed()", null, (String)ex.getMessage());
            }
        }
        super.onClosed();
    }

    private void cleanSession(HttpSession httpSession) {
        try {
            Enumeration attributeNames = httpSession.getAttributeNames();
            ArrayList<String> names = new ArrayList<String>();
            while (attributeNames.hasMoreElements()) {
                String spName = (String)attributeNames.nextElement();
                if (spName == null || !spName.startsWith("Silverpeas_") && !spName.startsWith("WYSIWYG_")) continue;
                names.add(spName);
            }
            for (String attributeName : names) {
                try {
                    Object controller;
                    Object element = httpSession.getAttribute(attributeName);
                    SilverTrace.debug((String)"peasCore", (String)"SessionInfo.cleanSession()", (String)("Remove=" + attributeName));
                    if (element instanceof AbstractComponentSessionController) {
                        controller = (AbstractComponentSessionController)element;
                        ((AbstractComponentSessionController)controller).close();
                        SilverTrace.debug((String)"peasCore", (String)"SessionManager.cleanSession()", (String)controller.getClass().getName());
                    } else if (element instanceof MainSessionController) {
                        controller = (MainSessionController)element;
                        ((MainSessionController)controller).remove();
                        SilverTrace.debug((String)"peasCore", (String)"SessionManager.cleanSession()", (String)"MainSessionController");
                    }
                    httpSession.removeAttribute(attributeName);
                }
                catch (Exception ex) {
                    SilverTrace.warn((String)"peasCore", (String)"SessionInfo.cleanSession()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("ERROR for parameter : " + attributeName), (Throwable)ex);
                }
            }
            httpSession.removeAttribute("SilverSessionController");
            httpSession.removeAttribute("SessionGraphicElementFactory");
            httpSession.removeAttribute("spaceModel");
            httpSession.removeAttribute("quizzUnderConstruction");
            httpSession.removeAttribute("questionsVector");
            httpSession.removeAttribute("currentQuizzId");
            httpSession.removeAttribute("questionsResponses");
            httpSession.removeAttribute("currentParticipationId");
            httpSession.removeAttribute("DomainsBarUtil");
        }
        catch (Exception e) {
            SilverTrace.warn((String)"peasCore", (String)"SessionInfo.cleanSession()", (String)"root.MSG_GEN_PARAM_VALUE", (String)"ERROR !!!", (Throwable)e);
        }
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public <T> void setAttribute(String name, T value) {
        this.httpSession.setAttribute(name, value);
    }

    public void unsetAttribute(String name) {
        this.httpSession.removeAttribute(name);
    }

    public <T> T getAttribute(String name) {
        return (T)this.httpSession.getAttribute(name);
    }
}

