/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.personalization.UserPreferences;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.clipboard.ClipboardException;
import com.silverpeas.util.clipboard.ClipboardSelection;
import com.stratelia.silverpeas.alertUser.AlertUser;
import com.stratelia.silverpeas.contentManager.ContentManager;
import com.stratelia.silverpeas.contentManager.GlobalSilverContent;
import com.stratelia.silverpeas.genericPanel.GenericPanel;
import com.stratelia.silverpeas.pdc.control.PdcBm;
import com.stratelia.silverpeas.pdc.control.PdcBmImpl;
import com.stratelia.silverpeas.pdc.control.PdcSettings;
import com.stratelia.silverpeas.pdc.model.PdcException;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.PeasCoreException;
import com.stratelia.silverpeas.peasCore.PeasCoreRuntimeException;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.AdminUserConnections;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.clipboard.control.ejb.Clipboard;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.subscription.SubscriptionContext;

public class MainSessionController
implements Clipboard {
    public static final String MAIN_SESSION_CONTROLLER_ATT = "SilverSessionController";
    Clipboard clipboard = null;
    final UserPreferences userPreferences;
    PdcBm pdcBm = null;
    Object m_ComponentSOFactory = null;
    private String sessionId = null;
    private String userId = null;
    private OrganisationController organizationController = null;
    private Date userLoginBegin = null;
    private Date userLastRequest = null;
    private String userLanguage = null;
    private ContentManager contentManager = null;
    Map<String, GenericPanel> genericPanels = Collections.synchronizedMap(new HashMap());
    Selection selection = null;
    private String userSpace = null;
    AlertUser m_alertUser = null;
    private String serverName = null;
    private String serverPort = null;
    String m_CurrentSpaceId = null;
    String m_CurrentComponentId = null;
    private SubscriptionContext subscriptionContext = null;
    static boolean appInMaintenance = false;
    static List<String> spacesInMaintenance = new ArrayList<String>();
    private List<GlobalSilverContent> lastResults = null;
    private boolean allowPasswordChange;

    public final boolean isAppInMaintenance() {
        return appInMaintenance;
    }

    public void setAppModeMaintenance(boolean mode) {
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.setAppModeMaintenance()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("mode=" + String.valueOf(mode)));
        appInMaintenance = mode;
    }

    public boolean isSpaceInMaintenance(String spaceId) {
        spaceId = this.checkSpaceId(spaceId);
        boolean inMaintenance = spacesInMaintenance.contains(spaceId);
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.isSpaceInMaintenance()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("spaceId = " + spaceId + ", maintenance = " + inMaintenance));
        return inMaintenance;
    }

    public void setSpaceModeMaintenance(String spaceId, boolean mode) {
        spaceId = this.checkSpaceId(spaceId);
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.setSpaceModeMaintenance()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("spaceId = " + spaceId + " mode=" + mode));
        if (mode) {
            if (!spacesInMaintenance.contains(spaceId)) {
                spacesInMaintenance.add(spaceId);
            }
        } else if (spacesInMaintenance.contains(spaceId)) {
            spacesInMaintenance.remove(spacesInMaintenance.indexOf(spaceId));
        }
    }

    private String checkSpaceId(String spaceId) {
        if (spaceId != null && spaceId.startsWith("WA")) {
            return spaceId.substring("WA".length(), spaceId.length());
        }
        return spaceId;
    }

    protected MainSessionController() {
        this.userPreferences = null;
    }

    public MainSessionController(String authenticationKey, String sessionId) throws Exception {
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.constructor()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("authenticationKey = " + authenticationKey + " sessionId=" + sessionId));
        try {
            this.userId = AdminReference.getAdminService().authenticate(authenticationKey, sessionId, this.isAppInMaintenance());
            this.sessionId = sessionId;
            this.userPreferences = SilverpeasServiceProvider.getPersonalizationService().getUserSettings(this.userId);
            this.userLanguage = this.userPreferences.getLanguage();
        }
        catch (Exception e) {
            throw new PeasCoreException("MainSessionController.MainSessionController", 4, "peasCore.EX_CANT_GET_USER_PROFILE", "authenticationKey=" + authenticationKey, e);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Object getComponentSOFactory() {
        return this.m_ComponentSOFactory;
    }

    public void setComponentSOFactory(Object Factory) {
        this.m_ComponentSOFactory = Factory;
    }

    public synchronized void setUserLoginBegin(Date d) {
        this.userLoginBegin = d;
    }

    public synchronized Date getUserLoginBegin() {
        return this.userLoginBegin;
    }

    public synchronized void setUserLastRequest(Date d) {
        this.userLastRequest = d;
    }

    public synchronized Date getUserLastRequest() {
        return this.userLastRequest;
    }

    public void setGenericPanel(String panelKey, GenericPanel panel) {
        this.genericPanels.put(panelKey, panel);
    }

    public GenericPanel getGenericPanel(String panelKey) {
        return this.genericPanels.get(panelKey);
    }

    public Selection getSelection() {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        return this.selection;
    }

    public SubscriptionContext getSubscriptionContext() {
        if (this.subscriptionContext == null) {
            this.subscriptionContext = new SubscriptionContext(this.getCurrentUserDetail(), this.userPreferences);
        }
        return this.subscriptionContext;
    }

    public AlertUser getAlertUser() {
        if (this.m_alertUser == null) {
            this.m_alertUser = new AlertUser();
        }
        return this.m_alertUser;
    }

    public synchronized void initClipboard() {
        this.clipboard = null;
    }

    public synchronized Clipboard getClipboard() {
        if (this.clipboard == null) {
            SilverTrace.info((String)"peasCore", (String)"MainSessionController.getClipboard()", (String)"root.MSG_GEN_ENTER_METHOD");
            try {
                this.clipboard = this.create("MainClipboard");
            }
            catch (Exception e) {
                throw new PeasCoreRuntimeException("MainSessionController.getClipboard()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.getClipboard()", (String)"root.MSG_GEN_EXIT_METHOD");
        return this.clipboard;
    }

    public UserPreferences getPersonalization() {
        return this.userPreferences;
    }

    public String getFavoriteLanguage() {
        return this.userLanguage;
    }

    public void setFavoriteLanguage(String newLanguage) {
        this.userLanguage = newLanguage;
    }

    public synchronized String getFavoriteSpace() {
        if (this.userSpace == null) {
            this.userSpace = this.userPreferences.getPersonalWorkSpaceId();
            boolean allowed = false;
            String[] availableSpaces = this.getUserAvailSpaceIds();
            if (StringUtil.isDefined((String)this.userSpace)) {
                for (String availableSpaceId : availableSpaces) {
                    if (!this.userSpace.equals(availableSpaceId)) continue;
                    allowed = true;
                    break;
                }
            }
            if (!allowed) {
                this.getPersonalization().setPersonalWorkSpaceId("");
            }
        }
        return this.userSpace;
    }

    public void setFavoriteSpace(String newSpace) {
        this.userSpace = newSpace;
    }

    public String getFavoriteLook() {
        return this.userPreferences.getLook();
    }

    public boolean isOnlineEditingEnabled() {
        return this.userPreferences.isWebdavEditionEnabled();
    }

    public boolean isWebDAVEditingEnabled() {
        return this.userPreferences.isWebdavEditionEnabled();
    }

    public boolean isDragNDropEnabled() {
        return this.userPreferences.isDragAndDropEnabled();
    }

    public OrganisationController getOrganisationController() {
        if (this.organizationController == null) {
            this.organizationController = OrganisationControllerFactory.getOrganisationController();
        }
        return this.organizationController;
    }

    public UserAccessLevel getUserAccessLevel() {
        return this.getCurrentUserDetail().getAccessLevel();
    }

    public UserDetail getCurrentUserDetail() {
        try {
            return AdminReference.getAdminService().getUserDetail(this.getUserId());
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.getCurrentUserDetail", (String)"peasCore.EX_CANT_GET_USER_DETAIL", (String)("userId=" + this.getUserId()), (Throwable)e);
            return null;
        }
    }

    public List<Parameter> getComponentParameters(String sComponentId) {
        return AdminReference.getAdminService().getComponentParameters(sComponentId);
    }

    public String getComponentParameterValue(String sComponentId, String parameterName) {
        return AdminReference.getAdminService().getComponentParameterValue(sComponentId, parameterName);
    }

    public String[] getUserAvailRootSpaceIds() {
        return this.getOrganisationController().getAllRootSpaceIds(this.getUserId());
    }

    public String[] getUserAvailComponentIds() {
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.getUserAvailComponentIds", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getAvailCompoIds(this.getUserId());
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.getUserAvailComponentIds", (String)"admin.MSG_ERR_GET_SPACE", (Throwable)e);
            return null;
        }
    }

    public String[] getUserAvailSpaceIds() {
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.getUserAvailSpaceIds", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getClientSpaceIds(AdminReference.getAdminService().getUserSpaceIds(this.userId));
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.getUserAvailSpaceIds", (String)"admin.MSG_ERR_GET_SPACE", (Throwable)e);
            return null;
        }
    }

    public String[] getUserManageableSpaceIds() {
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.getUserManageableSpaceIds", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            UserDetail user = AdminReference.getAdminService().getUserDetail(this.userId);
            if (user.isAccessAdmin() || this.userId.equals("0")) {
                return AdminReference.getAdminService().getClientSpaceIds(AdminReference.getAdminService().getAllSpaceIds());
            }
            return AdminReference.getAdminService().getClientSpaceIds(AdminReference.getAdminService().getUserManageableSpaceIds(this.userId));
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.getUserManageableSpaceIds", (String)"admin.MSG_ERR_GET_SPACE", (Throwable)e);
            return null;
        }
    }

    public boolean isBackOfficeVisible() {
        return this.getCurrentUserDetail().isBackOfficeVisible() || this.getUserManageableSpaceIds().length > 0 || !this.getUserManageableGroupIds().isEmpty() || this.isPDCBackOfficeVisible();
    }

    public boolean isPDCBackOfficeVisible() {
        if (!PdcSettings.delegationEnabled) {
            return false;
        }
        try {
            return this.getPdcBm().isUserManager(this.userId);
        }
        catch (PdcException e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.isPDCBackOfficeVisible", (String)"admin.MSG_ERR_GET_PDC_VISIBILITY", (Throwable)e);
            return false;
        }
    }

    private PdcBm getPdcBm() {
        if (this.pdcBm == null) {
            this.pdcBm = new PdcBmImpl();
        }
        return this.pdcBm;
    }

    public List<String> getUserManageableGroupIds() {
        SilverTrace.info((String)"peasCore", (String)"MainSessionController.getUserManageableGroupIds", (String)"root.MSG_GEN_ENTER_METHOD");
        try {
            return AdminReference.getAdminService().getUserManageableGroupIds(this.userId);
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.getUserManageableGroupIds", (String)"admin.MSG_ERR_GET_GROUP", (Throwable)e);
            return null;
        }
    }

    public ComponentContext createComponentContext(String sSpaceId, String sComponent) {
        ComponentContext newInfos = new ComponentContext();
        try {
            if (sSpaceId != null) {
                SpaceInstLight spaceInst = AdminReference.getAdminService().getSpaceInstLightById(sSpaceId);
                newInfos.setCurrentSpaceId(sSpaceId);
                newInfos.setCurrentSpaceName(spaceInst.getName(this.getFavoriteLanguage()));
            }
            if (sComponent != null) {
                String sCurCompoLabel = "";
                ComponentInst componentInst = AdminReference.getAdminService().getComponentInst(sComponent);
                sCurCompoLabel = componentInst.getLabel(this.getFavoriteLanguage());
                newInfos.setCurrentComponentId(sComponent);
                newInfos.setCurrentComponentName(componentInst.getName());
                newInfos.setCurrentComponentLabel(sCurCompoLabel);
                newInfos.setCurrentProfile(AdminReference.getAdminService().getCurrentProfiles(this.getUserId(), componentInst));
            }
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.createComponentContext", (String)"peasCore.EX_CANT_CREATE_COMPONENT_CONTEXT", (String)("sSpaceId=" + sSpaceId + " | sComponent=" + sComponent), (Throwable)e);
        }
        return newInfos;
    }

    public void updateUserSpace(String sSpaceId) {
        this.m_CurrentSpaceId = sSpaceId;
    }

    public void updateUserComponent(String sComponent) {
        this.m_CurrentComponentId = sComponent;
    }

    public String getUserCurrentSpaceId() {
        return this.m_CurrentSpaceId;
    }

    public String getUserCurrentComponentId() {
        return this.m_CurrentComponentId;
    }

    public AdminUserConnections getAdminUserConnections() {
        AdminUserConnections auc = new AdminUserConnections(this.userId, this.sessionId);
        return auc;
    }

    public ContentManager getContentManager() {
        try {
            if (this.contentManager == null) {
                this.contentManager = new ContentManager();
            }
        }
        catch (Exception e) {
            SilverTrace.error((String)"peasCore", (String)"MainSessionController.getContentManager", (String)"peasCore.EX_UNABLE_TO_GET_CONTENTMANAGER", (Throwable)e);
        }
        return this.contentManager;
    }

    public void initServerProps(String sName, String sPort) {
        this.serverName = sName;
        this.serverPort = sPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getServerNameAndPort() {
        if (!StringUtil.isDefined((String)this.serverPort)) {
            return this.serverName;
        }
        return this.serverName + ":" + this.serverPort;
    }

    public void remove() {
        if (this.clipboard != null) {
            this.clipboard.remove();
        }
    }

    public List<GlobalSilverContent> getLastResults() {
        return this.lastResults;
    }

    public void setLastResults(List<GlobalSilverContent> list) {
        this.lastResults = list;
    }

    public void setAllowPasswordChange(boolean flag) {
        this.allowPasswordChange = flag;
    }

    public boolean isAllowPasswordChange() {
        return this.allowPasswordChange;
    }

    public Clipboard create(String name) {
        return ((Clipboard)EJBUtilitaire.getEJBObjectRef((String)JNDINames.CLIPBOARD_EJBHOME, Clipboard.class)).create(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ClipboardSelection clipObject) throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.add(clipObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardSelection getObject() {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PasteDone() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.PasteDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClipboardSelection> getSelectedObjects() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getSelectedObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ClipboardSelection> getObjects() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClipboardSelection getObject(int index) throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getObject(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(int index, boolean setIt) throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.setSelected(index, setIt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(int index) throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.removeObject(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultiClipboard() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.setMultiClipboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSingleClipboard() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.setSingleClipboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageError() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getMessageError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getExceptionError() throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            return clipboard.getExceptionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageError(String messageID, Exception e) throws ClipboardException {
        Clipboard clipboard;
        Clipboard clipboard2 = clipboard = this.getClipboard();
        synchronized (clipboard2) {
            clipboard.setMessageError(messageID, e);
        }
    }
}

