/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.session.SessionInfo;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.peasCore.HTTPSessionInfo;
import com.stratelia.silverpeas.silverstatistics.control.SilverStatisticsManager;
import com.stratelia.silverpeas.silvertrace.SilverLog;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.persistence.IdPK;
import com.stratelia.webactiv.persistence.PersistenceException;
import com.stratelia.webactiv.persistence.SilverpeasBeanDAO;
import com.stratelia.webactiv.persistence.SilverpeasBeanDAOFactory;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Named(value="sessionManagement")
public class SessionManager
implements SchedulerEventListener,
SessionManagement {
    private static final String NOTIFY_DATE_FORMAT = " HH:mm (dd/MM/yyyy) ";
    private static final String SESSION_MANAGER_JOB_NAME = "SessionManagerScheduler";
    private long userSessionTimeout = 600000L;
    private long adminSessionTimeout = 1200000L;
    private long scheduledSessionManagementTimeStamp = 60000L;
    private long maxRefreshInterval = 90000L;
    private Map<String, SessionInfo> userDataSessions = new HashMap<String, SessionInfo>(100);
    private List<String> userNotificationSessions = new ArrayList<String>(100);
    private ResourceLocator messages = null;
    @Inject
    private SilverStatisticsManager myStatisticsManager = null;
    @Inject
    private Scheduler scheduler;

    private SessionManager() {
    }

    @PostConstruct
    public void initSessionManager() {
        SilverTrace.info((String)"peasCore", (String)"SessionManagement.initialization", (String)"peasCore.MSG_SERVICE_STARTING", (String)"Initialization of the session management service");
        try {
            ResourceLocator rl = new ResourceLocator("com.stratelia.webactiv.clipboard.settings.clipboardSettings", "");
            this.maxRefreshInterval = (60L + Long.parseLong(rl.getString("IntervalInSec"))) * 1000L;
            ResourceBundle resources = FileUtil.loadBundle((String)"com.stratelia.silverpeas.peasCore.SessionManager", (Locale)new Locale("", ""));
            String language = resources.getString("language");
            if (!StringUtil.isDefined((String)language)) {
                language = I18NHelper.defaultLanguage;
            }
            this.messages = new ResourceLocator("com.stratelia.silverpeas.peasCore.multilang.peasCoreBundle", language);
            this.scheduledSessionManagementTimeStamp = this.convertMinuteInMilliseconds(Long.parseLong(resources.getString("scheduledSessionManagementTimeStamp")));
            this.userSessionTimeout = this.convertMinuteInMilliseconds(Long.parseLong(resources.getString("userSessionTimeout")));
            if (this.scheduledSessionManagementTimeStamp > this.userSessionTimeout) {
                this.scheduledSessionManagementTimeStamp = this.userSessionTimeout;
            }
            this.adminSessionTimeout = this.convertMinuteInMilliseconds(Long.parseLong(resources.getString("adminSessionTimeout")));
            if (this.scheduledSessionManagementTimeStamp > this.adminSessionTimeout) {
                this.scheduledSessionManagementTimeStamp = this.adminSessionTimeout;
            }
            this.initSchedulerTimeStamp();
            SilverLog.logConnexion((String)"SessionManager starting", (String)("TimeStamp=" + this.convertMillisecondsToMinutes(this.scheduledSessionManagementTimeStamp)), (String)("UserSessionTimeout=" + this.convertMillisecondsToMinutes(this.userSessionTimeout) + " adminSessionTimeout=" + this.convertMillisecondsToMinutes(this.adminSessionTimeout)));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SessionManager.this.shutdown();
                }
            });
        }
        catch (Exception ex) {
            SilverTrace.fatal((String)"peasCore", (String)"SessionManagement.initialization", (String)"root.EX_CLASS_NOT_INITIALIZED", (Throwable)ex);
        }
    }

    public synchronized SessionInfo validateSession(String sessionKey) {
        SessionInfo si = this.userDataSessions.get(sessionKey);
        if (si != null) {
            si.updateLastAccess();
        }
        this.userNotificationSessions.remove(sessionKey);
        return si;
    }

    private void initSchedulerTimeStamp() throws SchedulerException {
        JobTrigger trigger;
        int minute = (int)this.convertMillisecondsToMinutes(this.scheduledSessionManagementTimeStamp);
        SilverTrace.debug((String)"peasCore", (String)"SessionManager.initSchedulerTimeStamp", (String)("scheduledSessionManagementTimeStamp in minutes=" + minute));
        if (minute < 0 || minute > 59) {
            throw new SchedulerException("SchedulerMethodJob.setParameter: minute value is out of range");
        }
        this.scheduler.unscheduleJob(SESSION_MANAGER_JOB_NAME);
        try {
            trigger = this.computeJobTrigger(minute);
        }
        catch (ParseException ex) {
            throw new SchedulerException(ex.getMessage(), (Throwable)ex);
        }
        this.scheduler.scheduleJob(this.manageSession(), trigger, (SchedulerEventListener)this);
    }

    public void removeSession(String sessionId) {
        this.closeSession(sessionId);
    }

    public synchronized void closeSession(String sessionId) {
        SilverTrace.debug((String)"peasCore", (String)"SessionManager.closeSession", (String)("sessionId=" + sessionId));
        SessionInfo si = this.userDataSessions.get(sessionId);
        if (si != null) {
            this.removeSession(si);
        } else {
            SilverTrace.debug((String)"peasCore", (String)"SessionManager.removeSession", (String)("L'objet de session n'a pas ete retrouve dans la variable userDataSessions !!! (sessionId = " + sessionId + ")"));
        }
    }

    private synchronized void removeSession(SessionInfo si) {
        try {
            SilverTrace.info((String)"peasCore", (String)"SessionManager.removeSession", (String)("Close the session " + si.getSessionId()));
            SilverLog.logConnexion((String)"logout", (String)si.getIPAddress(), (String)this.log(si));
            Date now = new Date();
            long duration = now.getTime() - si.getOpeningTimestamp();
            this.myStatisticsManager.addStatConnection(si.getUserDetail().getId(), now, 1, duration);
            this.removeInQueueMessages(si.getUserDetail().getId(), si.getSessionId());
            this.userDataSessions.remove(si.getSessionId());
            this.userNotificationSessions.remove(si.getSessionId());
            si.onClosed();
        }
        catch (Exception ex) {
            SilverTrace.error((String)"peasCore", (String)"SessionManager.removeSession", (String)"root.EX_NO_MESSAGE", (Throwable)ex);
        }
    }

    public synchronized SessionInfo getSessionInfo(String sessionId) {
        return this.userDataSessions.get(sessionId);
    }

    private void removeInQueueMessages(String userId, String sessionId) {
        try {
            String whereClause;
            SilverpeasBeanDAO dao;
            IdPK pk = new IdPK();
            if (StringUtil.isDefined((String)sessionId)) {
                dao = SilverpeasBeanDAOFactory.getDAO((String)"com.stratelia.silverpeas.notificationserver.channel.server.ServerMessageBean");
                whereClause = " USERID=" + userId + " AND SESSIONID='" + sessionId + "'";
                dao.removeWhere((WAPrimaryKey)pk, whereClause);
            }
            dao = SilverpeasBeanDAOFactory.getDAO((String)"com.stratelia.silverpeas.notificationserver.channel.popup.POPUPMessageBean");
            whereClause = "userid=" + userId + " AND senderid='-1'";
            dao.removeWhere((WAPrimaryKey)pk, whereClause);
        }
        catch (PersistenceException e) {
            SilverTrace.error((String)"peasCore", (String)"SessionManager.removeInQueueMessages()", (String)"root.EX_NO_MESSAGE", (String)("USERID=" + userId + " AND SESSIONID = " + sessionId), (Throwable)e);
        }
    }

    public synchronized Collection<SessionInfo> getConnectedUsersList() {
        return this.userDataSessions.values();
    }

    public Collection<SessionInfo> getDistinctConnectedUsersList(UserDetail user) {
        HashMap<String, SessionInfo> distinctConnectedUsersList = new HashMap<String, SessionInfo>();
        Collection<SessionInfo> sessionsInfos = this.getConnectedUsersList();
        for (SessionInfo si : sessionsInfos) {
            UserDetail sessionUser = si.getUserDetail();
            String key = sessionUser.getLogin() + sessionUser.getDomainId();
            if (distinctConnectedUsersList.containsKey(key) || sessionUser.isAccessGuest()) continue;
            switch (GeneralPropertiesManager.getDomainVisibility()) {
                case 0: {
                    distinctConnectedUsersList.put(key, si);
                    break;
                }
                case 2: {
                    if (!user.getDomainId().equalsIgnoreCase(sessionUser.getDomainId())) break;
                    distinctConnectedUsersList.put(key, si);
                    break;
                }
                case 1: {
                    if ("0".equals(user.getDomainId())) {
                        distinctConnectedUsersList.put(key, si);
                        break;
                    }
                    if (!user.getDomainId().equalsIgnoreCase(sessionUser.getDomainId())) break;
                    distinctConnectedUsersList.put(key, si);
                }
            }
        }
        return distinctConnectedUsersList.values();
    }

    public int getNbConnectedUsersList(UserDetail user) {
        return this.getDistinctConnectedUsersList(user).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doSessionManagement(Date currentDate) {
        try {
            long currentTime = currentDate.getTime();
            ArrayList<SessionInfo> expiredSessions = new ArrayList<SessionInfo>(this.userDataSessions.size());
            Collection<SessionInfo> allSI = this.userDataSessions.values();
            for (SessionInfo si : allSI) {
                long userSessionTimeoutMillis;
                UserDetail userDetail = si.getUserDetail();
                long l = userSessionTimeoutMillis = userDetail.isAccessAdmin() ? this.adminSessionTimeout : this.userSessionTimeout;
                if (currentTime - si.getLastAccessTimestamp() < userSessionTimeoutMillis) continue;
                if (si instanceof HTTPSessionInfo) {
                    long duration = si.getLastIdleDuration();
                    if (duration < this.maxRefreshInterval && !this.userNotificationSessions.contains(si.getSessionId())) {
                        try {
                            this.notifyEndOfSession(userDetail.getId(), currentTime + this.scheduledSessionManagementTimeStamp, si.getSessionId());
                            continue;
                        }
                        catch (NotificationManagerException ex) {
                            SilverTrace.error((String)"peasCore", (String)"SessionManager.doSessionManagement", (String)"notificationManager.EX_CANT_SEND_USER_NOTIFICATION", (String)("sessionId=" + si.getSessionId() + " - user=" + this.log(si)), (Throwable)ex);
                            continue;
                        }
                        finally {
                            this.userNotificationSessions.add(si.getSessionId());
                            continue;
                        }
                    }
                    expiredSessions.add(si);
                    continue;
                }
                expiredSessions.add(si);
            }
            for (SessionInfo expiredSession : expiredSessions) {
                this.removeSession(expiredSession);
            }
        }
        catch (Exception ex) {
            SilverTrace.error((String)"peasCore", (String)"SessionManager.doSessionManagement", (String)"root.EX_NO_MESSAGE", (Throwable)ex);
        }
    }

    private void notifyEndOfSession(String userId, long endOfSession, String sessionId) throws NotificationManagerException {
        SilverTrace.debug((String)"peasCore", (String)"SessionManager.notifyEndOfSession", (String)("userId=" + userId + " sessionId=" + sessionId));
        String endOfSessionDate = DateUtil.formatDate((Date)new Date(endOfSession), (String)NOTIFY_DATE_FORMAT);
        String msgTitle = this.messages.getString("EndOfSessionNotificationMsgTitle");
        msgTitle = msgTitle + endOfSessionDate;
        NotificationSender notifSender = new NotificationSender(null);
        NotificationMetaData notifMetaData = new NotificationMetaData(0, msgTitle, this.messages.getString("EndOfSessionNotificationMsgText"));
        notifMetaData.setSender(null);
        notifMetaData.setSessionId(sessionId);
        notifMetaData.addUserRecipient(new UserRecipient(userId));
        notifMetaData.setSource(this.messages.getString("administrator"));
        notifSender.notifyUser(-10, notifMetaData);
    }

    public void shutdown() {
        SilverTrace.info((String)"peasCore", (String)"SessionManagement.shutdown", (String)"peasCore.MSG_SERVICE_STOPPING", (String)"Shutdown of the session management service: all the remaining sessions are cleared up");
        try {
            this.scheduler.unscheduleJob(SESSION_MANAGER_JOB_NAME);
        }
        catch (SchedulerException ex) {
            SilverTrace.error((String)"peasCore", (String)"SessionManager.shutdown", (String)ex.getMessage(), (Throwable)ex);
        }
        ArrayList<SessionInfo> allSI = new ArrayList<SessionInfo>(this.userDataSessions.values());
        for (SessionInfo si : allSI) {
            this.removeSession(si);
        }
        SilverLog.logConnexion((String)"SessionManager shutdown", null, null);
    }

    private JobTrigger computeJobTrigger(int minute) throws ParseException {
        StringBuilder cronBuilder = new StringBuilder();
        if (60 % minute == 0) {
            cronBuilder.append("0");
        }
        for (int i = minute; i < 60; i += minute) {
            cronBuilder.append(",").append(i);
        }
        cronBuilder.append(" * * * ?");
        JobTrigger trigger = cronBuilder.toString().startsWith(",") ? JobTrigger.triggerAt((String)cronBuilder.substring(1)) : JobTrigger.triggerAt((String)cronBuilder.toString());
        return trigger;
    }

    private Job manageSession() {
        return new Job(SESSION_MANAGER_JOB_NAME){

            public void execute(JobExecutionContext context) throws Exception {
                Date date = context.getFireTime();
                SessionManager.this.doSessionManagement(date);
            }
        };
    }

    public void triggerFired(SchedulerEvent anEvent) throws Exception {
        SilverTrace.debug((String)"peasCore", (String)"SessionManager.handleSchedulerEvent", (String)("The job '" + anEvent.getJobExecutionContext().getJobName() + "' is starting"));
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
        SilverTrace.debug((String)"peasCore", (String)"SessionManager.handleSchedulerEvent", (String)("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was successfull"));
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverTrace.error((String)"peasCore", (String)"SessionManager.handleSchedulerEvent", (String)("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull"));
    }

    public SessionInfo openSession(UserDetail user) {
        SessionInfo session = new SessionInfo(UUID.randomUUID().toString(), user);
        this.openSession(session);
        return session;
    }

    public SessionInfo openSession(UserDetail user, HttpServletRequest request) {
        HTTPSessionInfo si = null;
        String anIP = request.getRemoteHost();
        try {
            HttpSession session = request.getSession();
            si = new HTTPSessionInfo(session, anIP, user);
            this.openSession(si);
            this.userDataSessions.put(si.getSessionId(), si);
            SilverLog.logConnexion((String)"login", (String)si.getIPAddress(), (String)this.log(si));
        }
        catch (Exception ex) {
            SilverTrace.error((String)"peasCore", (String)"SessionManagement.openSession", (String)"root.EX_NO_MESSAGE", (Throwable)ex);
        }
        return si;
    }

    private void openSession(SessionInfo sessionInfo) {
        this.userDataSessions.put(sessionInfo.getSessionId(), sessionInfo);
        SilverLog.logConnexion((String)"login", (String)sessionInfo.getIPAddress(), (String)this.log(sessionInfo));
    }

    public synchronized boolean isUserConnected(UserDetail user) {
        for (SessionInfo session : this.userDataSessions.values()) {
            if (!user.getId().equals(session.getUserDetail().getId())) continue;
            return true;
        }
        return false;
    }

    private long convertMinuteInMilliseconds(long minutes) {
        return minutes * 60000L;
    }

    private long convertMillisecondsToMinutes(long milliseconds) {
        return milliseconds / 60000L;
    }

    private String log(SessionInfo sessionInfo) {
        return sessionInfo.getUserDetail().getLogin() + " (" + sessionInfo.getUserDetail().getDomainId() + ")";
    }
}

