/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore.servlets;

import com.silverpeas.look.LookHelper;
import com.silverpeas.session.SessionManagement;
import com.silverpeas.session.SessionManagementFactory;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.ComponentSessionController;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.PeasCoreException;
import com.stratelia.silverpeas.peasCore.SilverpeasWebUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.peasCore.UserAndGroupSelectionProcessor;
import com.stratelia.silverpeas.peasCore.servlets.QuotaErrorManager;
import com.stratelia.silverpeas.peasCore.servlets.SilverpeasAuthenticatedHttpServlet;
import com.stratelia.silverpeas.silverstatistics.control.SilverStatisticsManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.ResourcesWrapper;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.viewGenerator.html.GraphicElementFactory;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.admin.space.quota.process.check.exception.DataStorageQuotaException;

public abstract class ComponentRequestRouter<T extends ComponentSessionController>
extends SilverpeasAuthenticatedHttpServlet {
    private static final long serialVersionUID = -8055016885655445663L;
    private static final SilverpeasWebUtil webUtil = new SilverpeasWebUtil();
    private UserAndGroupSelectionProcessor selectionProcessor = new UserAndGroupSelectionProcessor();

    public abstract String getSessionControlBeanName();

    public abstract String getDestination(String var1, T var2, HttpServletRequest var3);

    public abstract T createComponentSessionController(MainSessionController var1, ComponentContext var2);

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String destination = this.computeDestination(request);
        SilverTrace.debug((String)"peasCore", (String)"RR", (String)"root.MSG_GEN_PARAM_VALUE", (String)("response = " + response));
        if (!StringUtil.isDefined((String)destination)) {
            this.throwHttpNotFoundError();
        }
        this.redirectService(request, response, destination);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    private String computeDestination(HttpServletRequest request) {
        String destination;
        HttpSession session = request.getSession(false);
        MainSessionController mainSessionCtrl = this.getMainSessionController(request);
        SilverTrace.debug((String)"peasCore", (String)"ComponentRequestRouter.computeDestination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("appInMaintenance = " + String.valueOf(mainSessionCtrl.isAppInMaintenance())));
        SilverTrace.debug((String)"peasCore", (String)"ComponentRequestRouter.computeDestination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("type User = " + mainSessionCtrl.getUserAccessLevel()));
        if (mainSessionCtrl.isAppInMaintenance() && !mainSessionCtrl.getCurrentUserDetail().isAccessAdmin()) {
            return GeneralPropertiesManager.getString((String)"redirectAppInMaintenance");
        }
        String[] context = ComponentRequestRouter.getComponentId(request, mainSessionCtrl);
        String spaceId = context[0];
        String componentId = context[1];
        String function = context[2];
        SilverTrace.debug((String)"peasCore", (String)"ComponentRequestRouter.computeDestination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("spaceId= " + spaceId));
        SilverTrace.debug((String)"peasCore", (String)"ComponentRequestRouter.computeDestination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("type User = " + mainSessionCtrl.getUserAccessLevel()));
        this.setGefSpaceId(request, componentId, spaceId);
        boolean isSpaceInMaintenance = mainSessionCtrl.isSpaceInMaintenance(spaceId);
        SilverTrace.debug((String)"peasCore", (String)"ComponentRequestRouter.computeDestination()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("spaceIsMaintenance = " + isSpaceInMaintenance));
        if (isSpaceInMaintenance && !mainSessionCtrl.getCurrentUserDetail().isAccessAdmin()) {
            return "/admin/jsp/spaceInMaintenance.jsp";
        }
        T component = this.getComponentSessionController(session, componentId);
        if (component == null) {
            boolean bCompoAllowed = this.isUserAllowed(mainSessionCtrl, componentId);
            if (!bCompoAllowed) {
                SilverTrace.warn((String)"peasCore", (String)"ComponentRequestRouter.computeDestination", (String)"peasCore.MSG_USER_NOT_ALLOWED", (String)("User=" + mainSessionCtrl.getUserId() + " | componentId=" + componentId + " | spaceId=" + spaceId));
                String destination2 = GeneralPropertiesManager.getString((String)"accessForbidden", (String)"/admin/jsp/accessForbidden.jsp");
                return destination2;
            }
            component = this.setComponentSessionController(session, mainSessionCtrl, spaceId, componentId);
        }
        ResourcesWrapper resources = new ResourcesWrapper(component.getMultilang(), component.getIcon(), component.getSettings(), component.getLanguage());
        request.setAttribute("resources", (Object)resources);
        request.setAttribute("browseContext", (Object)new String[]{component.getSpaceLabel(), component.getComponentLabel(), component.getSpaceId(), component.getComponentId(), component.getComponentUrl()});
        request.setAttribute("myComponentURL", (Object)(URLManager.getApplicationURL() + component.getComponentUrl()));
        if (!("Idle.jsp".equals(function) || "IdleSilverpeasV5.jsp".equals(function) || "ChangeSearchTypeToExpert".equals(function) || "markAsRead".equals(function))) {
            GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
            gef.setComponentId(component.getComponentId());
            gef.setHttpRequest(request);
        }
        if ((function.equals("Main") || function.startsWith("searchResult") || function.startsWith("portlet") || function.equals("GoToFilesTab")) && componentId != null) {
            SilverStatisticsManager.getInstance().addStatAccess(component.getUserId(), new Date(), component.getComponentName(), component.getSpaceId(), component.getComponentId());
        }
        if (this.selectionProcessor.isComeFromSelectionPanel(request) && StringUtil.isDefined((String)(destination = this.selectionProcessor.processSelection(mainSessionCtrl.getSelection(), request)))) {
            return destination;
        }
        try {
            destination = this.getDestination(function, component, request);
            QuotaErrorManager.checkQuotaErrorFromRequest(request);
        }
        catch (DataStorageQuotaException dsqe) {
            dsqe.setLanguage(component.getLanguage());
            throw dsqe;
        }
        if (this.selectionProcessor.isSelectionAsked(destination)) {
            this.selectionProcessor.prepareSelection(mainSessionCtrl.getSelection(), request);
        }
        SilverTrace.info((String)"couverture", (String)"ComponentRequestRouter.computeDestination()", (String)"couverture.MSG_RR_JSP", (String)("destination = '" + destination + "'"));
        if (!"POPUP".equals(this.getSessionControlBeanName()) || !function.startsWith("ReadMessage")) {
            this.updateSessionManagement(session, destination);
        }
        request.setAttribute(this.getSessionControlBeanName(), component);
        return destination;
    }

    public void updateSessionManagement(HttpSession session, String destination) {
        SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.updateSessionManagement", (String)"root.MSG_GEN_PARAM_VALUE", (String)("dest=" + destination));
        SessionManagementFactory factory = SessionManagementFactory.getFactory();
        SessionManagement sessionManagement = factory.getSessionManagement();
        sessionManagement.validateSession(session.getId());
    }

    private boolean isUserAllowed(MainSessionController controller, String componentId) {
        boolean isAllowed = componentId == null ? true : controller.getOrganisationController().isComponentAvailable(componentId, controller.getUserId());
        return isAllowed;
    }

    private void redirectService(HttpServletRequest request, HttpServletResponse response, String destination) {
        block9: {
            SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.redirectService", (String)"root.MSG_GEN_PARAM_VALUE", (String)("dest=" + destination));
            try {
                if (destination.startsWith("http") || destination.startsWith("ftp")) {
                    response.sendRedirect(destination);
                } else {
                    request.setAttribute("org.silverpeas.servlets.ComponentRequestRouter.requestURI", (Object)request.getRequestURI());
                    RequestDispatcher requestDispatcher = this.getServletConfig().getServletContext().getRequestDispatcher(destination);
                    if (requestDispatcher != null) {
                        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                    } else {
                        SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.redirectService", (String)"peasCore.EX_REDIRECT_SERVICE_FAILED", (String)("Destination '" + destination + "' not found !"));
                    }
                }
            }
            catch (Exception e) {
                try {
                    request.setAttribute("javax.servlet.jsp.jspException", (Object)new PeasCoreException("ComponentRequestRouter.redirectService", 4, "peasCore.EX_REDIRECT_SERVICE_FAILED", "Destination=" + destination, e));
                    this.getServletConfig().getServletContext().getRequestDispatcher("/admin/jsp/errorpageMain.jsp").forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception ex) {
                    if (e.getMessage() != null && e.getMessage().contains("Connection reset by peer: socket write error") && !e.getMessage().contains("SQL")) {
                        SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.redirectService", (String)"peasCore.EX_REDIRECT_SERVICE_FAILED", (String)("Destination=" + destination), (Throwable)e);
                        break block9;
                    }
                    SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.redirectService", (String)"peasCore.EX_REDIRECT_SERVICE_FAILED", (String)("Destination=" + destination), (Throwable)e);
                    SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.redirectService", (String)"peasCore.EX_REDIRECT_ERROR_PAGE_FAILED", (String)"/admin/jsp/errorpage.jsp", (Throwable)ex);
                }
            }
        }
    }

    public static String[] getComponentId(HttpServletRequest request, MainSessionController mainSessionCtrl) {
        return webUtil.getComponentId(request);
    }

    private T getComponentSessionController(HttpSession session, String componentId) {
        if (componentId == null) {
            return (T)((ComponentSessionController)session.getAttribute("Silverpeas_" + this.getSessionControlBeanName()));
        }
        return (T)((ComponentSessionController)session.getAttribute("Silverpeas_" + this.getSessionControlBeanName() + "_" + componentId));
    }

    private T setComponentSessionController(HttpSession session, MainSessionController mainSessionCtrl, String spaceId, String componentId) {
        ComponentContext componentContext = mainSessionCtrl.createComponentContext(spaceId, componentId);
        T component = this.createComponentSessionController(mainSessionCtrl, componentContext);
        if (componentId == null) {
            session.setAttribute("Silverpeas_" + this.getSessionControlBeanName(), component);
        } else {
            session.setAttribute("Silverpeas_" + this.getSessionControlBeanName() + "_" + componentId, component);
        }
        SilverTrace.info((String)"peasCore", (String)"ComponentRequestRouter.setComponentSessionController", (String)"peasCore.MSG_SESSION_CONTROLLER_INSTANCIATED", (String)("spaceId=" + spaceId + " | componentId=" + componentId));
        return component;
    }

    private void setGefSpaceId(HttpServletRequest req, String componentId, String spaceId) {
        HttpSession session = req.getSession(true);
        GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
        LookHelper helper = (LookHelper)session.getAttribute("Silverpeas_LookHelper");
        if (StringUtil.isDefined((String)componentId)) {
            if (gef != null && helper != null) {
                helper.setComponentIdAndSpaceIds(null, null, componentId);
                String helperSpaceId = helper.getSubSpaceId();
                if (!StringUtil.isDefined((String)helperSpaceId)) {
                    helperSpaceId = helper.getSpaceId();
                }
                gef.setSpaceId(helperSpaceId);
            }
        } else if (StringUtil.isDefined((String)spaceId) && gef != null && helper != null) {
            helper.setSpaceId(spaceId);
            gef.setSpaceId(spaceId);
        }
    }
}

