/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.peasCore.servlets;

import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.webactiv.util.exception.WithNested;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.admin.space.quota.process.check.exception.DataStorageQuotaException;
import org.silverpeas.util.UnitUtil;

public class QuotaErrorManager {
    private static final String SERVLET_JSP_EXCEPTION_ATTRIBUTE = "javax.servlet.jsp.jspException";

    public static void checkQuotaErrorFromRequest(HttpServletRequest request) throws DataStorageQuotaException {
        DataStorageQuotaException dataStorageQuotaException;
        Object servletJspExceptionAttribute = request.getAttribute(SERVLET_JSP_EXCEPTION_ATTRIBUTE);
        if (servletJspExceptionAttribute instanceof Throwable && (dataStorageQuotaException = QuotaErrorManager.retrieveDataStorageQuotaException((Throwable)servletJspExceptionAttribute)) != null) {
            throw dataStorageQuotaException;
        }
    }

    public static String performQuotaExceptionMessage(Throwable throwable, String language) {
        String message = "";
        DataStorageQuotaException dsqe = QuotaErrorManager.retrieveDataStorageQuotaException(throwable);
        if (dsqe != null) {
            SilverpeasTemplate template = SilverpeasTemplateFactory.createSilverpeasTemplateOnCore((String)"admin/space/quota");
            template.setAttribute("maxCountFormated", (Object)UnitUtil.formatMemSize((long)dsqe.getQuota().getMaxCount()));
            template.setAttribute("spaceName", (Object)dsqe.getSpace().getName());
            template.setAttribute("isPersonalSpace", (Object)dsqe.getSpace().isPersonalSpace());
            template.setAttribute("fromComponentName", (Object)dsqe.getFromComponent());
            message = EncodeHelper.htmlStringToJavaString((String)template.applyFileTemplate("dataStorageQuotaExceptionMessage_" + language));
        }
        return message.replaceAll("(</?b|</?i|</?p)[a-zA-Z=\"'${}\\.0-9]*>", "");
    }

    private static DataStorageQuotaException retrieveDataStorageQuotaException(Throwable throwable) {
        if (throwable != null) {
            while (throwable != null) {
                if (throwable instanceof DataStorageQuotaException) {
                    return (DataStorageQuotaException)throwable;
                }
                if (throwable instanceof WithNested) {
                    throwable = ((WithNested)throwable).getNested();
                    continue;
                }
                if (throwable instanceof RemoteException) {
                    throwable = ((RemoteException)throwable).detail;
                    continue;
                }
                if (throwable instanceof EJBException) {
                    throwable = ((EJBException)throwable).getCausedByException();
                    continue;
                }
                throwable = null;
            }
        }
        return null;
    }
}

