/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.portlet;

import com.stratelia.silverpeas.portlet.Portlet;
import com.stratelia.silverpeas.portlet.PortletException;
import java.util.ArrayList;

public class SpaceColumn {
    private int columnNumber = 0;
    private String columnWidth;
    private ArrayList portlets = new ArrayList(5);

    public SpaceColumn() throws PortletException {
        throw new PortletException("SpaceColumn.SpaceColumn()", 4, "portlet.EX_CANT_USED_THIS_CONSTRUCTOR");
    }

    public SpaceColumn(int aColumnNumber) {
        this.columnNumber = aColumnNumber;
        this.columnWidth = null;
    }

    public SpaceColumn(int aColumnNumber, String aColumnWidth) {
        this.columnNumber = aColumnNumber;
        this.columnWidth = aColumnWidth;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnWidth(String aColumnWidth) {
        this.columnWidth = aColumnWidth;
    }

    public String getColumnWidth() {
        return this.columnWidth;
    }

    public Portlet getPortlets(int row) {
        return (Portlet)this.portlets.get(row);
    }

    public int getPortletCount() {
        return this.portlets.size();
    }

    void addPortlet(Portlet aPortlet, int row) {
        if (row > this.portlets.size() || row < 0) {
            row = this.portlets.size();
        }
        aPortlet.setColumnNumber(this.getColumnNumber());
        this.portlets.add(row, aPortlet);
        for (int i = 0; i < this.portlets.size(); ++i) {
            Portlet p = (Portlet)this.portlets.get(i);
            p.setRow(i);
        }
    }

    void addPortlet(Portlet aPortlet) {
        aPortlet.setColumnNumber(this.getColumnNumber());
        aPortlet.setRow(this.portlets.size());
        this.portlets.add(aPortlet);
    }

    void removePortlet(int col) {
        this.portlets.remove(col);
        for (int i = 0; i < this.portlets.size(); ++i) {
            Portlet portlet = (Portlet)this.portlets.get(i);
            portlet.setRow(i);
        }
    }

    public String getRowRatios() {
        StringBuilder ratios = new StringBuilder();
        if (this.portlets.size() == 0) {
            ratios.append("100%");
        } else {
            String comma = "";
            for (int i = 0; i < this.portlets.size(); ++i) {
                Portlet portlet = this.getPortlets(i);
                if (portlet.getState() == 1) {
                    ratios.append(comma).append("40");
                } else {
                    ratios.append(comma).append("*");
                }
                comma = ", ";
            }
        }
        return ratios.toString();
    }
}

