/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.portlet;

import com.stratelia.silverpeas.portlet.Portlet;
import com.stratelia.silverpeas.portlet.PortletException;
import com.stratelia.silverpeas.portlet.SpaceColumn;
import java.util.ArrayList;

public class SpaceModel {
    private String spaceId;
    private ArrayList spaceColumns;
    private ArrayList portlets;
    private boolean isAdministrator;
    private int userId;

    public SpaceModel() throws PortletException {
        throw new PortletException("SpaceModel.SpaceModel()", 4, "portlet.EX_CANT_USED_THIS_CONSTRUCTOR");
    }

    public SpaceModel(String aSpaceId) {
        this.spaceId = aSpaceId;
        this.spaceColumns = new ArrayList(3);
        this.portlets = new ArrayList();
        this.isAdministrator = true;
    }

    public void setIsAdministrator(boolean isAdmin) {
        this.isAdministrator = isAdmin;
    }

    public boolean getIsAdministrator() {
        return this.isAdministrator;
    }

    public void setUserId(int aUserId) {
        this.userId = aUserId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getSpaceId() {
        return Integer.parseInt(this.spaceId);
    }

    public String getname() {
        return "spaceName";
    }

    public int getcolumnsCount() {
        if (this.spaceColumns == null) {
            return 0;
        }
        return this.spaceColumns.size();
    }

    public SpaceColumn getColumn(int col) {
        return (SpaceColumn)this.spaceColumns.get(col);
    }

    public String getColumnsRatios() {
        String columnRatios;
        if (this.spaceColumns.size() > 0) {
            columnRatios = null;
            for (Object spaceColumn : this.spaceColumns) {
                SpaceColumn sc = (SpaceColumn)spaceColumn;
                if (columnRatios == null) {
                    columnRatios = sc.getColumnWidth();
                    continue;
                }
                columnRatios = columnRatios + ", " + sc.getColumnWidth();
            }
        } else {
            columnRatios = "100%";
        }
        return columnRatios;
    }

    public Portlet getPortlets(int index) {
        return (Portlet)this.portlets.get(index);
    }

    public int getPortletCount() {
        return this.portlets.size();
    }

    public Portlet getPortlet(int col, int row) {
        SpaceColumn sc = (SpaceColumn)this.spaceColumns.get(col);
        return sc.getPortlets(row);
    }

    public int getPortletIndex(int instanceId) {
        int ret = -1;
        for (int i = 0; i < this.portlets.size(); ++i) {
            Portlet portlet = (Portlet)this.portlets.get(i);
            if (portlet.getId() != instanceId) continue;
            ret = i;
            break;
        }
        return ret;
    }

    private void updatePortletIndexes() {
        for (int i = 0; i < this.portlets.size(); ++i) {
            Portlet portlet = (Portlet)this.portlets.get(i);
            portlet.setIndex(i);
        }
        for (int col = 0; col < this.spaceColumns.size(); ++col) {
            SpaceColumn sc = (SpaceColumn)this.spaceColumns.get(col);
            for (int row = 0; row < sc.getPortletCount(); ++row) {
                Portlet portlet = sc.getPortlets(row);
                portlet.setRow(row);
                portlet.setColumnNumber(col);
            }
        }
    }

    public void addColumn(SpaceColumn aColumn, int col) {
        this.spaceColumns.add(col, aColumn);
        this.updatePortletIndexes();
    }

    public void addColumn(SpaceColumn aColumn) {
        this.spaceColumns.add(aColumn);
        for (int i = 0; i < aColumn.getPortletCount(); ++i) {
            Portlet aPortlet = aColumn.getPortlets(i);
            aPortlet.setIndex(this.portlets.size());
            this.portlets.add(aPortlet);
        }
    }

    public void addPortlet(int col, int row, Portlet aPortlet) {
        SpaceColumn sc;
        if (col >= this.spaceColumns.size() || col < 0) {
            col = this.spaceColumns.size();
        }
        if (col == this.spaceColumns.size()) {
            sc = new SpaceColumn(this.spaceColumns.size() + 1, "50%");
            this.addColumn(sc);
        }
        sc = (SpaceColumn)this.spaceColumns.get(col);
        sc.addPortlet(aPortlet, row);
        aPortlet.setIndex(this.portlets.size());
        this.portlets.add(aPortlet);
    }

    public void addPortlet(int colNum, Portlet aPortlet) {
        if (colNum >= this.spaceColumns.size() || colNum < 0) {
            colNum = this.spaceColumns.size();
        }
        if (colNum == this.spaceColumns.size()) {
            SpaceColumn sc = new SpaceColumn(this.spaceColumns.size() + 1, "50%");
            sc.addPortlet(aPortlet);
            this.addColumn(sc);
        } else {
            SpaceColumn sc = (SpaceColumn)this.spaceColumns.get(colNum);
            aPortlet.setIndex(this.portlets.size());
            sc.addPortlet(aPortlet);
            this.portlets.add(aPortlet);
        }
    }

    public void removeColumn(int col) {
        SpaceColumn sc = (SpaceColumn)this.spaceColumns.get(col);
        while (sc.getPortletCount() > 0) {
            sc.removePortlet(0);
        }
        this.spaceColumns.remove(col);
    }

    public void removePortlet(int col, int row) {
        SpaceColumn sc = (SpaceColumn)this.spaceColumns.get(col);
        Portlet portlet = sc.getPortlets(row);
        int portletIndex = portlet.getIndex();
        this.portlets.remove(portletIndex);
        sc.removePortlet(row);
        if (sc.getPortletCount() == 0) {
            this.spaceColumns.remove(col);
        }
        this.updatePortletIndexes();
    }
}

