/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.portlet;

import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.portlet.Portlet;
import com.stratelia.silverpeas.portlet.PortletComponent;
import com.stratelia.silverpeas.portlet.PortletException;
import com.stratelia.silverpeas.portlet.SpaceColumn;
import com.stratelia.silverpeas.portlet.SpaceModel;
import com.stratelia.silverpeas.portlet.model.PortletColumnRow;
import com.stratelia.silverpeas.portlet.model.PortletColumnTable;
import com.stratelia.silverpeas.portlet.model.PortletRowRow;
import com.stratelia.silverpeas.portlet.model.PortletRowTable;
import com.stratelia.silverpeas.portlet.model.PortletSchema;
import com.stratelia.silverpeas.portlet.model.PortletStateRow;
import com.stratelia.silverpeas.portlet.model.PortletStateTable;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.ComponentInst;
import com.stratelia.webactiv.beans.admin.SpaceInst;
import com.stratelia.webactiv.util.exception.UtilException;
import java.util.ArrayList;
import java.util.Map;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class SpaceModelFactory {
    protected static final OrganisationController oc = OrganisationControllerFactory.getOrganisationController();
    protected static final Map<String, WAComponent> compoDescriptors = new AdminController(null).getAllComponents();

    private SpaceModelFactory() {
    }

    public static SpaceModel getSpaceModel(PortletSchema os, String aSpaceId) throws PortletException {
        if (!StringUtil.isDefined((String)aSpaceId)) {
            throw new PortletException("SpaceModelFactory.getSpaceModel(PortletSchema os, String aSpaceId)", 4, "portlet.EX_SPACE_NULL");
        }
        int spaceNum = Integer.parseInt(aSpaceId);
        try {
            PortletColumnTable tPortletColumn = os.portletColumn;
            PortletRowTable tPortletRow = os.portletRow;
            PortletColumnRow[] portletColumns = tPortletColumn.getAllBySpaceId(spaceNum, "nbCol");
            SpaceModel sm = new SpaceModel(aSpaceId);
            for (int i = 0; i < portletColumns.length; ++i) {
                PortletRowRow[] portletRows;
                PortletColumnRow pc = portletColumns[i];
                SpaceColumn sc = new SpaceColumn(i, pc.getColumnWidth());
                for (PortletRowRow prr : portletRows = tPortletRow.getAllByPortletColumnId(pc.getId(), "nbRow")) {
                    Portlet portlet = SpaceModelFactory.getPortlet(prr.getInstanceId(), prr.getId());
                    sc.addPortlet(portlet);
                }
                sm.addColumn(sc);
            }
            return sm;
        }
        catch (UtilException e) {
            throw new PortletException("SpaceModelFactory.getSpaceModel(PortletSchema os, String aSpaceId)", 4, "portlet.EX_CANT_GET_SPACE_MODEL", (Exception)((Object)e));
        }
    }

    public static SpaceModel getSpaceModel(MainSessionController msc, String aSpaceId, boolean isAdmin) throws PortletException {
        SpaceModel sm = null;
        PortletSchema schema = null;
        try {
            int i;
            schema = new PortletSchema();
            sm = SpaceModelFactory.getSpaceModel(schema, aSpaceId);
            int userId = Integer.parseInt(msc.getUserId());
            sm.setUserId(userId);
            if (isAdmin) {
                sm.setIsAdministrator(true);
            } else {
                String[] availComponents = msc.getUserAvailComponentIds();
                for (i = 0; i < availComponents.length; ++i) {
                    availComponents[i] = SpaceModelFactory.extractLastNumber(availComponents[i]);
                }
                for (int col = 0; col < sm.getcolumnsCount(); ++col) {
                    SpaceColumn sc = sm.getColumn(col);
                    for (int row = 0; row < sc.getPortletCount(); ++row) {
                        Portlet portlet = sc.getPortlets(row);
                        String instanceId = String.valueOf(portlet.getId());
                        boolean ok = false;
                        for (int nI = 0; nI < availComponents.length && !ok; ++nI) {
                            if (!availComponents[nI].equalsIgnoreCase(instanceId)) continue;
                            ok = true;
                        }
                        if (ok) continue;
                        sm.removePortlet(col, row);
                        --row;
                        if (sc.getPortletCount() != 0) continue;
                        --col;
                    }
                }
            }
            PortletStateTable tPortletState = schema.portletState;
            for (i = 0; i < sm.getPortletCount(); ++i) {
                Portlet portlet = sm.getPortlets(i);
                String req = "Select * from ST_PortletState Where userId = " + sm.getUserId() + " and portletRowId = " + portlet.getRowId();
                PortletStateRow psr = tPortletState.getPortletState(req);
                if (psr == null) continue;
                portlet.setState(psr.getState());
            }
        }
        catch (UtilException e) {
            throw new PortletException("SpaceModelFactory.getSpaceModel(MainSessionController msc, String aSpaceId, boolean isAdmin)", 4, "portlet.EX_CANT_GET_SPACE_MODEL", (Exception)((Object)e));
        }
        finally {
            schema.close();
        }
        return sm;
    }

    public static void portletSaveState(SpaceModel space, Portlet aPortlet) throws PortletException {
        PortletSchema os = null;
        try {
            os = new PortletSchema();
            PortletStateTable tPortletState = os.portletState;
            String req = "Select * from ST_PortletState  Where portletRowId = " + aPortlet.getRowId() + "  and userId = " + space.getUserId();
            PortletStateRow psr = tPortletState.getPortletState(req);
            if (psr == null) {
                psr = new PortletStateRow(-1, aPortlet.getState(), space.getUserId(), aPortlet.getRowId());
            } else {
                psr.setState(aPortlet.getState());
            }
            tPortletState.save(psr);
            os.commit();
        }
        catch (UtilException e) {
            throw new PortletException("SpaceModelFactory.portletSaveState(SpaceModel space, Portlet aPortlet)", 4, "portlet.EX_CANT_SAVED_STATE", (Exception)((Object)e));
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private static Portlet getPortlet(int instanceId, int rowId) throws PortletException {
        Portlet portlet = null;
        try {
            boolean maximizable = true;
            boolean minimizable = true;
            String sComponentId = String.valueOf(instanceId);
            ComponentInst cir = oc.getComponentInst(sComponentId);
            String sSpaceId = cir.getDomainFatherId();
            portlet = new Portlet(instanceId, rowId, URLManager.getURL((String)cir.getName(), (String)sSpaceId, (String)(cir.getName() + sComponentId)), cir.getName(), sComponentId, cir.getLabel(), cir.getDescription(), null, null, null, null, "headerUrl", "footerUrl", "helpUrl", maximizable, minimizable, 0);
        }
        catch (Exception e) {
            throw new PortletException("SpaceModelFactory.portletSaveState(SpaceModel space, Portlet aPortlet)", 4, "portlet.EX_CANT_GET_PORTLET", e);
        }
        return portlet;
    }

    public static Portlet getPortlet(int aInstanceId) throws PortletException {
        return SpaceModelFactory.getPortlet(aInstanceId, -1);
    }

    public static PortletComponent[] getPortletList(SpaceModel space) {
        SpaceInst sinst = oc.getSpaceInstById("WA" + space.getSpaceId());
        ArrayList clist = sinst.getAllComponentsInst();
        ArrayList<PortletComponent> ar = new ArrayList<PortletComponent>(clist.size());
        for (ComponentInst cinst : clist) {
            WAComponent cdesc = compoDescriptors.get(cinst.getName());
            int cid = Integer.parseInt(SpaceModelFactory.extractLastNumber(cinst.getId()));
            if (cdesc == null || !cdesc.isPortlet() || space.getPortletIndex(cid) >= 0) continue;
            ar.add(new PortletComponent(cid, space.getSpaceId(), cinst.getLabel(), cinst.getName(), cinst.getDescription()));
        }
        return ar.toArray(new PortletComponent[ar.size()]);
    }

    public static void saveSpaceModel(SpaceModel space) throws PortletException {
        PortletSchema os = null;
        try {
            PortletColumnRow[] pRows;
            os = new PortletSchema();
            PortletColumnTable tPortletColumn = os.portletColumn;
            PortletRowTable tPortletRow = os.portletRow;
            for (PortletColumnRow pr : pRows = tPortletColumn.getAllBySpaceId(space.getSpaceId(), null)) {
                tPortletColumn.delete(pr.getId());
            }
            int nbrColumn = space.getcolumnsCount();
            for (int i = 0; i < nbrColumn; ++i) {
                SpaceColumn sc = space.getColumn(i);
                PortletColumnRow pcr = new PortletColumnRow(-1, space.getSpaceId(), sc.getColumnWidth(), i);
                tPortletColumn.create(pcr);
                int columnId = pcr.getId();
                int nbrRow = sc.getPortletCount();
                for (int j = 0; j < nbrRow; ++j) {
                    Portlet portlet = sc.getPortlets(j);
                    PortletRowRow prr = new PortletRowRow(-1, portlet.getId(), columnId, 0, j);
                    tPortletRow.create(prr);
                }
            }
            os.commit();
        }
        catch (UtilException e) {
            throw new PortletException("SpaceModelFactory.saveSpaceModel(SpaceModel space)", 4, "portlet.EX_CANT_SAVE_SPACE", (Exception)((Object)e));
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    static String extractLastNumber(String chaine) {
        String s = "";
        block3: for (int i = 0; i < chaine.length(); ++i) {
            char car = chaine.charAt(i);
            switch (car) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    s = s + car;
                    continue block3;
                }
                default: {
                    s = "";
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean portletAvailable(MainSessionController mainSessionCtrl, String spaceId) {
        boolean ret;
        block9: {
            ret = false;
            PortletSchema os = null;
            PortletRowRow[] ciRows = null;
            try {
                os = new PortletSchema();
                PortletRowTable prt = os.portletRow;
                String req = "Select R.* from ST_PortletColumn C, ST_PortletRow R Where C.spaceId = " + spaceId + " and R.portletColumnId = C.id";
                ciRows = prt.getPortletRows(req);
                SilverTrace.info((String)"portlet", (String)"SpaceModelFactory.portletAvailable()", (String)"root.MSG_GEN_PARAM_VALUE", (String)("NbRows = " + ciRows.length));
                String[] availComponents = mainSessionCtrl.getUserAvailComponentIds();
                for (int i = 0; i < availComponents.length; ++i) {
                    availComponents[i] = SpaceModelFactory.extractLastNumber(availComponents[i]);
                }
                for (PortletRowRow cir : ciRows) {
                    String componentId = String.valueOf(cir.getInstanceId());
                    for (String availComponent : availComponents) {
                        if (!availComponent.equalsIgnoreCase(componentId)) continue;
                        ret = true;
                        break block9;
                    }
                }
            }
            catch (UtilException e) {
                SilverTrace.error((String)"portlet", (String)"SpaceModelFactory.portletAvailable()", (String)"root.MSG_ERR_UNKNOWN", (String)"PB !!!", (Throwable)e);
                ret = false;
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        return ret;
    }
}

