/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.portlet.model;

import com.stratelia.silverpeas.portlet.model.PortletColumnRow;
import com.stratelia.silverpeas.portlet.model.PortletSchema;
import com.stratelia.webactiv.util.AbstractTable;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PortletColumnTable
extends AbstractTable<PortletColumnRow> {
    protected static final String PORTLETCOLUMN_COLUMNS = "id,spaceId,columnWidth,nbCol";
    private static final String SELECT_PORTLETCOLUMN_BY_ID = "Select id,spaceId,columnWidth,nbCol from ST_PortletColumn Where id = ?";
    private static final String SELECT_ALL_PORTLETCOLUMN_WITH_GIVEN_SPACEID = "select id,spaceId,columnWidth,nbCol from ST_PortletColumn where spaceId=?";
    private static final String SELECT_ALL_PORTLETCOLUMN = "select id,spaceId,columnWidth,nbCol from ST_PortletColumn";
    private static final String INSERT_PORTLETCOLUMN = "insert into ST_PortletColumn (id, spaceId, columnWidth, nbCol) values  (?, ?, ?, ?)";
    private static final String UPDATE_PORTLETCOLUMN = "Update ST_PortletColumn set spaceId = ?, columnWidth = ?, nbCol = ? Where id = ?";
    private static final String DELETE_PORTLETCOLUMN = "delete from ST_PortletColumn where id=?";

    public PortletColumnTable(Schema schema) {
        super(schema, "ST_PortletColumn");
    }

    public PortletColumnRow getPortletColumn(int id) throws UtilException {
        return (PortletColumnRow)this.getUniqueRow(SELECT_PORTLETCOLUMN_BY_ID, id);
    }

    public PortletColumnRow[] getAllBySpaceId(int aSpaceId, String orderField) throws UtilException {
        String req = "select id,spaceId,columnWidth,nbCol from ST_PortletColumn Where SpaceId = " + aSpaceId;
        if (orderField != null) {
            req = req + " order by " + orderField;
        }
        List rows = this.getRows(req);
        return rows.toArray(new PortletColumnRow[rows.size()]);
    }

    public PortletColumnRow[] getAllBySpaceId(int spaceId) throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETCOLUMN_WITH_GIVEN_SPACEID, spaceId);
        return rows.toArray(new PortletColumnRow[rows.size()]);
    }

    public PortletColumnRow[] getAllRows() throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETCOLUMN);
        return rows.toArray(new PortletColumnRow[rows.size()]);
    }

    public PortletColumnRow getPortletColumn(String query) throws UtilException {
        return (PortletColumnRow)this.getUniqueRow(query);
    }

    public PortletColumnRow[] getPortletColumns(String query) throws UtilException {
        List rows = this.getRows(query);
        return rows.toArray(new PortletColumnRow[rows.size()]);
    }

    public int create(PortletColumnRow portletColumn) throws UtilException {
        this.insertRow(INSERT_PORTLETCOLUMN, portletColumn);
        return portletColumn.getId();
    }

    public void update(PortletColumnRow portletColumn) throws UtilException {
        this.updateRow(UPDATE_PORTLETCOLUMN, portletColumn);
    }

    public void save(PortletColumnRow portletColumn) throws UtilException {
        if (portletColumn.getId() == -1) {
            this.create(portletColumn);
        } else {
            this.update(portletColumn);
        }
    }

    public void delete(int id) throws UtilException {
        ((PortletSchema)this.schema).portletRow.dereferencePortletColumnId(id);
        this.updateRelation(DELETE_PORTLETCOLUMN, id);
    }

    public PortletColumnRow[] dereferenceSpaceId(int spaceId) throws UtilException {
        PortletColumnRow[] portletColumnToBeDeleted;
        for (PortletColumnRow aPortletColumnToBeDeleted : portletColumnToBeDeleted = this.getAllBySpaceId(spaceId)) {
            this.delete(aPortletColumnToBeDeleted.getId());
        }
        return portletColumnToBeDeleted;
    }

    protected PortletColumnRow fetchRow(ResultSet rs) throws SQLException {
        return new PortletColumnRow(rs.getInt("id"), rs.getInt("spaceId"), rs.getString("columnWidth"), rs.getInt("nbCol"));
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, PortletColumnRow row) throws SQLException {
        update.setInt(1, row.getSpaceId());
        update.setString(2, PortletColumnTable.truncate((String)row.getColumnWidth(), (int)10));
        update.setInt(3, row.getNbCol());
        update.setInt(4, row.getId());
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, PortletColumnRow row) throws SQLException {
        if (row.getId() == -1) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getSpaceId());
        insert.setString(3, PortletColumnTable.truncate((String)row.getColumnWidth(), (int)10));
        insert.setInt(4, row.getNbCol());
    }
}

