/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.portlet.model;

import com.stratelia.silverpeas.portlet.model.PortletRowRow;
import com.stratelia.silverpeas.portlet.model.PortletSchema;
import com.stratelia.webactiv.util.AbstractTable;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PortletRowTable
extends AbstractTable<PortletRowRow> {
    protected static final String PORTLETROW_COLUMNS = "id,InstanceId,portletColumnId,rowHeight,nbRow";
    private static final String SELECT_PORTLETROW_BY_ID = "Select id,InstanceId,portletColumnId,rowHeight,nbRow from ST_PortletRow Where id = ?";
    private static final String SELECT_ALL_PORTLETROW_WITH_GIVEN_INSTANCEID = "select id,InstanceId,portletColumnId,rowHeight,nbRow from ST_PortletRow where InstanceId=?";
    private static final String SELECT_ALL_PORTLETROW_WITH_GIVEN_PORTLETCOLUMNID = "select id,InstanceId,portletColumnId,rowHeight,nbRow from ST_PortletRow where portletColumnId=?";
    private static final String SELECT_ALL_PORTLETROW = "select id,InstanceId,portletColumnId,rowHeight,nbRow from ST_PortletRow";
    private static final String INSERT_PORTLETROW = "insert into ST_PortletRow (id, InstanceId, portletColumnId, rowHeight, nbRow) values  (?, ?, ?, ?, ?)";
    private static final String UPDATE_PORTLETROW = "Update ST_PortletRow set InstanceId = ?, portletColumnId = ?, rowHeight = ?, nbRow = ? Where id = ?";
    private static final String DELETE_PORTLETROW = "delete from ST_PortletRow where id=?";

    public PortletRowTable(Schema schema) {
        super(schema, "ST_PortletRow");
    }

    public PortletRowRow getPortletRow(int id) throws UtilException {
        return (PortletRowRow)this.getUniqueRow(SELECT_PORTLETROW_BY_ID, id);
    }

    public PortletRowRow[] getAllByPortletColumnId(int aPortletColumnId, String orderField) throws UtilException {
        String req = "select id,InstanceId,portletColumnId,rowHeight,nbRow from ST_PortletRow Where PortletColumnId = " + aPortletColumnId;
        if (orderField != null) {
            req = req + " order by " + orderField;
        }
        List rows = this.getRows(req);
        return rows.toArray(new PortletRowRow[rows.size()]);
    }

    public PortletRowRow[] getAllByInstanceId(int instanceId) throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETROW_WITH_GIVEN_INSTANCEID, instanceId);
        return rows.toArray(new PortletRowRow[rows.size()]);
    }

    public PortletRowRow[] getAllByPortletColumnId(int portletColumnId) throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETROW_WITH_GIVEN_PORTLETCOLUMNID, portletColumnId);
        return rows.toArray(new PortletRowRow[rows.size()]);
    }

    public PortletRowRow[] getAllRows() throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETROW);
        return rows.toArray(new PortletRowRow[rows.size()]);
    }

    public PortletRowRow getPortletRow(String query) throws UtilException {
        return (PortletRowRow)this.getUniqueRow(query);
    }

    public PortletRowRow[] getPortletRows(String query) throws UtilException {
        List rows = this.getRows(query);
        return rows.toArray(new PortletRowRow[rows.size()]);
    }

    public int create(PortletRowRow portletRow) throws UtilException {
        this.insertRow(INSERT_PORTLETROW, portletRow);
        return portletRow.getId();
    }

    public void update(PortletRowRow portletRow) throws UtilException {
        this.updateRow(UPDATE_PORTLETROW, portletRow);
    }

    public void save(PortletRowRow portletRow) throws UtilException {
        if (portletRow.getId() == -1) {
            this.create(portletRow);
        } else {
            this.update(portletRow);
        }
    }

    public void delete(int id) throws UtilException {
        ((PortletSchema)this.schema).portletState.dereferencePortletRowId(id);
        this.updateRelation(DELETE_PORTLETROW, id);
    }

    public PortletRowRow[] dereferenceInstanceId(int InstanceId) throws UtilException {
        PortletRowRow[] portletRowToBeDeleted;
        for (PortletRowRow aPortletRowToBeDeleted : portletRowToBeDeleted = this.getAllByInstanceId(InstanceId)) {
            this.delete(aPortletRowToBeDeleted.getId());
        }
        return portletRowToBeDeleted;
    }

    public PortletRowRow[] dereferencePortletColumnId(int portletColumnId) throws UtilException {
        PortletRowRow[] portletRowToBeDeleted;
        for (PortletRowRow aPortletRowToBeDeleted : portletRowToBeDeleted = this.getAllByPortletColumnId(portletColumnId)) {
            this.delete(aPortletRowToBeDeleted.getId());
        }
        return portletRowToBeDeleted;
    }

    protected PortletRowRow fetchRow(ResultSet rs) throws SQLException {
        return new PortletRowRow(rs.getInt("id"), rs.getInt("InstanceId"), rs.getInt("portletColumnId"), rs.getInt("rowHeight"), rs.getInt("nbRow"));
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, PortletRowRow row) throws SQLException {
        update.setInt(1, row.getInstanceId());
        update.setInt(2, row.getPortletColumnId());
        update.setInt(3, row.getRowHeight());
        update.setInt(4, row.getNbRow());
        update.setInt(5, row.getId());
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, PortletRowRow row) throws SQLException {
        if (row.getId() == -1) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getInstanceId());
        insert.setInt(3, row.getPortletColumnId());
        insert.setInt(4, row.getRowHeight());
        insert.setInt(5, row.getNbRow());
    }
}

