/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.portlet.model;

import com.stratelia.silverpeas.portlet.model.PortletStateRow;
import com.stratelia.webactiv.util.AbstractTable;
import com.stratelia.webactiv.util.Schema;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PortletStateTable
extends AbstractTable<PortletStateRow> {
    protected static final String PORTLETSTATE_COLUMNS = "id,state,userId,portletRowId";
    private static final String SELECT_PORTLETSTATE_BY_ID = "Select id,state,userId,portletRowId from ST_PortletState Where id = ?";
    private static final String SELECT_ALL_PORTLETSTATE_WITH_GIVEN_PORTLETROWID = "select id,state,userId,portletRowId from ST_PortletState where portletRowId=?";
    private static final String SELECT_ALL_PORTLETSTATE_WITH_GIVEN_USERID = "select id,state,userId,portletRowId from ST_PortletState where userId=?";
    private static final String SELECT_ALL_PORTLETSTATE = "select id,state,userId,portletRowId from ST_PortletState";
    private static final String INSERT_PORTLETSTATE = "insert into ST_PortletState (id, state, userId, portletRowId) values  (?, ?, ?, ?)";
    private static final String UPDATE_PORTLETSTATE = "Update ST_PortletState set state = ?, userId = ?, portletRowId = ? Where id = ?";
    private static final String DELETE_PORTLETSTATE = "delete from ST_PortletState where id=?";

    public PortletStateTable(Schema schema) {
        super(schema, "ST_PortletState");
    }

    public PortletStateRow getPortletState(int id) throws UtilException {
        return (PortletStateRow)this.getUniqueRow(SELECT_PORTLETSTATE_BY_ID, id);
    }

    public PortletStateRow[] getAllByPortletRowId(int aPortletRowId, String orderField) throws UtilException {
        String req = "select id,state,userId,portletRowId from ST_PortletState Where PortletRowId = " + aPortletRowId;
        if (orderField != null) {
            req = req + " order by " + orderField;
        }
        List rows = this.getRows(req);
        return rows.toArray(new PortletStateRow[rows.size()]);
    }

    public PortletStateRow[] getAllByPortletRowId(int portletRowId) throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETSTATE_WITH_GIVEN_PORTLETROWID, portletRowId);
        return rows.toArray(new PortletStateRow[rows.size()]);
    }

    public PortletStateRow[] getAllByUserId(int userId) throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETSTATE_WITH_GIVEN_USERID, userId);
        return rows.toArray(new PortletStateRow[rows.size()]);
    }

    public PortletStateRow[] getAllRows() throws UtilException {
        List rows = this.getRows(SELECT_ALL_PORTLETSTATE);
        return rows.toArray(new PortletStateRow[rows.size()]);
    }

    public PortletStateRow getPortletState(String query) throws UtilException {
        return (PortletStateRow)this.getUniqueRow(query);
    }

    public PortletStateRow[] getPortletStates(String query) throws UtilException {
        List rows = this.getRows(query);
        return rows.toArray(new PortletStateRow[rows.size()]);
    }

    public int create(PortletStateRow portletState) throws UtilException {
        this.insertRow(INSERT_PORTLETSTATE, portletState);
        return portletState.getId();
    }

    public void update(PortletStateRow portletState) throws UtilException {
        this.updateRow(UPDATE_PORTLETSTATE, portletState);
    }

    public void save(PortletStateRow portletState) throws UtilException {
        if (portletState.getId() == -1) {
            this.create(portletState);
        } else {
            this.update(portletState);
        }
    }

    public void delete(int id) throws UtilException {
        this.updateRelation(DELETE_PORTLETSTATE, id);
    }

    public void dereferencePortletRowId(int portletRowId) throws UtilException {
        PortletStateRow[] portletStateToBeDeleted;
        for (PortletStateRow aPortletStateToBeDeleted : portletStateToBeDeleted = this.getAllByPortletRowId(portletRowId)) {
            this.delete(aPortletStateToBeDeleted.getId());
        }
    }

    public void dereferenceUserId(int userId) throws UtilException {
        PortletStateRow[] portletStateToBeDeleted;
        for (PortletStateRow aPortletStateToBeDeleted : portletStateToBeDeleted = this.getAllByUserId(userId)) {
            this.delete(aPortletStateToBeDeleted.getId());
        }
    }

    protected PortletStateRow fetchRow(ResultSet rs) throws SQLException {
        return new PortletStateRow(rs.getInt("id"), rs.getInt("state"), rs.getInt("userId"), rs.getInt("portletRowId"));
    }

    protected void prepareUpdate(String updateQuery, PreparedStatement update, PortletStateRow row) throws SQLException {
        update.setInt(1, row.getState());
        update.setInt(2, row.getUserId());
        update.setInt(3, row.getPortletRowId());
        update.setInt(4, row.getId());
    }

    protected void prepareInsert(String insertQuery, PreparedStatement insert, PortletStateRow row) throws SQLException {
        if (row.getId() == -1) {
            row.setId(this.getNextId());
        }
        insert.setInt(1, row.getId());
        insert.setInt(2, row.getState());
        insert.setInt(3, row.getUserId());
        insert.setInt(4, row.getPortletRowId());
    }
}

