/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.selectionPeas;

import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.genericPanel.PanelLine;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterSelect;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterToken;
import com.stratelia.silverpeas.genericPanel.PanelOperation;
import com.stratelia.silverpeas.genericPanel.PanelProvider;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.selection.SelectionExtraParams;
import com.stratelia.silverpeas.selectionPeas.BrowsePanelProvider;
import com.stratelia.silverpeas.selectionPeas.CacheType;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CacheManager {
    protected Map<String, PanelLine> elementCache = new HashMap<String, PanelLine>();
    protected Map<String, PanelLine> setCache = new HashMap<String, PanelLine>();
    protected Set<String> selectedElements = new HashSet<String>();
    protected Set<String> selectedSets = new HashSet<String>();
    protected ResourceLocator localResourceLocator = null;
    protected ResourceLocator globalResourceLocator = null;
    protected ResourceLocator iconResourceLocator = null;
    protected String language = DisplayI18NHelper.getDefaultLanguage();
    protected Selection selection = null;

    public CacheManager(String language, ResourceLocator local, ResourceLocator icon, Selection selection) {
        this.language = language;
        this.localResourceLocator = local;
        this.globalResourceLocator = GeneralPropertiesManager.getGeneralMultilang((String)this.language);
        this.iconResourceLocator = icon;
        this.selection = selection;
        this.resetAll();
    }

    public abstract BrowsePanelProvider getSearchPanelProvider(CacheType var1, SelectionExtraParams var2);

    public abstract BrowsePanelProvider getBrowsePanelProvider(CacheType var1, SelectionExtraParams var2);

    public abstract PanelProvider getCartPanelProvider(CacheType var1, SelectionExtraParams var2);

    public abstract PanelOperation getPanelOperation(String var1);

    public abstract String[][] getContentInfos(CacheType var1, String var2);

    public abstract String getContentText(CacheType var1);

    public abstract String[] getContentColumnsNames(CacheType var1);

    public abstract String[][] getContentLines(CacheType var1, String var2);

    public abstract String[] getColumnsNames(CacheType var1);

    protected abstract PanelLine getLineFromId(CacheType var1, String var2);

    public abstract int getLineCount(CacheType var1);

    public abstract PanelMiniFilterToken[] getPanelMiniFilters(CacheType var1);

    public abstract PanelMiniFilterSelect getSelectMiniFilter(CacheType var1);

    public void resetAll() {
        SilverTrace.info((String)"selectionPeas", (String)"CacheManager.resetAll", (String)"root.MSG_GEN_PARAM_VALUE");
        this.elementCache.clear();
        this.setCache.clear();
        this.selectedElements.clear();
        this.selectedSets.clear();
    }

    public void setInfos(CacheType what, String id, PanelLine pl) {
        SilverTrace.info((String)"selectionPeas", (String)"CacheManager.setInfos", (String)"root.MSG_GEN_PARAM_VALUE", (String)("What = " + (Object)((Object)what) + ", Id=" + id + ", Name = " + pl.m_Values[0] + ", Selected=" + pl.m_Selected));
        this.getCache(what).put(id, pl);
    }

    public PanelLine getInfos(CacheType what, String id) {
        PanelLine valret = this.getCache(what).get(id);
        if (valret != null) {
            SilverTrace.info((String)"selectionPeas", (String)"CacheManager.getInfos", (String)"root.MSG_GEN_PARAM_VALUE", (String)("What = " + (Object)((Object)what) + ", Id=" + id + ", Name = " + valret.m_Values[0] + ", Selected=" + valret.m_Selected));
        } else {
            SilverTrace.info((String)"selectionPeas", (String)"CacheManager.getInfos", (String)"root.MSG_GEN_PARAM_VALUE", (String)("What = " + (Object)((Object)what) + ", Id=" + id + ", NULL"));
            valret = this.getLineFromId(what, id);
            this.setInfos(what, id, valret);
        }
        return valret;
    }

    public void unselectAll() {
        Collection<PanelLine> en = this.getCache(CacheType.CM_SET).values();
        for (PanelLine panel : en) {
            panel.m_Selected = false;
        }
        this.getSelected(CacheType.CM_SET).clear();
        en = this.getCache(CacheType.CM_ELEMENT).values();
        for (PanelLine panel : en) {
            panel.m_Selected = false;
        }
        this.getSelected(CacheType.CM_ELEMENT).clear();
    }

    public void setSelected(CacheType what, String id, boolean isSelected) {
        PanelLine theLine = this.getInfos(what, id);
        if (theLine != null) {
            theLine.m_Selected = isSelected;
            if (isSelected) {
                this.getSelected(what).add(id);
            } else {
                this.getSelected(what).remove(id);
            }
        }
    }

    public void setSelected(CacheType what, String[] ids, boolean isSelected) {
        if (ids != null) {
            for (String id : ids) {
                if (!StringUtil.isDefined((String)id)) continue;
                this.setSelected(what, id, isSelected);
            }
        }
    }

    public String[] getSelectedIds(CacheType what) {
        Set<String> selectedStrings = this.getSelected(what);
        return this.getSelected(what).toArray(new String[this.getSelected(what).size()]);
    }

    public int getSelectedNumber(CacheType what) {
        return this.getSelected(what).size();
    }

    public PanelLine[] getSelectedLines(CacheType what) {
        ArrayList<PanelLine> en = new ArrayList<PanelLine>(this.getCache(what).values());
        Collections.sort(en, new Comparator<PanelLine>(){

            @Override
            public int compare(PanelLine o1, PanelLine o2) {
                return o1.m_Values[0].toUpperCase().compareTo(o2.m_Values[0].toUpperCase());
            }
        });
        return en.toArray(new PanelLine[en.size()]);
    }

    protected Map<String, PanelLine> getCache(CacheType what) {
        switch (what) {
            case CM_SET: {
                return this.setCache;
            }
            case CM_ELEMENT: {
                return this.elementCache;
            }
        }
        return null;
    }

    protected Set<String> getSelected(CacheType what) {
        switch (what) {
            case CM_SET: {
                return this.selectedSets;
            }
            case CM_ELEMENT: {
                return this.selectedElements;
            }
        }
        return null;
    }
}

