/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.selectionPeas;

import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.EncodeHelper;
import com.stratelia.silverpeas.genericPanel.PanelLine;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterEdit;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterSelect;
import com.stratelia.silverpeas.genericPanel.PanelMiniFilterToken;
import com.stratelia.silverpeas.genericPanel.PanelOperation;
import com.stratelia.silverpeas.genericPanel.PanelProvider;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.selection.SelectionExtraParams;
import com.stratelia.silverpeas.selection.SelectionUsersGroups;
import com.stratelia.silverpeas.selectionPeas.BrowseGroupPanel;
import com.stratelia.silverpeas.selectionPeas.BrowsePanelProvider;
import com.stratelia.silverpeas.selectionPeas.BrowseUserPanel;
import com.stratelia.silverpeas.selectionPeas.CacheManager;
import com.stratelia.silverpeas.selectionPeas.CacheType;
import com.stratelia.silverpeas.selectionPeas.CartGroupPanel;
import com.stratelia.silverpeas.selectionPeas.CartUserPanel;
import com.stratelia.silverpeas.selectionPeas.SearchGroupPanel;
import com.stratelia.silverpeas.selectionPeas.SearchUserPanel;
import com.stratelia.silverpeas.selectionPeas.SelectionPeasSettings;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.ResourceLocator;
import org.silverpeas.core.admin.OrganisationController;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class CacheManagerUsersGroups
extends CacheManager {
    protected static final int COL_USER_LASTNAME = 0;
    protected static final int COL_USER_FIRSTNAME = 1;
    protected static final int COL_USER_EMAIL = 2;
    protected static final int COL_USER_DOMAIN = 3;
    protected static final int COL_GROUP_NAME = 0;
    protected static final int COL_GROUP_DESCRIPTION = 1;
    protected static final int COL_GROUP_NBUSERS = 2;
    protected OrganisationController m_oc = OrganisationControllerFactory.getOrganisationController();
    protected AdminController adminController = new AdminController(null);
    protected UserDetail userDetail = null;

    public CacheManagerUsersGroups(String language, ResourceLocator local, ResourceLocator icon, Selection selection, UserDetail ud) {
        super(language, local, icon, selection);
        this.userDetail = ud;
    }

    protected String getSetParentName(String id) {
        Group theGroup = this.m_oc.getGroup(id);
        if (theGroup != null) {
            String superId = theGroup.getSuperGroupId();
            Group theSuperGroup = this.m_oc.getGroup(superId);
            if (theSuperGroup != null) {
                return theSuperGroup.getName();
            }
            return "";
        }
        return "";
    }

    @Override
    public String[][] getContentLines(CacheType what, String id) {
        String[][] result = new String[0][0];
        switch (what) {
            case CM_ELEMENT: {
                if (SelectionPeasSettings.displayUsersGroups) {
                    AdminController ac = new AdminController(id);
                    String[] groupIds = ac.getDirectGroupsIdsOfUser(id);
                    String[] columns = this.getColumnsNames(CacheType.CM_SET);
                    if (groupIds != null && groupIds.length > 0) {
                        result = new String[groupIds.length][columns.length];
                        for (int iGrp = 0; iGrp < groupIds.length; ++iGrp) {
                            PanelLine pl = this.getLineFromId(CacheType.CM_SET, groupIds[iGrp]);
                            System.arraycopy(pl.m_Values, 0, result[iGrp], 0, columns.length);
                        }
                    }
                }
                return result;
            }
            case CM_SET: {
                if (SelectionPeasSettings.displayGroupsUsers) {
                    Group theGroup = this.m_oc.getGroup(id);
                    String[] userIds = null;
                    String[] columns = this.getColumnsNames(CacheType.CM_ELEMENT);
                    if (theGroup != null) {
                        userIds = theGroup.getUserIds();
                    }
                    if (userIds != null && userIds.length > 0) {
                        result = new String[userIds.length][columns.length];
                        for (int iUsr = 0; iUsr < userIds.length; ++iUsr) {
                            PanelLine pl = this.getLineFromId(CacheType.CM_ELEMENT, userIds[iUsr]);
                            System.arraycopy(pl.m_Values, 0, result[iUsr], 0, columns.length);
                        }
                    }
                }
                return result;
            }
        }
        return result;
    }

    @Override
    public String[] getContentColumnsNames(CacheType what) {
        switch (what) {
            case CM_ELEMENT: {
                return this.getColumnsNames(CacheType.CM_SET);
            }
            case CM_SET: {
                return this.getColumnsNames(CacheType.CM_ELEMENT);
            }
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[][] getContentInfos(CacheType what, String id) {
        String[][] valret;
        if (what == CacheType.CM_ELEMENT) {
            PanelLine pl = this.getInfos(CacheType.CM_ELEMENT, id);
            String[] names = this.getColumnsNames(CacheType.CM_ELEMENT);
            valret = new String[names.length][2];
            for (int i = 0; i < names.length && i < pl.m_Values.length; ++i) {
                valret[i][0] = names[i];
                valret[i][1] = pl.m_Values[i];
            }
        } else {
            PanelLine pl = this.getInfos(CacheType.CM_SET, id);
            String[] names = this.getColumnsNames(CacheType.CM_SET);
            valret = new String[names.length + 1][2];
            for (int i = 0; i < names.length && i < pl.m_Values.length; ++i) {
                valret[i][0] = names[i];
                valret[i][1] = pl.m_Values[i];
            }
            valret[names.length][0] = this.localResourceLocator.getString("selectionPeas.groupParent");
            valret[names.length][1] = this.getSetParentName(id);
        }
        return valret;
    }

    @Override
    public String getContentText(CacheType what) {
        if (what == CacheType.CM_SET) {
            return this.localResourceLocator.getString("selectionPeas.directUsersOfGroup");
        }
        if (what == CacheType.CM_ELEMENT) {
            return this.localResourceLocator.getString("selectionPeas.groupsOfUser");
        }
        return "";
    }

    @Override
    public String[] getColumnsNames(CacheType what) {
        if (what == CacheType.CM_SET) {
            String[] columnsHeader = SelectionPeasSettings.displayNbUsersByGroup ? (SelectionPeasSettings.displayDomains ? new String[]{this.globalResourceLocator.getString("GML.nom"), this.globalResourceLocator.getString("GML.description"), this.globalResourceLocator.getString("GML.users"), this.localResourceLocator.getString("selectionPeas.domain")} : new String[]{this.globalResourceLocator.getString("GML.nom"), this.globalResourceLocator.getString("GML.description"), this.globalResourceLocator.getString("GML.users")}) : (SelectionPeasSettings.displayDomains ? new String[]{this.globalResourceLocator.getString("GML.nom"), this.globalResourceLocator.getString("GML.description"), this.localResourceLocator.getString("selectionPeas.domain")} : new String[]{this.globalResourceLocator.getString("GML.nom"), this.globalResourceLocator.getString("GML.description")});
            return columnsHeader;
        }
        if (what == CacheType.CM_ELEMENT) {
            String[] columnsHeader = SelectionPeasSettings.displayDomains ? new String[]{this.globalResourceLocator.getString("GML.lastName"), this.globalResourceLocator.getString("GML.firstName"), this.globalResourceLocator.getString("GML.eMail"), this.localResourceLocator.getString("selectionPeas.domain")} : new String[]{this.globalResourceLocator.getString("GML.lastName"), this.globalResourceLocator.getString("GML.firstName"), this.globalResourceLocator.getString("GML.eMail")};
            return columnsHeader;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public PanelMiniFilterSelect getSelectMiniFilter(CacheType what) {
        if (what == CacheType.CM_SET) {
            return new PanelMiniFilterSelect(999, Integer.toString(what.getValue()), "set", URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.selectAll"), URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.unSelectAll"), this.localResourceLocator.getString("selectionPeas.selectAll"), this.localResourceLocator.getString("selectionPeas.unSelectAll"), this.localResourceLocator.getString("selectionPeas.selectAll"), this.localResourceLocator.getString("selectionPeas.unSelectAll"));
        }
        if (what == CacheType.CM_ELEMENT) {
            return new PanelMiniFilterSelect(999, Integer.toString(what.getValue()), "element", URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.selectAll"), URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.unSelectAll"), this.localResourceLocator.getString("selectionPeas.selectAll"), this.localResourceLocator.getString("selectionPeas.unSelectAll"), this.localResourceLocator.getString("selectionPeas.selectAll"), this.localResourceLocator.getString("selectionPeas.unSelectAll"));
        }
        return null;
    }

    @Override
    public PanelMiniFilterToken[] getPanelMiniFilters(CacheType what) {
        if (what == CacheType.CM_SET) {
            PanelMiniFilterToken[] theArray = new PanelMiniFilterToken[]{new PanelMiniFilterEdit(0, Integer.toString(what.getValue()), "", URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.filter"), this.localResourceLocator.getString("selectionPeas.filter"), this.localResourceLocator.getString("selectionPeas.filter"))};
            return theArray;
        }
        if (what == CacheType.CM_ELEMENT) {
            PanelMiniFilterToken[] theArray = new PanelMiniFilterToken[]{new PanelMiniFilterEdit(0, Integer.toString(what.getValue()), "", URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.filter"), this.localResourceLocator.getString("selectionPeas.filter"), this.localResourceLocator.getString("selectionPeas.filter"))};
            return theArray;
        }
        return new PanelMiniFilterToken[0];
    }

    @Override
    protected PanelLine getLineFromId(CacheType what, String id) {
        if (what == CacheType.CM_SET) {
            Group theGroup = this.m_oc.getGroup(id);
            SilverTrace.info((String)"selectionPeas", (String)"CacheManagerUsersGroups.getSetLineFromId()", (String)"root.GEN_MSG_PARAM_VALUE", (String)("id=" + id));
            String[] theValues = SelectionPeasSettings.displayNbUsersByGroup ? (SelectionPeasSettings.displayDomains ? new String[]{EncodeHelper.javaStringToHtmlString((String)theGroup.getName()), EncodeHelper.javaStringToHtmlString((String)theGroup.getDescription()), Integer.toString(this.m_oc.getAllSubUsersNumber(theGroup.getId())), EncodeHelper.javaStringToHtmlString((String)this.adminController.getDomain(theGroup.getDomainId()).getName())} : new String[]{EncodeHelper.javaStringToHtmlString((String)theGroup.getName()), EncodeHelper.javaStringToHtmlString((String)theGroup.getDescription()), Integer.toString(this.m_oc.getAllSubUsersNumber(theGroup.getId()))}) : (SelectionPeasSettings.displayDomains ? new String[]{EncodeHelper.javaStringToHtmlString((String)theGroup.getName()), EncodeHelper.javaStringToHtmlString((String)theGroup.getDescription()), EncodeHelper.javaStringToHtmlString((String)this.adminController.getDomain(theGroup.getDomainId()).getName())} : new String[]{EncodeHelper.javaStringToHtmlString((String)theGroup.getName()), EncodeHelper.javaStringToHtmlString((String)theGroup.getDescription())});
            return new PanelLine(theGroup.getId(), theValues, false);
        }
        if (what == CacheType.CM_ELEMENT) {
            UserDetail theUser = this.m_oc.getUserDetail(id);
            SilverTrace.info((String)"selectionPeas", (String)"CacheManagerUsersGroups.getElementLineFromId()", (String)"root.GEN_MSG_PARAM_VALUE", (String)("id=" + id));
            String[] theValues = SelectionPeasSettings.displayDomains ? new String[]{EncodeHelper.javaStringToHtmlString((String)theUser.getLastName()), EncodeHelper.javaStringToHtmlString((String)theUser.getFirstName()), EncodeHelper.javaStringToHtmlString((String)theUser.geteMail()), EncodeHelper.javaStringToHtmlString((String)this.adminController.getDomain(theUser.getDomainId()).getName())} : new String[]{EncodeHelper.javaStringToHtmlString((String)theUser.getLastName()), EncodeHelper.javaStringToHtmlString((String)theUser.getFirstName()), EncodeHelper.javaStringToHtmlString((String)theUser.geteMail())};
            return new PanelLine(theUser.getId(), theValues, false);
        }
        return null;
    }

    @Override
    public int getLineCount(CacheType what) {
        return 0;
    }

    @Override
    public BrowsePanelProvider getSearchPanelProvider(CacheType what, SelectionExtraParams sep) {
        switch (what) {
            case CM_SET: {
                return new SearchGroupPanel(this.language, this.localResourceLocator, (CacheManager)this, this.getSureExtraParams(sep));
            }
            case CM_ELEMENT: {
                return new SearchUserPanel(this.language, this.localResourceLocator, (CacheManager)this, this.getSureExtraParams(sep));
            }
        }
        return null;
    }

    @Override
    public BrowsePanelProvider getBrowsePanelProvider(CacheType what, SelectionExtraParams sep) {
        switch (what) {
            case CM_SET: {
                return new BrowseGroupPanel(this.language, this.localResourceLocator, (CacheManager)this, this.getSureExtraParams(sep));
            }
            case CM_ELEMENT: {
                return new BrowseUserPanel(this.language, this.localResourceLocator, (CacheManager)this, this.getSureExtraParams(sep));
            }
        }
        return null;
    }

    @Override
    public PanelProvider getCartPanelProvider(CacheType what, SelectionExtraParams sep) {
        switch (what) {
            case CM_SET: {
                return new CartGroupPanel(this.language, this.localResourceLocator, this, this.getSureExtraParams(sep));
            }
            case CM_ELEMENT: {
                return new CartUserPanel(this.language, this.localResourceLocator, this, this.getSureExtraParams(sep));
            }
        }
        return null;
    }

    @Override
    public PanelOperation getPanelOperation(String operation) {
        if ("DisplayBrowse".equals(operation)) {
            return new PanelOperation(this.localResourceLocator.getString("selectionPeas.helpBrowse"), URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.browseArb"), operation);
        }
        if ("DisplaySearchElement".equals(operation)) {
            return new PanelOperation(this.localResourceLocator.getString("selectionPeas.helpSearchElement"), URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.userSearc"), operation);
        }
        if ("DisplaySearchSet".equals(operation)) {
            return new PanelOperation(this.localResourceLocator.getString("selectionPeas.helpSearchSet"), URLManager.getApplicationURL() + this.iconResourceLocator.getString("selectionPeas.groupSearc"), operation);
        }
        return null;
    }

    protected SelectionUsersGroups getSureExtraParams(SelectionExtraParams sep) {
        SelectionUsersGroups valret = (SelectionUsersGroups)sep;
        if (valret == null) {
            valret = new SelectionUsersGroups();
        }
        if (this.userDetail.isDomainAdminRestricted() && (valret.getDomainId() == null || valret.getDomainId().length() <= 0)) {
            valret.setDomainId(this.userDetail.getDomainId());
        }
        return valret;
    }
}

