/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.selectionPeas.jdbc;

import com.stratelia.silverpeas.selection.SelectionJdbcParams;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public class JdbcConnectorDAO {
    private Driver driver = null;
    String driverClassName;
    String url;
    String login;
    String password;
    String tableName;
    ArrayList<String[]> data;
    String[] columnsNames;
    String[] ids;

    public JdbcConnectorDAO(SelectionJdbcParams jdbcParams) {
        this.driverClassName = jdbcParams.getDriverClassName();
        this.url = jdbcParams.getUrl();
        this.login = jdbcParams.getLogin();
        this.password = jdbcParams.getPassword();
        this.tableName = jdbcParams.getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnsNames() {
        if (this.columnsNames == null) {
            ArrayList<String> columns = new ArrayList<String>();
            Connection con = null;
            ResultSet columnsRs = null;
            try {
                Properties info = new Properties();
                info.setProperty("user", this.login);
                info.setProperty("password", this.password);
                con = this.getDriver().connect(this.url, info);
                DatabaseMetaData dbMetaData = con.getMetaData();
                columnsRs = dbMetaData.getColumns(null, "%", this.tableName, "%");
                while (columnsRs.next()) {
                    String columnName = columnsRs.getString("COLUMN_NAME");
                    columns.add(columnName);
                }
                this.closeConnection(con, null, columnsRs);
            }
            catch (SQLException e) {
                SilverTrace.warn((String)"selectionPeas", (String)"JdbcConnectorDAO.getColumnsNames()", (String)"selectionPeas.MSG_CONNECTION_NOT_STARTED", (Throwable)e);
            }
            finally {
                this.closeConnection(con, null, columnsRs);
            }
            this.columnsNames = columns.toArray(new String[columns.size()]);
        }
        return this.columnsNames;
    }

    public ArrayList<String[]> getData() {
        if (this.data == null) {
            this.loadData();
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        StringBuilder columnNameSb = new StringBuilder(100);
        int columnsNamesCount = this.columnsNames.length;
        for (int i = 0; i < columnsNamesCount; ++i) {
            columnNameSb.append(this.columnsNames[i]).append(",");
        }
        String query = new StringBuffer(100).append("select ").append(columnNameSb.substring(0, columnNameSb.length() - 1)).append(" from ").append(this.tableName).toString();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Properties info = new Properties();
            info.setProperty("user", this.login);
            info.setProperty("password", this.password);
            con = this.getDriver().connect(this.url, info);
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            this.data = new ArrayList();
            while (rs.next()) {
                String[] line = new String[columnsNamesCount];
                for (int i = 0; i < columnsNamesCount; ++i) {
                    line[i] = rs.getString(i + 1);
                }
                this.data.add(line);
            }
            this.closeConnection(con, stmt, rs);
        }
        catch (SQLException e) {
            SilverTrace.warn((String)"selectionPeas", (String)"JdbcConnectorDAO.loadData()", (String)"selectionPeas.MSG_DATA_CANNOT_BE_LOADED", (Throwable)e);
        }
        finally {
            this.closeConnection(con, stmt, rs);
        }
    }

    public String[] getLine(String index) {
        return this.getData().get(Integer.parseInt(index));
    }

    public int getLineCount() {
        return this.getData().size();
    }

    private Driver getDriver() {
        if (this.driver == null) {
            try {
                this.driver = (Driver)Class.forName(this.driverClassName).newInstance();
            }
            catch (Exception e) {
                SilverTrace.warn((String)"selectionPeas", (String)"JdbcConnectorDAO.getDriver()", (String)"selectionPeas.MSG_DRIVER_INIT_FAILED", (Throwable)e);
            }
        }
        return this.driver;
    }

    private void closeConnection(Connection con, Statement stmt, ResultSet rs) {
        DBUtil.close((ResultSet)rs, (Statement)stmt);
        DBUtil.close((Connection)con);
    }
}

