/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.agenda.control;

import com.stratelia.webactiv.agenda.control.AgendaException;
import com.stratelia.webactiv.calendar.control.SilverpeasCalendar;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import java.util.Collection;
import java.util.Date;

public class AgendaAccess {
    private static SilverpeasCalendar calendarBm = null;

    private static SilverpeasCalendar getEJB() throws AgendaException {
        if (calendarBm == null) {
            try {
                calendarBm = (SilverpeasCalendar)EJBUtilitaire.getEJBObjectRef((String)JNDINames.CALENDARBM_EJBHOME, SilverpeasCalendar.class);
            }
            catch (Exception e) {
                throw new AgendaException("AgendaAccess.getEJB()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return calendarBm;
    }

    public static boolean hasTentativeSchedulables(String userId) throws AgendaException {
        try {
            return AgendaAccess.getEJB().hasTentativeSchedulablesForUser(userId);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaAccess.hasTentativeSchedulables()", 4, "agenda.EX_CANT_GET_TENTATIVE_SCHEDULABLES", "userId=" + userId, e);
        }
    }

    public static Date getCurrentDay() {
        return new Date();
    }

    public static Collection<JournalHeader> getDaySchedulables(String userId) throws AgendaException {
        try {
            return AgendaAccess.getEJB().getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)AgendaAccess.getCurrentDay()), userId, null, "accepted");
        }
        catch (Exception e) {
            throw new AgendaException("AgendaAccess.getDaySchedulables()", 4, "agenda.EX_CANT_GET_TENTATIVE_SCHEDULABLES", "userId=" + userId, e);
        }
    }

    public static Collection<JournalHeader> getNextDaySchedulables(String userId) throws AgendaException {
        try {
            return AgendaAccess.getEJB().getNextDaySchedulablesForUser(DateUtil.date2SQLDate((Date)AgendaAccess.getCurrentDay()), userId, null, "accepted");
        }
        catch (Exception e) {
            throw new AgendaException("AgendaAccess.getDaySchedulables()", 4, "agenda.EX_CANT_GET_TENTATIVE_SCHEDULABLES", "userId=" + userId, e);
        }
    }

    public static Collection<JournalHeader> getJournalHeadersForUserAfterDate(String userIdAgenda, Date startDate, int nbReturned) throws AgendaException {
        try {
            return AgendaAccess.getEJB().getJournalHeadersForUserAfterDate(userIdAgenda, startDate, nbReturned);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaAccess.getJournalHeadersForUserAfterDate()", 4, "agenda.EX_CANT_GET_JOURNAL", "userId=" + userIdAgenda, e);
        }
    }
}

