/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.agenda.control;

import com.silverpeas.ical.ExportIcalManager;
import com.silverpeas.ical.ImportIcalManager;
import com.silverpeas.ical.SynchroIcalManager;
import com.silverpeas.notification.builder.UserNotificationBuider;
import com.silverpeas.notification.builder.helper.UserNotificationHelper;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.peasCore.AbstractComponentSessionController;
import com.stratelia.silverpeas.peasCore.ComponentContext;
import com.stratelia.silverpeas.peasCore.MainSessionController;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.selection.Selection;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.silverpeas.util.PairObject;
import com.stratelia.webactiv.agenda.control.AgendaException;
import com.stratelia.webactiv.agenda.control.AgendaRuntimeException;
import com.stratelia.webactiv.agenda.model.CalendarImportSettings;
import com.stratelia.webactiv.agenda.model.CalendarImportSettingsDao;
import com.stratelia.webactiv.agenda.model.CalendarImportSettingsDaoJdbc;
import com.stratelia.webactiv.agenda.notification.AgendaUserNotification;
import com.stratelia.webactiv.agenda.view.AgendaHtmlView;
import com.stratelia.webactiv.beans.admin.AdminController;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.calendar.control.CalendarException;
import com.stratelia.webactiv.calendar.control.SilverpeasCalendar;
import com.stratelia.webactiv.calendar.model.Attendee;
import com.stratelia.webactiv.calendar.model.Category;
import com.stratelia.webactiv.calendar.model.HolidayDetail;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.calendar.model.ParticipationStatus;
import com.stratelia.webactiv.calendar.model.Schedulable;
import com.stratelia.webactiv.calendar.model.SchedulableCount;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.URLUtils;

public class AgendaSessionController
extends AbstractComponentSessionController {
    private int currentDisplayType = 1;
    private boolean calendarVisible = true;
    private Calendar currentCalendar;
    private SilverpeasCalendar calendarBm;
    private Category category = null;
    private ResourceLocator settings;
    private JournalHeader currentJournalHeader = null;
    private Collection<Attendee> currentAttendees = null;
    private Collection<Category> currentCategories = null;
    private ParticipationStatus participationStatus = null;
    private NotificationSender notifSender = null;
    private List<Date> nonSelectableDays = null;
    private List<String> holidaysDates = null;
    private String serverURL = null;
    private String agendaUserId = this.getUserId();
    private UserDetail agendaUserDetail = this.getUserDetail();
    private final CalendarImportSettingsDao importSettingsDao = new CalendarImportSettingsDaoJdbc();
    public static final String ICALENDAR_MIME_TYPE = "text/calendar";
    public static final String EXPORT_SUCCEEDED = "0";
    public static final String EXPORT_FAILED = "1";
    public static final String EXPORT_EMPTY = "2";
    public static final String IMPORT_SUCCEEDED = "0";
    public static final String IMPORT_FAILED = "1";
    public static final String SYNCHRO_SUCCEEDED = "0";
    public static final String SYNCHRO_FAILED = "1";
    public static final String AGENDA_FILENAME_PREFIX = "agenda";
    public static final int WORKING_DAY = 0;
    public static final int HOLIDAY_DAY = 1;

    public AgendaSessionController(MainSessionController mainSessionCtrl, ComponentContext context) {
        super(mainSessionCtrl, context, "org.silverpeas.agenda.multilang.agenda");
        this.setComponentRootName(AGENDA_FILENAME_PREFIX);
        this.initEJB();
        AdminController admin = new AdminController("useless");
        Domain defaultDomain = admin.getDomain(this.getUserDetail().getDomainId());
        this.serverURL = defaultDomain.getSilverpeasServerURL();
    }

    private boolean isUseRss() {
        return "yes".equals(this.getSettings().getString("calendarRss"));
    }

    @Override
    public String getRSSUrl() {
        if (this.isUseRss()) {
            return "/rssAgenda/" + this.getAgendaUserId() + "?userId=" + this.getUserId() + "&amp;login=" + URLUtils.encodePathParamValue((String)this.getUserDetail().getLogin()) + "&amp;password=" + URLUtils.encodePathParamValue((String)this.getOrganisationController().getUserFull(this.getUserId()).getPassword());
        }
        return null;
    }

    private void initEJB() {
        this.calendarBm = null;
        this.setCalendarBm();
    }

    private void setCalendarBm() {
        if (this.calendarBm == null) {
            try {
                this.calendarBm = (SilverpeasCalendar)EJBUtilitaire.getEJBObjectRef((String)JNDINames.CALENDARBM_EJBHOME, SilverpeasCalendar.class);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException("AgendaSessionController.setCalendarBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
    }

    protected String getComponentInstName() {
        return AGENDA_FILENAME_PREFIX;
    }

    public String addJournal(String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour) throws RemoteException {
        JournalHeader journal = new JournalHeader(name, this.getUserId());
        journal.setDescription(description);
        try {
            journal.getPriority().setValue(Integer.parseInt(priority));
        }
        catch (Exception e) {
            SilverTrace.warn((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.addJournal(String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour)", (String)"agenda.MSG_CANT_GET_PRIORITY", (String)"", (Throwable)e);
        }
        try {
            journal.getClassification().setString(classification);
            journal.setStartDay(DateUtil.date2SQLDate((Date)startDay));
            journal.setStartHour(startHour);
            journal.setEndDay(DateUtil.date2SQLDate((Date)endDay));
            journal.setEndHour(endHour);
        }
        catch (ParseException pe) {
            throw new AgendaRuntimeException("AgendaSessionController.addJournal(String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour)", 4, "agenda.EX_CANT_ADD_JOURNAL", pe);
        }
        String result = this.calendarBm.addJournal(journal);
        return result;
    }

    protected void notifyAttendees(String id, NotifAction action) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuider)new AgendaUserNotification(action, this.getUserDetail(), this.getJournalHeader(id)));
        }
        catch (Exception e) {
            SilverTrace.warn((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.notifyAttendees()", (String)"agenda.MSG_CANT_SEND_MAILS", (Throwable)e);
        }
    }

    protected void notifyFromAttendee(String id, String attend) {
        try {
            UserNotificationHelper.buildAndSend((UserNotificationBuider)new AgendaUserNotification(this.getUserDetail(), this.getJournalHeader(id), attend));
        }
        catch (Exception e) {
            SilverTrace.warn((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.notifyFromAttendee()", (String)"agenda.MSG_CANT_SEND_MAILS", (Throwable)e);
        }
    }

    public void updateJournal(String id, String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour) throws RemoteException, CalendarException {
        boolean changed = false;
        JournalHeader journal = this.getJournalHeader(id);
        journal.setName(name);
        journal.setDescription(description);
        try {
            journal.getPriority().setValue(Integer.parseInt(priority));
        }
        catch (Exception e) {
            SilverTrace.warn((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.updateJournal(String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour)", (String)"agenda.MSG_CANT_GET_PRIORITY", (String)"", (Throwable)e);
        }
        try {
            changed = this.eventHasChanged(journal, startDay, startHour, endDay, endHour);
            journal.getClassification().setString(classification);
            journal.setStartDay(DateUtil.date2SQLDate((Date)startDay));
            journal.setStartHour(startHour);
            journal.setEndDay(DateUtil.date2SQLDate((Date)endDay));
            journal.setEndHour(endHour);
        }
        catch (ParseException pe) {
            throw new AgendaRuntimeException("AgendaSessionController.updateJournal(String name, String description, String priority, String classification, Date startDay, String startHour, Date endDay, String endHour)", 4, "agenda.EX_CANT_UPDATE_JOURNAL", pe);
        }
        this.calendarBm.updateJournal(journal);
        if (changed) {
            this.notifyAttendees(id, NotifAction.UPDATE);
        }
    }

    private boolean eventHasChanged(JournalHeader journal, Date startDay, String startHour, Date endDay, String endHour) {
        boolean hasChanged = true;
        if (DateUtil.datesAreEqual((Date)journal.getStartDate(), (Date)startDay) && DateUtil.datesAreEqual((Date)journal.getEndDate(), (Date)endDay) && journal.getStartHour() != null && journal.getStartHour().equals(startHour) && journal.getEndHour() != null && journal.getEndHour().equals(endHour)) {
            hasChanged = false;
        }
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.eventHasChanged", (String)"root.MSG_GEN_EXIT_METHOD", (String)("dates have changed = " + hasChanged));
        return hasChanged;
    }

    public void removeJournal(String id) throws RemoteException, CalendarException {
        this.notifyAttendees(id, NotifAction.DELETE);
        this.calendarBm.removeJournal(id);
    }

    public JournalHeader getJournalHeader(String journalId) throws RemoteException {
        return this.calendarBm.getJournalHeader(journalId);
    }

    public Collection<Attendee> getJournalAttendees(String journalId) throws AgendaException {
        try {
            return this.calendarBm.getJournalAttendees(journalId);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController.getJournalAttendees(String journalId)", 4, "agenda.EX_CANT_GET_ATTENDEES", "journalId=" + journalId, e);
        }
    }

    public void setJournalAttendees(String journalId, String[] userIds) throws AgendaException {
        try {
            this.calendarBm.setJournalAttendees(journalId, userIds);
            this.notifyAttendees(journalId, NotifAction.CREATE);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController.setJournalAttendees(String journalId, String[] userIds)", 4, "agenda.EX_CANT_SET_ATTENDEES", "journalId=" + journalId, e);
        }
    }

    public void setJournalParticipationStatus(String journalId, String userId, String status) throws AgendaException {
        try {
            this.calendarBm.setJournalParticipationStatus(journalId, userId, status);
            this.notifyFromAttendee(journalId, status);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController.setJournalParticipationStatus(String journalId, String userId, String status)", 4, "agenda.EX_CANT_SET_STATUS", "journalId=" + journalId + " ,userId=" + this.getUserId() + ",status=" + status, e);
        }
    }

    public Collection<Category> getAllCategories() throws AgendaException {
        try {
            return this.calendarBm.getAllCategories();
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController. getAllCategories()", 4, "agenda.EX_CANT_GET_CATEGORIES", e);
        }
    }

    public Category getCategory(String categoryId) throws AgendaException {
        try {
            return this.calendarBm.getCategory(categoryId);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController. getCategory(String categoryId)", 4, "agenda.EX_CANT_GET_CATEGORY", "categoryId=" + categoryId, e);
        }
    }

    public Collection<Category> getJournalCategories(String journalId) throws AgendaException {
        try {
            return this.calendarBm.getJournalCategories(journalId);
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController. getJournalCategories(String journalId)", 4, "agenda.EX_CANT_GET_JOURNAL_CATEGORY", "journalId=" + journalId, e);
        }
    }

    public void setJournalCategories(String journalId, String[] categoryIds) throws AgendaException {
        try {
            this.calendarBm.setJournalCategories(journalId, categoryIds);
        }
        catch (Exception e) {
            throw new AgendaException("setJournalCategories(String journalId, String[] categoryIds)", 4, "agenda.EX_CANT_SET_JOURNAL_CATEGORY", "journalId=" + journalId, e);
        }
    }

    public void indexAll() throws RemoteException {
        this.calendarBm.indexAllJournal();
    }

    public UserDetail[] getUserList() {
        return this.getOrganisationController().getAllUsers();
    }

    @Override
    public UserDetail getUserDetail(String userId) {
        return this.getOrganisationController().getUserDetail(userId);
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public JournalHeader getCurrentJournalHeader() {
        return this.currentJournalHeader;
    }

    public void setCurrentJournalHeader(JournalHeader journalHeader) {
        this.currentJournalHeader = journalHeader;
    }

    public Collection<Attendee> getCurrentAttendees() {
        return this.currentAttendees;
    }

    public void setCurrentAttendees(Collection<Attendee> attendees) {
        this.currentAttendees = attendees;
    }

    public Collection<Category> getCurrentCategories() {
        return this.currentCategories;
    }

    public void setCurrentCategories(Collection<Category> categories) {
        this.currentCategories = categories;
    }

    public void setCalendarVisible(boolean visible) {
        this.calendarVisible = visible;
    }

    public ParticipationStatus getParticipationStatus() {
        if (this.participationStatus == null) {
            this.participationStatus = new ParticipationStatus("accepted");
        }
        return this.participationStatus;
    }

    public NotificationSender getNotificationSender() {
        if (this.notifSender == null) {
            this.notifSender = new NotificationSender(null);
        }
        return this.notifSender;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    public ResourceLocator getSettings() {
        if (this.settings == null) {
            this.settings = new ResourceLocator("com.stratelia.webactiv.agenda.settings.agendaSettings", "");
        }
        return this.settings;
    }

    public void viewByDay() {
        this.currentDisplayType = 1;
    }

    public void viewByWeek() {
        this.currentDisplayType = 2;
    }

    public void viewByMonth() {
        this.currentDisplayType = 3;
    }

    public void viewByYear() {
        this.currentDisplayType = 4;
    }

    public void viewChooseDays() {
        this.currentDisplayType = 5;
    }

    public int getCurrentDisplayType() {
        return this.currentDisplayType;
    }

    public AgendaHtmlView getCurrentHtmlView() throws RemoteException {
        AgendaHtmlView agendaView = null;
        Collection<JournalHeader> schedules = null;
        if (this.currentDisplayType == 1) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, this.getCurrentDay(), this, this.getSettings());
            agendaView.setCalendarVisible(this.calendarVisible);
            schedules = this.getDaySchedulables();
        } else if (this.currentDisplayType == 2) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, this.getWeekFirstDay(this.getCurrentDay()), this, this.getSettings());
            schedules = this.getWeekSchedulables();
        } else if (this.currentDisplayType == 3) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, AgendaSessionController.getMonthFirstDay(this.getCurrentDay()), this, this.getSettings());
            schedules = this.countMonthSchedulables();
        } else if (this.currentDisplayType == 4) {
            agendaView = new AgendaHtmlView(this.currentDisplayType, AgendaSessionController.getYearFirstDay(this.getCurrentDay()), this, this.getSettings());
        } else {
            return null;
        }
        if (schedules != null) {
            for (JournalHeader obj : schedules) {
                if (obj instanceof Schedulable) {
                    agendaView.add((Schedulable)obj);
                }
                if (!(obj instanceof SchedulableCount)) continue;
                agendaView.add((SchedulableCount)obj);
            }
        }
        return agendaView;
    }

    public Collection<JournalHeader> getDaySchedulables() throws RemoteException {
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)this.getCurrentDay()), this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<JournalHeader> getMonthSchedulables(Date date) throws RemoteException {
        Date begin = AgendaSessionController.getMonthFirstDay(date);
        Date end = this.getMonthLastDay(date);
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.getPeriodSchedulablesForUser(DateUtil.date2SQLDate((Date)begin), DateUtil.date2SQLDate((Date)end), this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<JournalHeader> getWeekSchedulables() throws RemoteException {
        Date begin = this.getWeekFirstDay(this.getCurrentDay());
        Date end = this.getWeekLastDay(this.getCurrentDay());
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.getPeriodSchedulablesForUser(DateUtil.date2SQLDate((Date)begin), DateUtil.date2SQLDate((Date)end), this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<SchedulableCount> countMonthSchedulables() throws RemoteException {
        String month = DateUtil.date2SQLDate((Date)this.getCurrentDay()).substring(0, 8);
        String categoryId = null;
        if (this.getCategory() != null) {
            categoryId = this.getCategory().getId();
        }
        return this.calendarBm.countMonthSchedulablesForUser(month, this.agendaUserId, categoryId, this.getParticipationStatus().getString());
    }

    public Collection<JournalHeader> getBusyTime(String userId, Date day) throws RemoteException {
        ArrayList<JournalHeader> result = this.calendarBm.getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)day), userId, null, "accepted");
        if (!userId.equals(this.getUserId())) {
            ArrayList<JournalHeader> subResult = new ArrayList<JournalHeader>();
            for (JournalHeader schedule : result) {
                boolean toView = false;
                if (!schedule.getClassification().isConfidential()) {
                    toView = true;
                } else if (schedule.getDelegatorId().equals(this.getUserId())) {
                    toView = true;
                } else {
                    Collection attendees = this.calendarBm.getJournalAttendees(schedule.getId());
                    for (Attendee attendee : attendees) {
                        if (!attendee.getUserId().equals(this.getUserId())) continue;
                        toView = true;
                    }
                }
                if (!toView) continue;
                subResult.add(schedule);
            }
            result = subResult;
        }
        return result;
    }

    public boolean isDayHasEvents(String userId, Date day) throws RemoteException {
        boolean isDayHasEvents = false;
        Collection result = this.calendarBm.getDaySchedulablesForUser(DateUtil.date2SQLDate((Date)day), userId, null, "accepted");
        if (result != null && result.size() > 0) {
            isDayHasEvents = true;
        }
        return isDayHasEvents;
    }

    public boolean hasTentativeSchedulables() throws RemoteException {
        return this.calendarBm.hasTentativeSchedulablesForUser(this.getUserId());
    }

    public Collection<JournalHeader> getTentativeSchedulables() throws AgendaException {
        try {
            return this.calendarBm.getTentativeSchedulablesForUser(this.getUserId());
        }
        catch (Exception e) {
            throw new AgendaException("AgendaSessionController.getTentativeSchedulables()", 4, "agenda.EX_CANT_GET_TENTATIVE_SCHEDULABLES", "userId=" + this.getUserId(), e);
        }
    }

    public Date getCurrentDay() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        return this.currentCalendar.getTime();
    }

    public int getStartDayInWeek() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 1) {
            return this.currentCalendar.get(7);
        }
        return Integer.parseInt(this.getString("weekFirstDay"));
    }

    public int getStartDayInMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 1) {
            return this.currentCalendar.get(5);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getWeekFirstDay(this.currentCalendar.getTime()));
        return cal.get(5);
    }

    public int getEndDayInMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 1) {
            return this.currentCalendar.get(5);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getWeekLastDay(this.currentCalendar.getTime()));
        return cal.get(5);
    }

    public int getStartMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 2) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getWeekFirstDay(this.currentCalendar.getTime()));
            return cal.get(2);
        }
        return this.currentCalendar.get(2);
    }

    public int getEndMonth() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 2) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getWeekLastDay(this.currentCalendar.getTime()));
            return cal.get(2);
        }
        return this.currentCalendar.get(2);
    }

    public int getStartYear() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        if (this.currentDisplayType == 2) {
            Calendar result = Calendar.getInstance();
            result.setTime(this.getWeekFirstDay(this.currentCalendar.getTime()));
            return result.get(1);
        }
        return this.currentCalendar.get(1);
    }

    public int getEndYear() {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getWeekLastDay(this.currentCalendar.getTime()));
        return cal.get(1);
    }

    public void setCurrentDay(Date date) {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        this.currentCalendar.setTime(date);
    }

    public void selectDay(String day) {
        if (this.currentCalendar == null) {
            this.currentCalendar = Calendar.getInstance();
        }
        try {
            Date date = DateUtil.stringToDate((String)day, (String)this.getLanguage());
            this.currentCalendar.setTime(date);
            this.viewByDay();
        }
        catch (Exception e) {
            SilverTrace.warn((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.selectDay(String day)", (String)"agenda.MSG_CANT_CHANGE_DAY", (String)"", (Throwable)e);
        }
    }

    public void next() throws RemoteException {
        if (this.currentDisplayType == 1) {
            this.nextDay();
        } else if (this.currentDisplayType == 2) {
            this.nextWeek();
        } else if (this.currentDisplayType == 3) {
            this.nextMonth();
        } else if (this.currentDisplayType == 4) {
            this.nextYear();
        }
    }

    public void nextDay() throws RemoteException {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, 1);
        while (this.isHolidayDate(this.currentCalendar.getTime())) {
            this.currentCalendar.add(5, 1);
        }
    }

    public void nextWeek() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, 7);
    }

    public void nextMonth() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(2, 1);
    }

    public void nextYear() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(1, 1);
    }

    public void previous() {
        if (this.currentDisplayType == 1) {
            this.previousDay();
        } else if (this.currentDisplayType == 2) {
            this.previousWeek();
        } else if (this.currentDisplayType == 3) {
            this.previousMonth();
        } else if (this.currentDisplayType == 4) {
            this.previousYear();
        }
    }

    public void previousDay() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, -1);
        while (this.isHolidayDate(this.currentCalendar.getTime())) {
            this.currentCalendar.add(5, -1);
        }
    }

    public void previousWeek() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(5, -7);
    }

    public void previousMonth() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(2, -1);
    }

    public void previousYear() {
        if (this.currentCalendar == null) {
            return;
        }
        this.currentCalendar.add(1, -1);
    }

    public Date getWeekFirstDay(Date date) {
        int firstDayOfWeek = Integer.parseInt(this.getString("weekFirstDay"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while (calendar.get(7) != firstDayOfWeek) {
            calendar.add(5, -1);
        }
        return calendar.getTime();
    }

    public Date getWeekLastDay(Date date) {
        int lastDayOfWeek = Integer.parseInt(this.getString("weekLastDay"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        while (calendar.get(7) != lastDayOfWeek) {
            calendar.add(5, 1);
        }
        return calendar.getTime();
    }

    public static Date getMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Date getMonthLastDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int monthLastDay = cal.getActualMaximum(5);
        cal.set(5, monthLastDay);
        return cal.getTime();
    }

    public static Date getYearFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(2, 1);
        return calendar.getTime();
    }

    public String initSelectionPeas() {
        String m_context = URLManager.getApplicationURL();
        PairObject hostComponentName = new PairObject((Object)this.getString(AGENDA_FILENAME_PREFIX), (Object)(m_context + "/Ragenda/jsp/Main"));
        PairObject[] hostPath = new PairObject[]{new PairObject((Object)this.getString("editionListeDiffusion"), (Object)(m_context + "/Ragenda/jsp/Main"))};
        String hostUrl = m_context + "/Ragenda/jsp/saveMembers";
        String cancelUrl = m_context + "/Ragenda/jsp/saveMembers";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName("");
        sel.setHostPath(hostPath);
        sel.setHostComponentName(hostComponentName);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        Collection<Attendee> members = this.getCurrentAttendees();
        if (members != null) {
            String[] usersSelected = new String[members.size()];
            int j = 0;
            for (Attendee attendee : members) {
                usersSelected[j] = attendee.getUserId();
                ++j;
            }
            sel.setSelectedElements(usersSelected);
        }
        sel.setPopupMode(true);
        sel.setElementSelectable(true);
        sel.setSetSelectable(false);
        sel.setFirstPage("Default");
        return Selection.getSelectionURL((String)"UsersGroups");
    }

    public Collection<Attendee> getUserSelected() throws AgendaException {
        String[] selectedUsers;
        Selection sel = this.getSelection();
        ArrayList<Attendee> attendees = new ArrayList<Attendee>();
        Collection<Attendee> oldAttendees = null;
        JournalHeader journal = this.getCurrentJournalHeader();
        if (journal.getId() != null) {
            oldAttendees = this.getJournalAttendees(journal.getId());
        }
        if ((selectedUsers = sel.getSelectedElements()) != null) {
            for (String selectedUser : selectedUsers) {
                Attendee newAttendee = null;
                if (oldAttendees != null) {
                    for (Attendee attendee : oldAttendees) {
                        if (!attendee.getUserId().equals(selectedUser)) continue;
                        newAttendee = attendee;
                    }
                }
                if (newAttendee == null) {
                    newAttendee = new Attendee(selectedUser);
                }
                attendees.add(newAttendee);
            }
        }
        return attendees;
    }

    @Override
    public void close() {
        this.calendarBm = null;
    }

    public List<Date> getNonSelectableDays() {
        if (this.nonSelectableDays == null) {
            this.nonSelectableDays = new ArrayList<Date>();
        }
        return this.nonSelectableDays;
    }

    public void setNonSelectableDays(List<Date> list) {
        this.nonSelectableDays = list;
    }

    public List<String> getHolidaysDates() throws RemoteException {
        if (this.holidaysDates == null) {
            this.holidaysDates = this.getHolidaysDatesInDb();
        }
        return this.holidaysDates;
    }

    public void setHolidaysDates(List<String> list) {
        this.holidaysDates = list;
    }

    public String initUserPanelOtherAgenda() {
        String m_context = URLManager.getApplicationURL();
        PairObject hostComponentName = new PairObject((Object)this.getString(AGENDA_FILENAME_PREFIX), (Object)(m_context + "/Ragenda/jsp/Main"));
        PairObject[] hostPath = new PairObject[]{new PairObject((Object)this.getString("viewOtherAgenda"), (Object)(m_context + URLManager.getURL((String)AGENDA_FILENAME_PREFIX, null, null) + "Main"))};
        String hostUrl = m_context + URLManager.getURL((String)AGENDA_FILENAME_PREFIX, null, null) + "ViewOtherAgenda";
        String cancelUrl = m_context + URLManager.getURL((String)AGENDA_FILENAME_PREFIX, null, null) + "Main";
        Selection sel = this.getSelection();
        sel.resetAll();
        sel.setHostSpaceName("");
        sel.setHostPath(hostPath);
        sel.setHostComponentName(hostComponentName);
        sel.setGoBackURL(hostUrl);
        sel.setCancelURL(cancelUrl);
        sel.setPopupMode(true);
        sel.setMultiSelect(false);
        sel.setSetSelectable(false);
        sel.setElementSelectable(true);
        return Selection.getSelectionURL((String)"UsersGroups");
    }

    public UserDetail getSelectedUser() {
        Selection sel = this.getSelection();
        UserDetail selectedUser = null;
        String[] selectedUsers = sel.getSelectedElements();
        if (selectedUsers != null) {
            selectedUser = this.getUserDetail(selectedUsers[0]);
        }
        return selectedUser;
    }

    public void setAgendaUserDetail(UserDetail userDetail) {
        this.agendaUserDetail = userDetail;
        this.agendaUserId = userDetail.getId();
    }

    public UserDetail getAgendaUserDetail() {
        return this.agendaUserDetail;
    }

    public String getAgendaUserId() {
        return this.agendaUserId;
    }

    public boolean isOtherAgendaMode() {
        return !this.agendaUserId.equals(this.getUserId());
    }

    public CalendarImportSettings getImportSettings() {
        return this.importSettingsDao.getUserSettings(this.getUserId());
    }

    public void saveUserSettings(CalendarImportSettings importSettings) throws AgendaException {
        this.importSettingsDao.saveUserSettings(importSettings);
    }

    public void updateUserSettings(CalendarImportSettings importSettings) throws AgendaException {
        this.importSettingsDao.updateUserSettings(importSettings);
    }

    public String exportIcalAgenda(String startDate, String endDate) throws Exception {
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.exportIcalAgenda()", (String)"root.MSG_GEN_ENTER_METHOD");
        String returnCode = new ExportIcalManager(this).exportIcalAgenda(startDate, endDate);
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.exportIcalAgenda()", (String)"root.MSG_GEN_EXIT_METHOD");
        return returnCode;
    }

    public String exportIcalAgenda() throws Exception {
        return this.exportIcalAgenda(null, null);
    }

    public String importIcalAgenda(File fileCalendar) throws Exception {
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.importIcalAgenda()", (String)"root.MSG_GEN_ENTER_METHOD");
        String returnCode = new ImportIcalManager(this).importIcalAgenda(fileCalendar);
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.importIcalAgenda()", (String)"root.MSG_GEN_EXIT_METHOD");
        return returnCode;
    }

    public String synchroIcalAgenda(String urlICalendar, String loginIcalendar, String pwdIcalendar) throws Exception {
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.synchroIcalAgenda()", (String)"root.MSG_GEN_ENTER_METHOD");
        URL iCalendarServerUrl = new URL(urlICalendar);
        String returnCodeSynchro = new SynchroIcalManager(this).synchroIcalAgenda(iCalendarServerUrl, this.getIcalendarFile(), loginIcalendar, pwdIcalendar);
        SilverTrace.debug((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.synchroIcalAgenda()", (String)"root.MSG_GEN_EXIT_METHOD");
        return returnCodeSynchro;
    }

    public String synchroIcalAgenda(String urlICalendar) throws Exception {
        return this.synchroIcalAgenda(urlICalendar, null, null);
    }

    private File getIcalendarFile() {
        return new File(FileRepositoryManager.getTemporaryPath() + AGENDA_FILENAME_PREFIX + this.getUserId() + ".ics");
    }

    public List<String> getHolidaysDatesInDb() throws RemoteException {
        return this.calendarBm.getHolidayDates(this.getAgendaUserId());
    }

    public void changeDateStatus(String date, String nextStatus) throws RemoteException, ParseException {
        int status = Integer.parseInt(nextStatus);
        HolidayDetail holiday = new HolidayDetail(DateUtil.parse((String)date), this.getUserId());
        if (status == 0) {
            this.calendarBm.removeHolidayDate(holiday);
        } else {
            this.calendarBm.addHolidayDate(holiday);
        }
        this.setHolidaysDates(this.getHolidaysDatesInDb());
    }

    public void changeDayOfWeekStatus(String year, String month, String day) throws RemoteException {
        SilverTrace.info((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.changeDayOfWeekStatus()", (String)"root.MSG_GEN_ENTER_METHOD", (String)("year=" + year + ", month=" + month + ", day=" + day));
        int iMonth = Integer.parseInt(month);
        this.currentCalendar.set(1, Integer.parseInt(year));
        this.currentCalendar.set(2, iMonth);
        this.currentCalendar.set(5, 1);
        while (this.currentCalendar.get(7) != Integer.parseInt(day)) {
            this.currentCalendar.add(5, 1);
        }
        Date date = this.currentCalendar.getTime();
        HolidayDetail holidayDate = new HolidayDetail(date, this.getUserId());
        boolean isHoliday = this.calendarBm.isHolidayDate(holidayDate);
        ArrayList<HolidayDetail> holidayDates = new ArrayList<HolidayDetail>();
        while (this.currentCalendar.get(2) == iMonth) {
            holidayDates.add(new HolidayDetail(this.currentCalendar.getTime(), this.getUserId()));
            this.currentCalendar.add(5, 7);
        }
        if (isHoliday) {
            this.calendarBm.removeHolidayDates(holidayDates);
        } else {
            this.calendarBm.addHolidayDates(holidayDates);
        }
        this.setHolidaysDates(this.getHolidaysDatesInDb());
        this.currentCalendar.set(1, Integer.parseInt(year));
        this.currentCalendar.set(2, iMonth);
        this.currentCalendar.set(5, 1);
        SilverTrace.info((String)AGENDA_FILENAME_PREFIX, (String)"AgendaSessionController.changeDayOfWeekStatus()", (String)"root.MSG_GEN_EXIT_METHOD", (String)("year=" + year + ", month=" + month + ", day=" + day));
    }

    public boolean isHolidayDate(Date date) {
        HolidayDetail currentDate = new HolidayDetail(date, this.getAgendaUserId());
        return this.calendarBm.isHolidayDate(currentDate);
    }

    public boolean isHolidayDate(String agendaUserId, Date date) {
        HolidayDetail currentDate = new HolidayDetail(date, agendaUserId);
        return this.calendarBm.isHolidayDate(currentDate);
    }

    public boolean isSameDaysAreHolidays(Calendar cal, int currentMonth) {
        Calendar localCalendar = (Calendar)cal.clone();
        boolean isSameDaysAreHolidays = true;
        for (int day = 1; day < 5 && isSameDaysAreHolidays; ++day) {
            if (!this.isHolidayDate(localCalendar.getTime()) && localCalendar.get(2) == currentMonth) {
                isSameDaysAreHolidays = false;
            }
            localCalendar.add(5, 7);
        }
        return isSameDaysAreHolidays;
    }

    public String getMyAgendaUrl() {
        String url = "/SubscribeAgenda/agenda?userId=" + this.getUserId() + "&amp;login=" + URLUtils.encodePathParamValue((String)this.getUserDetail().getLogin()) + "&amp;password=" + URLUtils.encodePathParamValue((String)OrganisationControllerFactory.getOrganisationController().getUserFull(this.getUserId()).getPassword());
        return url;
    }

    public String getCurrentViewType() {
        String viewType = "Main";
        switch (this.getCurrentDisplayType()) {
            case 1: {
                viewType = "Main";
                break;
            }
            case 2: {
                viewType = "ViewByWeek";
                break;
            }
            case 3: {
                viewType = "ViewByMonth";
                break;
            }
            case 4: {
                viewType = "ViewByYear";
            }
        }
        return viewType;
    }
}

