/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.agenda.model;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.agenda.control.AgendaException;
import com.stratelia.webactiv.agenda.model.CalendarImportSettings;
import com.stratelia.webactiv.agenda.model.CalendarImportSettingsDao;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CalendarImportSettingsDaoJdbc
implements CalendarImportSettingsDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarImportSettings getUserSettings(String userId) {
        CalendarImportSettings settings;
        ResultSet rs;
        PreparedStatement st;
        Connection connection;
        block4: {
            connection = null;
            st = null;
            rs = null;
            settings = null;
            String query = "select * from sb_agenda_import_settings where userId = ?";
            try {
                connection = this.getConnection();
                st = connection.prepareStatement(query);
                st.setInt(1, Integer.parseInt(userId));
                rs = st.executeQuery();
                if (!rs.next()) break block4;
                settings = new CalendarImportSettings();
                settings.setUserId(rs.getInt("userId"));
                settings.setHostName(rs.getString("hostname"));
                settings.setSynchroType(rs.getInt("synchroType"));
                settings.setSynchroDelay(rs.getInt("synchroDelay"));
                settings.setUrlIcalendar(rs.getString("url"));
                settings.setLoginIcalendar(rs.getString("remoteLogin"));
                settings.setPwdIcalendar(rs.getString("remotePwd"));
                settings.setCharset(rs.getString("charset"));
            }
            catch (Exception e) {
                try {
                    SilverTrace.error((String)"agenda", (String)"CalendarImportSettingsDaoJdbc", (String)"agenda.EX_CANT_GET_USER_SETTINGS", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(rs, st);
                    this.close(connection);
                    throw throwable;
                }
                DBUtil.close(rs, (Statement)st);
                this.close(connection);
            }
        }
        DBUtil.close((ResultSet)rs, (Statement)st);
        this.close(connection);
        return settings;
    }

    @Override
    public void saveUserSettings(CalendarImportSettings settings) throws AgendaException {
        Connection connection = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        String insertStatement = "insert into sb_agenda_import_settings (userId, hostName, synchroType, synchroDelay, url, remoteLogin, remotePwd, charset) values (?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            connection = this.getConnection();
            st = connection.prepareStatement(insertStatement);
            st.setInt(1, settings.getUserId());
            st.setString(2, settings.getHostName());
            st.setInt(3, settings.getSynchroType());
            st.setInt(4, settings.getSynchroDelay());
            st.setString(5, settings.getUrlIcalendar());
            st.setString(6, settings.getLoginIcalendar());
            st.setString(7, settings.getPwdIcalendar());
            st.setString(8, settings.getCharset());
            st.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AgendaException("CalendarImportSettingsDaoJdbc.saveUserSettings", 4, "agenda.EX_CANT_SAVE_USER_SETTINGS", "user id = " + settings.getUserId(), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, st);
                this.close(connection);
                throw throwable;
            }
        }
        DBUtil.close(rs, (Statement)st);
        this.close(connection);
    }

    @Override
    public void updateUserSettings(CalendarImportSettings settings) throws AgendaException {
        Connection connection = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        String updateStatement = "update sb_agenda_import_settings set hostName = ?, synchroType = ?, synchroDelay = ?, url= ?, remoteLogin= ?, remotePwd= ?, charset= ? where userId = ?";
        try {
            connection = this.getConnection();
            st = connection.prepareStatement(updateStatement);
            st.setString(1, settings.getHostName());
            st.setInt(2, settings.getSynchroType());
            st.setInt(3, settings.getSynchroDelay());
            st.setString(4, settings.getUrlIcalendar());
            st.setString(5, settings.getLoginIcalendar());
            st.setString(6, settings.getPwdIcalendar());
            st.setString(7, settings.getCharset());
            st.setInt(8, settings.getUserId());
            st.executeUpdate();
        }
        catch (Exception e) {
            try {
                throw new AgendaException("CalendarImportSettingsDaoJdbc.updateUserSettings", 4, "agenda.EX_CANT_UPDATE_USER_SETTINGS", "user id = " + settings.getUserId(), e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, st);
                this.close(connection);
                throw throwable;
            }
        }
        DBUtil.close(rs, (Statement)st);
        this.close(connection);
    }

    protected void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private Connection getConnection() throws Exception {
        return DBUtil.makeConnection((String)JNDINames.DATABASE_DATASOURCE);
    }
}

