/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.agenda.notification;

import com.silverpeas.notification.builder.AbstractTemplateUserNotificationBuilder;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.agenda.control.AgendaRuntimeException;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.calendar.control.SilverpeasCalendar;
import com.stratelia.webactiv.calendar.model.Attendee;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.EJBUtilitaire;
import com.stratelia.webactiv.util.JNDINames;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;

public class AgendaUserNotification
extends AbstractTemplateUserNotificationBuilder<JournalHeader> {
    private SilverpeasCalendar calendarBm;
    private final NotifAction action;
    private final UserDetail sender;
    private final String attend;

    public AgendaUserNotification(NotifAction action, UserDetail sender, JournalHeader resource) {
        this(action, sender, resource, null);
    }

    public AgendaUserNotification(UserDetail sender, JournalHeader resource, String attend) {
        this(NotifAction.RESPONSE, sender, resource, attend);
    }

    private AgendaUserNotification(NotifAction action, UserDetail sender, JournalHeader resource, String attend) {
        super((Object)resource);
        this.action = action;
        this.sender = sender;
        this.attend = attend;
    }

    protected void initialize() {
        super.initialize();
        this.getNotificationMetaData().setSource(this.getBundle(this.sender.getUserPreferences().getLanguage()).getString("agenda"));
    }

    protected String getBundleSubjectKey() {
        String subjectKey;
        switch (this.action) {
            case UPDATE: {
                subjectKey = "titleUpdate";
                break;
            }
            case DELETE: {
                subjectKey = "titleDelete";
                break;
            }
            case RESPONSE: {
                subjectKey = "titleAttend";
                break;
            }
            default: {
                subjectKey = "titleCreate";
            }
        }
        return subjectKey;
    }

    protected String getFileName() {
        String fileName;
        switch (this.action) {
            case UPDATE: {
                fileName = "updateEvent";
                break;
            }
            case DELETE: {
                fileName = "deleteEvent";
                break;
            }
            case RESPONSE: {
                fileName = "eventAttendeeResponse";
                break;
            }
            default: {
                fileName = "addEvent";
            }
        }
        return fileName;
    }

    protected Collection<String> getUserIdsToNotify() {
        HashSet<String> userIds;
        switch (this.action) {
            case RESPONSE: {
                userIds = Collections.singleton(((JournalHeader)this.getResource()).getDelegatorId());
                break;
            }
            default: {
                userIds = new HashSet();
                for (Attendee attendee : this.getCalendarBm().getJournalAttendees(((JournalHeader)this.getResource()).getId())) {
                    userIds.add(attendee.getUserId());
                }
            }
        }
        return userIds;
    }

    protected void performTemplateData(String language, JournalHeader resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getBundle(language).getString(this.getBundleSubjectKey(), this.getTitle()), "");
        template.setAttribute("sender", (Object)this.sender.getDisplayedName());
        if (StringUtil.isDefined((String)this.attend)) {
            template.setAttribute(this.attend, (Object)this.attend);
        }
        template.setAttribute("name", (Object)((JournalHeader)this.getResource()).getName());
        template.setAttribute("startDate", (Object)DateUtil.getOutputDate((Date)((JournalHeader)this.getResource()).getStartDate(), (String)language));
        if (StringUtil.isDefined((String)((JournalHeader)this.getResource()).getStartHour())) {
            template.setAttribute("startHour", (Object)((JournalHeader)this.getResource()).getStartHour());
        }
    }

    protected void performNotificationResource(String language, JournalHeader resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getName());
    }

    protected String getResourceURL(JournalHeader resource) {
        StringBuilder sb = new StringBuilder(URLManager.getURL((String)"agenda", null, null));
        sb.append("journal.jsp?JournalId=");
        sb.append(resource.getId());
        sb.append("&Action=");
        switch (this.action) {
            case DELETE: {
                return null;
            }
        }
        sb.append("Update");
        return sb.toString();
    }

    protected String getTemplatePath() {
        return "agenda";
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return "";
    }

    protected String getSender() {
        return this.sender.getId();
    }

    protected String getMultilangPropertyFile() {
        return "com.stratelia.webactiv.agenda.multilang.agenda";
    }

    protected boolean isSendImmediatly() {
        return true;
    }

    protected SilverpeasCalendar getCalendarBm() {
        if (this.calendarBm == null) {
            try {
                this.calendarBm = (SilverpeasCalendar)EJBUtilitaire.getEJBObjectRef((String)JNDINames.CALENDARBM_EJBHOME, SilverpeasCalendar.class);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException("AgendaUserNotification.getCalendarBm()", 4, "root.EX_CANT_GET_REMOTE_OBJECT", e);
            }
        }
        return this.calendarBm;
    }
}

