/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.agenda.view;

import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.agenda.control.AgendaException;
import com.stratelia.webactiv.agenda.control.AgendaRuntimeException;
import com.stratelia.webactiv.agenda.control.AgendaSessionController;
import com.stratelia.webactiv.agenda.view.CalendarHtmlView;
import com.stratelia.webactiv.calendar.model.Category;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.calendar.model.Schedulable;
import com.stratelia.webactiv.calendar.model.SchedulableCount;
import com.stratelia.webactiv.calendar.model.SchedulableGroup;
import com.stratelia.webactiv.calendar.model.SchedulableList;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;

public class AgendaHtmlView {
    public static final int BYDAY = 1;
    public static final int BYWEEK = 2;
    public static final int BYMONTH = 3;
    public static final int BYYEAR = 4;
    public static final int CHOOSE_DAYS = 5;
    private int WEEKDAYNUMBER = 7;
    private int BEGINHOUR = 8;
    private int ENDHOUR = 18;
    private String startDate;
    private Vector<Schedulable> schedules = new Vector();
    private CalendarHtmlView calendarHtmlView = null;
    private int viewType = 0;
    private AgendaSessionController agendaSessionController;
    private boolean calendarVisible = true;
    private boolean isOtherAgenda = false;
    private String dayOffStyle = "class=\"txtdayoff1\"";
    private String weekDayOffStyle = "class=\"txtdayoff2\"";

    public AgendaHtmlView(int viewType) {
        this.viewType = viewType;
        this.setDate(null);
    }

    public AgendaHtmlView(int viewType, Date date, AgendaSessionController agendaSessionController, ResourceLocator settings) {
        this.viewType = viewType;
        this.setDate(date);
        this.agendaSessionController = agendaSessionController;
        this.isOtherAgenda = agendaSessionController.isOtherAgendaMode();
        this.WEEKDAYNUMBER = Integer.parseInt(settings.getString("weekDayNumber"));
        this.BEGINHOUR = Integer.parseInt(settings.getString("beginHour"));
        this.ENDHOUR = Integer.parseInt(settings.getString("endHour"));
    }

    public void setCalendarVisible(boolean on) {
        this.calendarVisible = on;
    }

    public final void setDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        if (this.viewType == 1) {
            this.startDate = DateUtil.date2SQLDate((Date)date);
        }
        if (this.viewType == 2) {
            this.startDate = DateUtil.date2SQLDate((Date)date);
        }
        if (this.viewType == 3) {
            this.startDate = DateUtil.date2SQLDate((Date)date);
        }
        if (this.viewType == 4) {
            this.startDate = DateUtil.date2SQLDate((Date)date);
        }
    }

    public void add(SchedulableCount scheduleCount) {
        if (this.calendarHtmlView == null) {
            this.calendarHtmlView = new CalendarHtmlView();
        }
        this.calendarHtmlView.add(scheduleCount);
    }

    public void add(Schedulable schedule) {
        if (schedule.getStartDay() == null) {
            return;
        }
        try {
            if (schedule.getStartHour() != null && schedule.getStartHour().compareTo(Schedulable.hourMinuteToString((int)this.BEGINHOUR, (int)0)) < 0) {
                schedule.setStartHour(Schedulable.hourMinuteToString((int)this.BEGINHOUR, (int)0));
            }
            if (schedule.getEndHour() != null && schedule.getEndHour().compareTo(Schedulable.hourMinuteToString((int)this.ENDHOUR, (int)0)) > 0) {
                schedule.setEndHour(Schedulable.hourMinuteToString((int)this.ENDHOUR, (int)0));
            }
            if (schedule.getStartDay().equals(schedule.getEndDay())) {
                this.schedules.add(schedule);
            } else {
                Calendar start = Calendar.getInstance();
                start.setTime(schedule.getStartDate());
                while (DateUtil.date2SQLDate((Date)start.getTime()).compareTo(schedule.getEndDay()) <= 0) {
                    Schedulable copy = schedule.getCopy();
                    copy.setStartDay(DateUtil.date2SQLDate((Date)start.getTime()));
                    if (DateUtil.date2SQLDate((Date)start.getTime()).compareTo(schedule.getStartDay()) != 0 && schedule.getStartHour() != null) {
                        copy.setStartHour(Schedulable.hourMinuteToString((int)this.BEGINHOUR, (int)0));
                    }
                    copy.setEndDay(null);
                    if (DateUtil.date2SQLDate((Date)start.getTime()).compareTo(schedule.getEndDay()) != 0 && schedule.getEndHour() != null) {
                        copy.setEndHour(Schedulable.hourMinuteToString((int)this.ENDHOUR, (int)0));
                    }
                    this.schedules.add(copy);
                    start.add(5, 1);
                }
            }
        }
        catch (Exception e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.add(Schedulable schedule)", (String)"agenda.MSG_ADD_SCHEDULE_FAILED", (String)("id=" + schedule.getId() + ", name=" + schedule.getName()), (Throwable)e);
        }
    }

    public String getHtmlView() throws AgendaException {
        if (this.viewType == 1) {
            return this.getHtmlViewByDay(this.startDate);
        }
        if (this.viewType == 2) {
            return this.getHtmlViewByWeek(this.startDate);
        }
        if (this.viewType == 3) {
            return this.getHtmlViewByMonth(this.startDate);
        }
        if (this.viewType == 4) {
            return this.getHtmlViewByYear(this.startDate);
        }
        return "";
    }

    public String getHtmlViewByMonth(String startDate) {
        SilverTrace.debug((String)"agenda", (String)"AgendaHtmView.getHtmlViewByMonth(String startDate)", (String)("schedules" + this.schedules.size()));
        if (this.calendarHtmlView == null) {
            this.calendarHtmlView = new CalendarHtmlView();
        }
        try {
            this.calendarHtmlView.setShortName(false);
            this.calendarHtmlView.setNavigationBar(false);
            this.calendarHtmlView.setMonthVisible(false);
            this.calendarHtmlView.setWeekDayStyle("class=\"txtnav\"");
            this.calendarHtmlView.setMonthDayStyle("class=\"intfdcolor4\"");
            this.calendarHtmlView.setMonthSelectedDayStyle("class=\"intfdcolor6\"");
            StringBuffer result = new StringBuffer("");
            result.append("\t\t\t<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"98%\">\n");
            result.append("\t\t\t\t<tr> \n");
            result.append("\t\t\t\t\t<td> \n");
            result.append("\t\t\t\t\t\t<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">\n");
            result.append("\t\t\t\t\t\t\t<tr>\n");
            result.append("\t\t\t\t\t\t\t\t<td class=\"grille\">\n");
            result.append("\t\t\t\t\t\t\t\t\t<table border=\"0\" cellpadding=\"0\" cellspacing=\"1\" class=\"intfdcolor\" width=\"100%\">\n");
            result.append("\t\t\t\t\t\t\t\t\t\t<tr>\n");
            result.append("\t\t\t\t\t\t\t\t\t\t\t<td align=\"center\" class=\"grille\"> ");
            result.append(this.calendarHtmlView.getHtmlView(DateUtil.parse((String)startDate), this.agendaSessionController));
            result.append("\t\t\t\t\t\t\t\t\t\t\t</td>");
            result.append("                    </tr>");
            result.append("                  </table>");
            result.append("                </td>");
            result.append("              </tr>");
            result.append("            </table>");
            result.append("          </td>");
            result.append("        </tr>");
            result.append("      </table>");
            return result.toString();
        }
        catch (ParseException e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getHtmlViewByMonth(String startDate)", (String)"agenda.MSG_CANT_GET_VIEW_MONTH", (String)"return= null", (Throwable)e);
            return "";
        }
    }

    public String getHtmlViewByYear(String startDate) {
        CalendarHtmlView calendarHtmlView = new CalendarHtmlView();
        calendarHtmlView.setNavigationBar(false);
        calendarHtmlView.setWeekDayStyle("class=\"txtnav\"");
        calendarHtmlView.setMonthDayStyle("class=\"intfdcolor4\"");
        calendarHtmlView.setMonthSelectedDayStyle("class=\"intfdcolor6\"");
        String result = "";
        result = result + "      <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"98%\">\n";
        result = result + "        <tr> \n";
        result = result + "          <td> \n";
        result = result + "            <table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">\n";
        result = result + "              <tr> \n";
        result = result + "                <td class=\"grille\"> \n";
        result = result + "                  <table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" width=\"100%\">\n";
        String year = startDate.substring(0, 4);
        int month = 1;
        for (int i = 0; i < 3; ++i) {
            result = result + "<tr>";
            for (int j = 0; j < 4; ++j) {
                result = result + "<td bgcolor=\"#ffffff\" align=\"left\" valign=\"top\">";
                try {
                    String m = String.valueOf(month);
                    if (m.length() == 1) {
                        m = "0" + m;
                    }
                    result = result + calendarHtmlView.getHtmlView(DateUtil.parse((String)(year + "/" + m + "/01")), this.agendaSessionController);
                    ++month;
                }
                catch (ParseException e) {
                    SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getHtmlViewByMonth(String startDate)", (String)"agenda.MSG_CANT_GET_VIEW_YEAR", (String)"return= null", (Throwable)e);
                    return "";
                }
                result = result + "</td>\n";
            }
            result = result + "</tr>";
        }
        result = result + "                  </table>";
        result = result + "                </td>";
        result = result + "              </tr>";
        result = result + "            </table>";
        result = result + "          </td>";
        result = result + "        </tr>";
        result = result + "      </table>";
        return result;
    }

    public String getHtmlViewByDay(String today) throws AgendaException {
        int i;
        String result = "";
        Calendar day = Calendar.getInstance();
        try {
            day.setTime(DateUtil.parse((String)today));
        }
        catch (ParseException e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getHtmlViewByDay(String today)", (String)"agenda.MSG_CANT_GET_VIEW_DAY", (String)"return= null", (Throwable)e);
            return "";
        }
        SchedulableList dayList = new SchedulableList(DateUtil.date2SQLDate((Date)day.getTime()), this.schedules);
        result = result + "<table border=\"0\" width=\"98%\" cellspacing=\"2\" cellpadding=\"0\" class=\"grille\">\n";
        result = result + "<tr valign=\"top\">";
        result = result + "<td>";
        result = result + "<table border=\"0\" align=\"center\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n";
        result = result + "  <tr>\n";
        result = result + "    <td width=\"100%\">";
        Vector all = dayList.getWithoutHourSchedules();
        result = result + "      <table class=\"grille\" border=\"0\" align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"1\">";
        if (all.size() > 0) {
            for (i = 0; i < all.size(); ++i) {
                Schedulable schedule = (Schedulable)all.elementAt(i);
                result = result + "  <tr>";
                if (i == 0) {
                    result = result + "    <td width=\"50\" rowspan=\"" + all.size() + "\" align=\"right\" bgcolor=\"#FFFFFF\" nowrap=\"nowrap\" valign=\"top\">";
                    result = result + "&nbsp;</td>";
                }
                result = this.isOtherAgenda ? (schedule.getClassification().isPrivate() ? result + "    <td class=\"privateEvent\" width=\"600\">" : result + "    <td class=\"publicEvent\" width=\"600\">") : result + "    <td class=\"intfdcolor4\" width=\"600\">";
                if (schedule.getClassification().isPublic() || !this.isOtherAgenda) {
                    result = result + "      <a href=\"javascript:onClick=viewJournal('" + schedule.getId() + "')\"";
                    result = result + this.getInfoBulle(schedule);
                    result = result + EncodeHelper.javaStringToHtmlString((String)schedule.getName()) + "</a>";
                }
                result = result + " &nbsp;(" + this.agendaSessionController.getString("allDay") + ")    </td>";
                result = result + "</tr>\n";
            }
        } else {
            result = result + "  <tr>";
            result = result + "    <td width=\"50\" align=\"right\" bgcolor=\"#FFFFFF\" nowrap=\"nowrap\" valign=\"top\">";
            result = result + "&nbsp;</td>";
            result = result + "    <td class=\"intfdcolor4\" width=\"600\">";
            result = result + "&nbsp;";
            result = result + "    </td>";
            result = result + "  </tr>\n";
        }
        result = result + "      </table>\n";
        result = result + "    </td>";
        result = result + "  </tr>\n";
        result = result + "<tr> ";
        result = result + "<td class=\"intfdcolor3\"><img src=\"icons/1px.gif\" height=\"2\" width=\"1\" alt=\"\"/></td>";
        result = result + "</tr>\n";
        int maxColumns = 0;
        ArrayList<Schedulable> lastGoOn = null;
        for (i = this.BEGINHOUR; i < this.ENDHOUR; ++i) {
            String hour = Schedulable.quaterCountToHourString((int)(i * 4));
            String nextHour = Schedulable.quaterCountToHourString((int)(i * 4 + 4));
            JournalHeader thisHour = new JournalHeader("", "");
            thisHour.setStartDate(day.getTime());
            try {
                thisHour.setStartHour(hour);
                thisHour.setEndHour(nextHour);
            }
            catch (Exception e) {
                throw new AgendaRuntimeException("AgendaHtmView.getHtmlViewByDay(String today)", 4, "agenda.EX_CANT_GET_VIEW_DAY", e);
            }
            dayList.getStartingSchedules(hour, nextHour);
            ArrayList<Schedulable> goOn = new ArrayList<Schedulable>();
            for (int dayListIterator = 0; dayListIterator < this.schedules.size(); ++dayListIterator) {
                Schedulable sched = this.schedules.elementAt(dayListIterator);
                if (!sched.isOver((Schedulable)thisHour)) continue;
                goOn.add(sched);
            }
            if (!goOn.isEmpty() && maxColumns == 0) {
                int countColumns;
                maxColumns = 1;
                int maxTime = 0;
                JournalHeader tmpThisHour = new JournalHeader("", "");
                tmpThisHour.setStartDate(day.getTime());
                do {
                    String tmpHour = Schedulable.quaterCountToHourString((int)((i + maxTime) * 4));
                    String tmpNextHour = Schedulable.quaterCountToHourString((int)((i + maxTime + 1) * 4));
                    try {
                        tmpThisHour.setStartHour(tmpHour);
                        tmpThisHour.setEndHour(tmpNextHour);
                    }
                    catch (Exception e) {
                        throw new AgendaRuntimeException("AgendaHtmView.getHtmlViewByDay(String today)", 4, "agenda.EX_CANT_GET_VIEW_DAY", e);
                    }
                    countColumns = 0;
                    for (int iterator = 0; iterator < this.schedules.size(); ++iterator) {
                        Schedulable sched = this.schedules.elementAt(iterator);
                        if (!sched.isOver((Schedulable)tmpThisHour)) continue;
                        ++countColumns;
                    }
                    if (countColumns > maxColumns) {
                        maxColumns = countColumns;
                    }
                    ++maxTime;
                } while (countColumns != 0);
            }
            if (lastGoOn == null) {
                result = result + "  <tr>";
                result = result + "    <td>";
                result = result + "      <table class=\"grille\" border=\"0\" align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"1\">\n";
            } else if (goOn.size() != 0 && lastGoOn.size() == 0 || goOn.size() == 0 && lastGoOn.size() != 0) {
                result = result + "      </table>\n";
                result = result + "    </td>";
                result = result + "  </tr>\n";
                result = result + "  <tr>";
                result = result + "    <td>";
                result = result + "      <table class=\"grille\" border=\"0\" align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"1\">\n";
            }
            result = result + "       <tr>";
            result = result + "        <td width=\"50\" align=\"right\" bgcolor=\"#FFFFFF\" nowrap=\"nowrap\" valign=\"top\">";
            result = result + "<a href=\"javascript:onClick=selectHour('" + i + "')\">";
            result = result + String.valueOf(i) + "H</a>";
            result = result + "        </td>";
            if (goOn.isEmpty()) {
                result = result + "        <td class=\"intfdcolor4\" width=\"600\">&nbsp;</td>";
                maxColumns = 0;
            } else {
                for (Schedulable schedule : goOn) {
                    boolean start = true;
                    if (lastGoOn != null && lastGoOn.contains(schedule)) {
                        start = false;
                    }
                    if (!start) continue;
                    int length = 0;
                    JournalHeader tmpThisHour = new JournalHeader("", "");
                    tmpThisHour.setStartDate(day.getTime());
                    do {
                        String tmpHour = Schedulable.quaterCountToHourString((int)((i + ++length) * 4));
                        String tmpNextHour = Schedulable.quaterCountToHourString((int)((i + length + 1) * 4));
                        try {
                            tmpThisHour.setStartHour(tmpHour);
                            tmpThisHour.setEndHour(tmpNextHour);
                        }
                        catch (Exception e) {
                            throw new AgendaRuntimeException("AgendaHtmView.getHtmlViewByDay(String today)", 4, "agenda.EX_CANT_GET_VIEW_DAY", e);
                        }
                    } while (tmpThisHour.isOver(schedule));
                    String color = "intfdcolor2";
                    for (int iterator = 0; iterator < this.schedules.size(); ++iterator) {
                        Schedulable sched = this.schedules.elementAt(iterator);
                        if (sched.getId().equals(schedule.getId()) || !sched.isOver(schedule)) continue;
                        color = "intfdcolor2";
                    }
                    if (this.isOtherAgenda) {
                        color = "publicEvent";
                        if (schedule.getClassification().isPrivate()) {
                            color = "privateEvent";
                        }
                    }
                    result = result + "<td width=\"" + 600 / maxColumns + "\" class=\"" + color + "\" rowspan=\"" + length + "\">";
                    if (this.isOtherAgenda) {
                        if (schedule.getClassification().isPrivate()) {
                            result = !schedule.getEndHour().equals(schedule.getStartHour()) ? result + schedule.getStartHour() + " - " + schedule.getEndHour() + "<br/>" : result + schedule.getStartHour() + "<br/>";
                        } else {
                            result = result + "      <a href=\"javascript:onClick=viewJournal('" + schedule.getId() + "')\"";
                            result = result + this.getInfoBulle(schedule);
                            result = !schedule.getEndHour().equals(schedule.getStartHour()) ? result + schedule.getStartHour() + " - " + schedule.getEndHour() + "<br/>" : result + schedule.getStartHour() + "<br/>";
                            result = result + EncodeHelper.javaStringToHtmlString((String)schedule.getName()) + "</a>";
                        }
                    } else {
                        result = result + "      <a href=\"javascript:onClick=viewJournal('" + schedule.getId() + "')\"";
                        result = result + this.getInfoBulle(schedule);
                        result = !schedule.getEndHour().equals(schedule.getStartHour()) ? result + schedule.getStartHour() + " - " + schedule.getEndHour() + "<br/>" : result + schedule.getStartHour() + "<br/>";
                        result = result + EncodeHelper.javaStringToHtmlString((String)schedule.getName()) + "</a>";
                    }
                    result = result + "</td>";
                }
                for (int maxColumnsIterator = goOn.size(); maxColumnsIterator < maxColumns; ++maxColumnsIterator) {
                    result = result + "        <td class=\"intfdcolor4\" width=\"" + 600 / maxColumns + "\">&nbsp;</td>";
                }
            }
            result = result + "       </tr>\n";
            lastGoOn = goOn;
        }
        result = result + " </table></td></tr>\n";
        result = result + "</table>\n";
        result = result + "</td>";
        result = this.calendarVisible ? result + "<td width=\"100\" class=\"intfdcolor2\">\n" : result + "<td width=\"10\" class=\"intfdcolor2\">\n";
        result = result + "<!-- [ CALENDRIER ] --> \n";
        result = result + " <table width=\"100%\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n";
        result = result + " <tr> \n";
        result = result + "  <td>\n";
        result = result + "   <table class=\"intfdcolor2\" border=\"0\" cellpadding=\"1\" cellspacing=\"0\">";
        result = result + "    <tr> ";
        result = result + "     <td align=\"right\" class=\"intfdcolor2\">";
        result = !this.calendarVisible ? result + "        <a href=\"javascript:onClick=openCalendar()\"><img src=\"icons/cal_open.gif\" width=\"16\" height=\"14\" border=\"0\" alt=\"Afficher le calendrier\" title=\"Afficher le calendrier\"/></a> \n" : result + "        <a href=\"javascript:onClick=closeCalendar()\"><img src=\"icons/croix3.gif\" width=\"16\" height=\"14\" border=\"0\" alt=\"Fermer le calendrier\" title=\"Fermer le calendrier\"/></a> \n";
        result = result + "     </td>";
        result = result + "    </tr> ";
        if (this.calendarVisible) {
            result = result + "    <tr> ";
            result = result + "     <td>";
            result = result + "       <table border=\"0\" cellpadding=\"0\" cellspacing=\"1\" class=\"intfdcolor\"> \n";
            result = result + "        <tr><td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
            result = result + "         <tr>\n";
            result = result + "            <td align=\"center\" class=\"txtbigdate\">" + day.get(5);
            result = result + "            </td></tr>";
            result = result + "            <tr><td align=\"center\" class=\"txtnav3\">" + this.agendaSessionController.getString("mois" + day.get(2));
            result = result + "            </td></tr>";
            result = result + "            <tr><td align=\"center\" class=\"txtnav3\">" + DateUtil.getInputDate((Date)day.getTime(), (String)this.agendaSessionController.getLanguage());
            result = result + "            </td></tr>\n";
            result = result + "            <tr><td>\n";
            try {
                result = result + new CalendarHtmlView().getHtmlView(DateUtil.parse((String)today), this.agendaSessionController);
            }
            catch (Exception e) {
                // empty catch block
            }
            result = result + "             </td></tr>\n";
            result = result + "           </table></td></tr>\n";
            result = result + "         </table>\n";
            result = result + "     </td></tr>\n";
        }
        result = result + "    </table>\n";
        result = result + " </td></tr>\n";
        result = result + "</table>\n";
        result = result + "</td>";
        result = result + "</tr>\n";
        result = result + "</table>";
        return result;
    }

    public String getHtmlViewByWeek(String firstDay) throws AgendaException {
        int i;
        StringBuilder result = new StringBuilder();
        SchedulableList[] dayList = new SchedulableList[this.WEEKDAYNUMBER];
        result.append("<table border=\"0\" width=\"98%\" cellspacing=\"0\" cellpadding=\"2\" class=\"grille\">\n");
        result.append("<tr>");
        result.append("<td>");
        result.append("<table border=\"0\" align=\"center\" width=\"100%\" cellspacing=\"1\" cellpadding=\"1\">\n");
        result.append("  <tr bgcolor=\"#ffffff\">\n");
        result.append("    <td rowspan=\"2\" align=\"right\" valign=\"bottom\"> <img src=\"icons/1px.gif\" alt=\"\"/><br/>");
        result.append("</td>\n");
        Calendar day = Calendar.getInstance();
        try {
            day.setTime(DateUtil.parse((String)firstDay));
        }
        catch (ParseException e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getHtmlViewByWeek(String firstDay)", (String)"agenda.MSG_CANT_GET_VIEW_WEKK", (String)"return= null", (Throwable)e);
            return "";
        }
        for (i = 0; i < this.WEEKDAYNUMBER; ++i) {
            if (this.agendaSessionController.isHolidayDate(day.getTime())) {
                result.append("<td class=\"intfdcolor4\" valign=\"bottom\" width=\"14%\" align=\"center\">");
                result.append("<span ");
                result.append(this.weekDayOffStyle).append(">").append(this.agendaSessionController.getString("jour" + day.get(7)).substring(0, 3));
                result.append(" ").append(day.get(5)).append("</span>");
            } else {
                result.append("    <td class=\"intfdcolor2\" valign=\"bottom\" width=\"14%\" align=\"center\">");
                result.append("<a href=\"javascript:onClick=selectDay('").append(DateUtil.getInputDate((Date)day.getTime(), (String)this.agendaSessionController.getLanguage())).append("')\" class=\"txtnav\">");
                result.append(this.agendaSessionController.getString("jour" + day.get(7)).substring(0, 3));
                result.append(" ").append(day.get(5));
                result.append("</a>");
                dayList[i] = new SchedulableList(DateUtil.date2SQLDate((Date)day.getTime()), this.schedules);
            }
            result.append("</td>\n");
            day.add(5, 1);
        }
        result.append("  </tr>\n");
        result.append("  <tr>");
        for (int j = 0; j < this.WEEKDAYNUMBER; ++j) {
            result.append("    <td class=\"intfdcolor4\">");
            AbstractList all = new ArrayList();
            if (dayList[j] != null) {
                all = dayList[j].getWithoutHourSchedules();
            }
            if (all.size() > 0) {
                result.append("      <table>");
                for (Schedulable schedule : all) {
                    result.append("  <tr>");
                    if (this.isOtherAgenda && schedule.getClassification().isPrivate()) {
                        result.append("    <td class=\"privateEvent\">").append(this.agendaSessionController.getString("privateEvent"));
                    } else {
                        if (this.isOtherAgenda) {
                            result.append("    <td class=\"publicEvent\">");
                        } else {
                            result.append("    <td>");
                        }
                        result.append("      <a href=\"javascript:onClick=viewJournal('").append(schedule.getId()).append("')\"");
                        result.append(this.getInfoBulle(schedule));
                        result.append(EncodeHelper.javaStringToHtmlString((String)schedule.getName()));
                        result.append("      </a>");
                    }
                    result.append("  </td></tr>\n");
                }
                result.append("      </table>");
            } else {
                result.append("&nbsp;");
            }
            result.append("    </td>");
        }
        result.append("  </tr>\n");
        result.append("<tr> ");
        result.append("<td colspan=\"8\" class=\"intfdcolor3\"><img src=\"icons/1px.gif\" height=\"2\" width=\"1\" alt=\"\"/></td>");
        result.append("</tr>\n");
        for (i = this.BEGINHOUR; i < this.ENDHOUR; ++i) {
            result.append(" <tr>");
            result.append("<td align=\"right\" bgcolor=\"#FFFFFF\" nowrap=\"nowrap\" valign=\"top\">");
            result.append("<span class=\"intfdcolor4\">");
            result.append(String.valueOf(i)).append("H");
            result.append("</span></td>");
            String hour = Schedulable.quaterCountToHourString((int)(i * 4));
            String nextHour = Schedulable.quaterCountToHourString((int)(i * 4 + 4));
            for (int j = 0; j < this.WEEKDAYNUMBER; ++j) {
                String nexte;
                Vector starting = new Vector();
                if (dayList[j] != null) {
                    starting = dayList[j].getStartingSchedules(hour, nextHour);
                }
                if (starting.isEmpty()) {
                    if (dayList[j] != null) {
                        Vector goOn = dayList[j].getGoOnSchedules(hour, nextHour);
                        if (!goOn.isEmpty()) continue;
                        result.append("<td class=\"intfdcolor4\">&nbsp;</td>");
                        continue;
                    }
                    result.append("<td class=\"intfdcolor51\">&nbsp;</td>");
                    continue;
                }
                String color = "intfdcolor2";
                int maxRowSpan = 0;
                StringBuilder tmpResult = new StringBuilder();
                for (int m = 0; m < starting.size(); ++m) {
                    int rowSpan;
                    Object startObj = starting.elementAt(m);
                    if (startObj instanceof Schedulable) {
                        Schedulable schedule = (Schedulable)startObj;
                        rowSpan = this.getDuration(schedule);
                        if (rowSpan > maxRowSpan) {
                            maxRowSpan = rowSpan;
                        }
                        if (this.isOtherAgenda && schedule.getClassification().isPrivate()) {
                            if (starting.size() == 1) {
                                tmpResult.append(schedule.getStartHour()).append("<br/>");
                            }
                            color = "privateEvent";
                        } else {
                            if (this.isOtherAgenda) {
                                color = "publicEvent";
                            }
                            tmpResult.append("<a href=\"javascript:onClick=viewJournal('").append(schedule.getId()).append("')\"");
                            tmpResult.append(this.getInfoBulle(schedule));
                            if (starting.size() == 1) {
                                tmpResult.append(schedule.getStartHour()).append("<br/>");
                            }
                            tmpResult.append(EncodeHelper.javaStringToHtmlString((String)schedule.getName())).append("</a>");
                        }
                    } else if (startObj instanceof SchedulableGroup) {
                        SchedulableGroup group = (SchedulableGroup)startObj;
                        color = "intfdcolor2";
                        rowSpan = this.getDuration(group);
                        if (rowSpan > maxRowSpan) {
                            maxRowSpan = rowSpan;
                        }
                        for (int k = 0; k < group.getContent().size(); ++k) {
                            Schedulable schedule = (Schedulable)group.getContent().elementAt(k);
                            if (this.isOtherAgenda && schedule.getClassification().isPrivate()) {
                                color = "privateEvent";
                            } else {
                                if (this.isOtherAgenda) {
                                    color = "publicEvent";
                                }
                                tmpResult.append("<a href=\"javascript:onClick=viewJournal('").append(schedule.getId()).append("')\"");
                                tmpResult.append(this.getInfoBulle(schedule));
                                tmpResult.append(EncodeHelper.javaStringToHtmlString((String)schedule.getName())).append("</a>\n");
                            }
                            if (k + 1 >= group.getContent().size()) continue;
                            tmpResult.append("<br/>");
                        }
                    }
                    if (m + 1 >= starting.size()) continue;
                    tmpResult.append("<br/>");
                }
                String nexts = Schedulable.quaterCountToHourString((int)((i + (maxRowSpan = maxRowSpan + 3 >> 2) - 1) * 4));
                Vector nextStarting = dayList[j].getStartingSchedules(nexts, nexte = Schedulable.quaterCountToHourString((int)((i + maxRowSpan) * 4)));
                if (nextStarting.size() > 0 && maxRowSpan > 1) {
                    --maxRowSpan;
                }
                result.append("<td class=\"").append(color).append("\" rowspan=\"").append(maxRowSpan).append("\">");
                result.append((CharSequence)tmpResult);
                result.append("</td>");
            }
            result.append("  </tr>\n");
        }
        result.append("  <tr bgcolor=\"#ffffff\">\n");
        result.append("    <td rowspan=\"2\" align=\"right\" valign=\"bottom\"> <img src=\"icons/1px.gif\" alt=\"\"/><br/>");
        result.append("</td>\n");
        try {
            day.setTime(DateUtil.parse((String)firstDay));
        }
        catch (ParseException e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getHtmlViewByWeek(String firstDay)", (String)"agenda.MSG_CANT_GET_VIEW_WEEK", (String)"return= null", (Throwable)e);
            return "";
        }
        for (i = 0; i < this.WEEKDAYNUMBER; ++i) {
            result.append("    <td valign=\"bottom\" width=\"14%\" align=\"center\">");
            if (this.agendaSessionController.isHolidayDate(day.getTime())) {
                result.append("<span ");
                result.append(this.dayOffStyle).append(">").append(this.agendaSessionController.getString("jour" + day.get(7)).substring(0, 3));
                result.append(" ").append(day.get(5));
                result.append("</span>");
            } else {
                result.append("<a href=\"javascript:onClick=selectDay('").append(DateUtil.getInputDate((Date)day.getTime(), (String)this.agendaSessionController.getLanguage())).append("')\">");
                result.append(this.agendaSessionController.getString("jour" + day.get(7)).substring(0, 3));
                result.append(" ").append(day.get(5));
                result.append("</a>");
                dayList[i] = new SchedulableList(DateUtil.date2SQLDate((Date)day.getTime()), this.schedules);
            }
            result.append("</td>\n");
            day.add(5, 1);
        }
        result.append("  </tr>\n");
        result.append("</table>");
        result.append("</td>");
        result.append("</tr>\n");
        result.append("</table>");
        return result.toString();
    }

    private int getDuration(Schedulable schedule) {
        try {
            String sHour = schedule.getStartHour().substring(0, 3) + "00";
            long startTime = DateUtil.parseDateTime((String)(schedule.getStartDay() + " " + sHour)).getTime();
            String eHour = schedule.getEndHour();
            if (!eHour.substring(3, 5).equals("00")) {
                eHour = eHour.substring(0, 3) + "45";
            }
            long endTime = DateUtil.parseDateTime((String)(schedule.getEndDay() + " " + eHour)).getTime();
            long ms = endTime - startTime;
            return (int)(ms / 900000L);
        }
        catch (Exception e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getDuration(Schedulable schedule)", (String)"agenda.MSG_CANT_DURATION", (String)("id=" + schedule.getId() + " return=0"), (Throwable)e);
            return 0;
        }
    }

    private int getDuration(SchedulableGroup group) {
        try {
            String sHour = group.getStartHour().substring(0, 3) + "00";
            long startTime = DateUtil.parseTime((String)sHour).getTime();
            String eHour = group.getEndHour();
            if (!eHour.substring(3, 5).equals("00")) {
                eHour = eHour.substring(0, 3) + "45";
            }
            long endTime = DateUtil.parseTime((String)eHour).getTime();
            long ms = endTime - startTime;
            return (int)(ms / 900000L);
        }
        catch (Exception e) {
            SilverTrace.warn((String)"agenda", (String)"AgendaHtmView.getDuration(SchedulableGroup group)", (String)"agenda.MSG_CANT_DURATION", (String)"return=0", (Throwable)e);
            return 0;
        }
    }

    private String getInfoBulle(Schedulable schedule) throws AgendaException {
        Collection<Category> categories = this.agendaSessionController.getJournalCategories(schedule.getId());
        if (!StringUtil.isDefined((String)schedule.getDescription()) && categories.isEmpty()) {
            return ">";
        }
        String categs = "";
        for (Category categorie : categories) {
            categs = categs + categorie.getName() + "&nbsp;";
        }
        StringBuilder result = new StringBuilder("onmouseover=\"return overlib('");
        result.append(EncodeHelper.javaStringToJsString((String)EncodeHelper.javaStringToHtmlParagraphe((String)schedule.getDescription())));
        result.append("',CAPTION,'").append(EncodeHelper.javaStringToJsString((String)categs)).append("');\" onmouseout=\"return nd();\">");
        return result.toString();
    }
}

