/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.agenda.view;

import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.webactiv.agenda.control.AgendaRuntimeException;
import com.stratelia.webactiv.agenda.control.AgendaSessionController;
import com.stratelia.webactiv.calendar.model.JournalHeader;
import com.stratelia.webactiv.calendar.model.SchedulableCount;
import com.stratelia.webactiv.util.DateUtil;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class CalendarHtmlView {
    private Vector<SchedulableCount> scheduleCounts = new Vector();
    private boolean navigationBar = true;
    private boolean shortName = true;
    private boolean monthVisible = true;
    private String weekDayStyle = "class=\"txtnav\"";
    private String dayOffStyle = "class=\"txtdayoff1\"";
    private String dayOffStyleDayView = "class=\"txtdayoff3\"";
    private String weekDayOffStyle = "class=\"txtdayoff2\"";
    private String monthDayStyle = "class=\"txtnav3\"";
    private String monthDayStyleEvent = "class=\"intfdcolor6\"";
    private String context = "";

    public CalendarHtmlView() {
    }

    public CalendarHtmlView(String context) {
        this.context = context + URLManager.getURL((String)"agenda");
    }

    public void add(SchedulableCount scheduleCount) {
        this.scheduleCounts.add(scheduleCount);
    }

    public SchedulableCount getSchedulableCount(int day) {
        String d = String.valueOf(day);
        if (d.length() == 1) {
            d = "0" + d;
        }
        for (int i = 0; i < this.scheduleCounts.size(); ++i) {
            SchedulableCount count = this.scheduleCounts.elementAt(i);
            if (!count.getDay().endsWith(d)) continue;
            return count;
        }
        return null;
    }

    public void setWeekDayStyle(String value) {
        this.weekDayStyle = value;
    }

    public void setMonthDayStyle(String value) {
        this.monthDayStyle = value;
    }

    public void setMonthSelectedDayStyle(String value) {
    }

    public void setMonthVisible(boolean value) {
        this.monthVisible = value;
    }

    public void setNavigationBar(boolean value) {
        this.navigationBar = value;
    }

    public void setShortName(boolean value) {
        this.shortName = value;
    }

    public String getHtmlView(Date date, AgendaSessionController agendaSessionController) {
        return this.getHtmlView(date, agendaSessionController, false);
    }

    public String getPDAView(Date date, AgendaSessionController agendaSessionController) {
        return this.getHtmlView(date, agendaSessionController, true);
    }

    public String getHtmlView(Date date, AgendaSessionController agendaSessionController, boolean forPda) {
        int i;
        boolean viewByDay = 1 == agendaSessionController.getCurrentDisplayType();
        StringBuilder result = new StringBuilder(255);
        List<Date> nonSelectableDays = agendaSessionController.getNonSelectableDays();
        List<String> hiddenDays = null;
        try {
            hiddenDays = agendaSessionController.getHolidaysDates();
        }
        catch (RemoteException e) {
            throw new AgendaRuntimeException("CalendarView.getHtmlView()", 4, "agenda.MSG_GET_DAYS_OFF_FAILED", e);
        }
        int firstDayOfWeek = Integer.parseInt(agendaSessionController.getString("weekFirstDay"));
        if (!this.shortName) {
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">");
        } else {
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\">");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int month = calendar.get(2);
        int year = calendar.get(1);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        int numDays = calendar.get(5);
        calendar.setTime(date);
        int startDay = 1;
        calendar.set(5, 1);
        while (calendar.get(7) != firstDayOfWeek) {
            calendar.add(5, -1);
            ++startDay;
        }
        if (this.monthVisible) {
            result.append("<tr class=\"txtnav2\"><td colspan=\"7\">\n");
            result.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
            if (this.navigationBar) {
                result.append("<td class=\"intfdcolor3\" align=\"right\"><a href=\"javascript:onClick=gotoPreviousMonth()\"");
                if (forPda) {
                    result.append(" onmouseout=\"MM_swapImgRestore()\" onmouseover=\"MM_swapImage('fle-2','','").append(this.getContext()).append("icons/cal_fle-gon.gif',1)\"");
                }
                result.append("><img name=\"fle-2\" border=\"0\" src=\"").append(this.getContext()).append("icons/cal_fle-goff.gif\" width=\"8\" height=\"14\" alt=\"\"/></a></td> \n");
            }
            result.append("<td class=\"intfdcolor3\" align=\"center\"><span class=\"txtNav4\">").append(agendaSessionController.getString("mois" + month)).append(" ").append(year).append("</span></td>");
            if (this.navigationBar) {
                result.append("<td class=\"intfdcolor3\" align=\"left\"><a href=\"javascript:onClick=gotoNextMonth()\"");
                if (forPda) {
                    result.append(" onmouseout=\"MM_swapImgRestore()\" onmouseover=\"MM_swapImage('fle-1','','").append(this.getContext()).append("icons/cal_fle-don.gif',1)\"");
                }
                result.append("><img name=\"fle-1\" border=\"0\" src=\"").append(this.getContext()).append("icons/cal_fle-doff.gif\" width=\"8\" height=\"14\" alt=\"\"/></a></td>\n");
            }
            result.append("</tr></table>\n");
            result.append("</td></tr>");
        }
        result.append("<tr class=\"intfdcolor2\">\n");
        do {
            if (agendaSessionController.isSameDaysAreHolidays(calendar, month)) {
                result.append("<th ").append(this.weekDayOffStyle).append(">");
            } else {
                result.append("<th ").append(this.weekDayStyle).append(">");
            }
            if (this.shortName) {
                result.append(agendaSessionController.getString("shortJour" + calendar.get(7)));
            } else {
                result.append(agendaSessionController.getString("jour" + calendar.get(7)));
            }
            result.append("</th>");
            calendar.add(5, 1);
        } while (calendar.get(7) != firstDayOfWeek);
        result.append("</tr>\n");
        result.append("<tr>\n");
        int column = 0;
        for (int i2 = 0; i2 < startDay - 1; ++i2) {
            result.append("<td ").append(this.monthDayStyle).append(" width=\"14%\">&nbsp;</td>");
            ++column;
        }
        calendar.setTime(date);
        String dayStyle = this.monthDayStyle;
        HashSet<Integer> dayWithEvents = new HashSet<Integer>();
        try {
            Collection<JournalHeader> events = agendaSessionController.getMonthSchedulables(date);
            for (JournalHeader event : events) {
                Calendar calendarEvents = Calendar.getInstance();
                calendarEvents.setTime(event.getStartDate());
                int currentMonth = calendar.get(2);
                while (calendarEvents.getTime().compareTo(event.getEndDate()) <= 0) {
                    if (calendarEvents.get(2) == currentMonth) {
                        int dayNumber = calendarEvents.get(5);
                        dayWithEvents.add(dayNumber);
                    }
                    calendarEvents.add(5, 1);
                }
            }
            dayStyle = this.monthDayStyleEvent;
        }
        catch (RemoteException e) {
            throw new AgendaRuntimeException("CalendarView.getHtmlView()", 4, "agenda.MSG_GET_USER_EVENT_BYDAY_FAILED", e);
        }
        boolean isSelectableDate = true;
        Date currentDate = null;
        String d = null;
        SchedulableCount count = null;
        for (i = 1; i <= numDays; ++i) {
            boolean isVisibleDate = true;
            calendar.set(5, i);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            currentDate = calendar.getTime();
            d = DateUtil.getInputDate((Date)currentDate, (String)agendaSessionController.getLanguage());
            count = this.getSchedulableCount(i);
            if (hiddenDays != null && hiddenDays.contains(DateUtil.date2SQLDate((Date)currentDate))) {
                isVisibleDate = false;
            }
            isSelectableDate = !nonSelectableDays.contains(currentDate);
            dayStyle = this.monthDayStyle;
            if (dayWithEvents.contains(new Integer(i))) {
                dayStyle = this.monthDayStyleEvent;
            }
            if (count != null) {
                if (count.getCount() > 0) {
                    if (isVisibleDate) {
                        if (isSelectableDate) {
                            result.append("<td width=\"14%\" ").append(dayStyle).append(" align=\"center\"><a ").append(dayStyle).append(" href=\"javascript:selectDay('").append(d).append("')\">").append(i).append("</a></td>\n");
                        } else {
                            result.append("<td width=\"14%\" class=\"intfdcolor3\" align=\"center\">").append(i).append("</td>\n");
                        }
                    } else {
                        if (viewByDay) {
                            result.append("<td width=\"14%\" class=\"intfdcolor3\" align=\"center\">");
                            this.dayOffStyle = this.dayOffStyleDayView;
                        } else {
                            result.append("<td width=\"14%\" class=\"intfdcolor4\" align=\"center\">");
                        }
                        result.append("<span ").append(this.dayOffStyle).append(">").append(i).append("</span></td>\n");
                    }
                } else if (isVisibleDate) {
                    if (isSelectableDate) {
                        result.append("<td width=\"14%\" ").append(dayStyle).append(" align=\"center\"><a ").append(dayStyle).append(" href=\"javascript:selectDay('").append(d).append("')\">").append(i).append("</a></td>\n");
                    } else {
                        result.append("<td width=\"14%\" class=\"intfdcolor3\" align=\"center\">").append(i).append("</td>\n");
                    }
                } else {
                    if (viewByDay) {
                        result.append("<td width=\"14%\" class=\"intfdcolor3\" align=\"center\">");
                        this.dayOffStyle = this.dayOffStyleDayView;
                    } else {
                        result.append("<td width=\"14%\" class=\"intfdcolor4\" align=\"center\">");
                    }
                    result.append("<span ").append(this.dayOffStyle).append(">").append(i).append("</span></td>\n");
                }
            } else if (isVisibleDate) {
                if (isSelectableDate) {
                    result.append("<td width=\"14%\" ").append(dayStyle).append(" align=\"center\"><a ").append(dayStyle).append(" href=\"javascript:selectDay('").append(d).append("')\">").append(i).append("</a></td>\n");
                } else {
                    result.append("<td width=\"14%\" class=\"intfdcolor3\" align=\"center\">").append(i).append("</td>\n");
                }
            } else {
                if (viewByDay) {
                    result.append("<td width=\"14%\" class=\"intfdcolor3\" align=\"center\">");
                    this.dayOffStyle = this.dayOffStyleDayView;
                } else {
                    result.append("<td width=\"14%\" class=\"intfdcolor4\" align=\"center\">");
                }
                result.append("<span ").append(this.dayOffStyle).append(">").append(i).append("</span></td>\n");
            }
            if (++column != 7 || numDays <= i) continue;
            result.append("</tr>\n<tr>");
            column = 0;
        }
        for (i = column; i <= 6; ++i) {
            result.append("<td ").append(this.monthDayStyle).append(">&nbsp;</td>\n");
        }
        result.append("</tr></table>\n");
        return result.toString();
    }

    public String getContext() {
        return this.context;
    }
}

